### R code from vignette source 'load_matrix.Rnw'

###################################################
### code chunk number 1: setup
###################################################
library(popbio)
library(lattice)
options(warn=-1, width=70, digits=3, scipen=3,  "prompt" = "R> ", "continue" = "  ")

ceco<-c(0,0,5.905,0.368,0.639, 0.025, 0.001, 0.152, 0.051)

x1<-c("Recruit", "0.0000", "(0)", "0.0000", "(0)", "0.0000", "(0)", 
"4.0000", "(0)", "Juvenile", "0.1000", "(2)", "0.9540", "(61)", 
"0.0900", "(2)", "0.0000", "(0)", "Non-flowering", "adult", "0.0000", 
"(0)", "0.0360", "(3)", "0.7010", "(18)", "0.8375", "(5)", "Flowering", 
"adult", "0.0000", "(0)", "0.0000", "(0)", "0.1802", "(6)", "0.1610", 
"(1)")

x2<-c("pod", "n", "G1", "G2", "G3", "P2", "P3", "P4", "F2", "F3", 
"J01", "22", "0.9535", "0.0802", "0.0414", "0.8827", "0.9586", 
"0.9752", "0.0067", "0.1632", "K01", "20", "1.0000", "0.0694", 
"0.0418", "0.9020", "0.9582", "0.9855", "0.0062", "0.1737", "L01", 
"63", "0.9562", "0.0722", "0.0406", "0.9030", "0.9530", "0.9798", 
"0.0037", "0.0988", "A01", "15", "1.0000", "0.0727", "0.0485", 
"0.9015", "0.9515", "0.9667", "0.0043", "0.1148", "A04", "12", 
"0.8165", "0.0774", "0.0485", "0.8903", "0.9515", "0.9810", "0.0042", 
"0.1054", "A05", "10", "1.0000", "0.0730", "0.0485", "0.9123", 
"0.9515", "0.9545", "0.0027", "0.0732", "B01", "8", "1.0000", 
"0.0746", "0.0485", "0.9254", "0.9515", "0.9810", "0.0025", "0.0651", 
"C01", "8", "1.0000", "0.0800", "0.0294", "0.9200", "0.9706", 
"0.9608", "0.0047", "0.1159", "D01", "12", "1.0000", "0.0759", 
"0.0438", "0.9241", "0.9562", "1.0000", "0.0068", "0.1761", "G01", 
"24", "1.0000", "0.0833", "0.0714", "0.9167", "0.9286", "1.0000", 
"0.0061", "0.1418", "G12", "11", "1.0000", "0.0784", "0.0485", 
"0.9216", "0.9515", "0.9810", "0.0050", "0.1251", "H01", "7", 
"1.0000", "0.0746", "0.0485", "0.9254", "0.9515", "0.9810", "0.0021", 
"0.0542", "I01", "7", "1.0000", "0.0714", "0.0485", "0.9286", 
"0.9515", "0.9810", "0.0027", "0.0732", "I02", "7", "1.0000", 
"0.0714", "0.0485", "0.9286", "0.9515", "1.0000", "0.0045", "0.1220", 
"I11", "15", "1.0000", "0.0714", "0.0485", "0.9286", "0.9515", 
"0.9810", "0.0052", "0.1428", "I18", "13", "1.0000", "0.0714", 
"0.0485", "0.9286", "0.9515", "0.9810", "0.0037", "0.0998", "I31", 
"7", "1.0000", "0.0714", "0.0485", "0.9286", "0.9515", "0.9810", 
"0.0047", "0.1273", "R01", "20", "1.0000", "0.0595", "0.0485", 
"0.8929", "0.9515", "1.0000", "0.0024", "0.0797")




###################################################
### code chunk number 2: A
###################################################
A<-c(0, 0.3, 0, 1, 0, 0.5, 5, 0, 0)
A<-matrix(A, nrow=3)


###################################################
### code chunk number 3: ceco
###################################################
stages <- c("seedling", "vegetative", "flowering")
matrix(ceco, nrow=3, byrow=TRUE, dimnames=list(stages,stages))




###################################################
### code chunk number 4: ceco (eval = FALSE)
###################################################
## matrix2<-function(x, stages, byrow=TRUE){
##    matrix(x, nrow=sqrt(length(x)), byrow=byrow, dimnames=list(stages, stages))
## }
## ceco<-matrix2(ceco, stages)


###################################################
### code chunk number 5: write (eval = FALSE)
###################################################
## write.table(ceco, file="ceco.txt")
## ceco<-as.matrix(read.table(file="ceco.txt"))


###################################################
### code chunk number 6: sapu
###################################################
stages<-x1[c(1,10,19,29)]
sapu<-matrix2( as.numeric(grep("^[0-9.]+$", x1, value = TRUE)), stages)
sapu
round(elasticity(sapu)*100)


###################################################
### code chunk number 7: pods
###################################################
x2<-matrix(x2, nrow=19, byrow=TRUE)
pods<-matrix(as.numeric(x2[-1,-(1:2)]), nrow=18)
dimnames(pods)<-list(x2[-1,1], x2[1,-(1:2)] )
head(pods)


###################################################
### code chunk number 8: podA
###################################################
podA<-expression(
  matrix2( c(
   0,  F2, F3, 0,
   G1, P2, 0,  0,
   0,  G2, P3, 0,
   0,  0,  G3, P4), 
    c("yearling", "juvenile", "mature", "postreprod"))) 


###################################################
### code chunk number 9: J01
###################################################
J01 <- eval(podA, as.list(pods[1,]))
J01


###################################################
### code chunk number 10: whales
###################################################
whales <- vector("list", 18)
 names(whales) <- rownames(pods)
 for (i in 1:18) {
  whales[[i]] <- eval(podA, as.list(pods[i,]))
}
print(dotplot( sort(  sapply(whales, lambda)), xlab="Growth rate"))


###################################################
### code chunk number 11: cc95a
###################################################
CC95<-read.table("http://www.esapubs.org/archive/mono/M075/004/CC95.txt", sep=",")


###################################################
### code chunk number 12: cc95
###################################################

CC95<- as.matrix(CC95)
stages<-c("seed", "sdling", "1R", "5R", "10R", "20R", "12cm", "25cm", "50cm", "100cm", "200cm", "200+cm")
dimnames(CC95)<- list(stages,stages)
image2( CC95 , cex=.5, log=FALSE)


###################################################
### code chunk number 13: silene
###################################################

years<-95:99
site<-c("CC", "GU")
pop<-paste(rep(site,each=5),years, sep="")
n<-length(pop)
silene<-vector('list', n) 
names(silene)<-pop
for ( i in 1:n)
{  
   x<-paste("http://www.esapubs.org/archive/mono/M075/004/", pop[i],".txt", sep="")
   y<-as.matrix(read.table(x,  sep=","))
   dimnames(y)<-list(stages,stages)
   silene[[i]]<-y
}

sapply(silene, lambda)


###################################################
### code chunk number 14: arel
###################################################

arel<-readLines("http://www.esapubs.org/archive/ecol/E086/142/appendix-E.htm")
y<-grep(">[0-9.]+<",  arel) 
length(y)


###################################################
### code chunk number 15: arel2
###################################################
x<-gsub("(.*>)([0-9.]+)(<.*)", "\\2", arel[y] )

# convert to number
x<-matrix(as.numeric(x), nrow=13, byrow=TRUE)
stages=c("SD","SG", "SJ", "MJ", "LJ", "PR", "SA", "LA")

FE99<-matrix2( x[1,], stages)
image2(FE99, cex=.5)



###################################################
### code chunk number 16: arel3
###################################################

arel<-split(x,1:13)
arel<-lapply(arel, matrix2, stages)

years<-c("99", "00", "01")
sites<-c("FE", "TF", "HF", "AT")
pop<-c(paste(rep(sites, each=3), years, sep=""), "ST99")
names(arel)<-pop
sapply(arel, lambda)


###################################################
### code chunk number 17: vr
###################################################
 
url<-"http://www.esapubs.org/archive/ecol/E091/011/appendix-B.htm"

vrx<-readLines(url)

## find lines with numbers between html tags
y<-grep(">[0-9.]+<",  vrx, perl=TRUE)  

## remove html and save matrix elements
y<-gsub("(.*>)([0-9.]+)(<.*)", "\\2", vrx[y], perl=TRUE)

# arrange in table
vr<-matrix(as.numeric(y), ncol=15, byrow=TRUE)

# site-year labels (could use grep and gsub again)
n<-substr(vrx[seq(35,665, 18)], 55,64)
rownames(vr)<- gsub(" ", "_", gsub("'", "", n))
colnames(vr)<-c("psi",  "up", "pi", "ep", "d1", "d2", "d3", "d4", "d5", "d6", "g53", "g54", "g64", "g65", "g56")

vr[1:5,1:5]


###################################################
### code chunk number 18: orchid
###################################################
orpu<-expression( matrix2( c(
0,  0,  0,          0,              0,          psi*up*pi*ep,
d1, 0,  0,          0,              0,          0,
0,  d2, 0,          0,              0,          0,
0,  0,  d3*(1-g53), d4*(1-g54-g64), 0,          0,
0,  0,  d3*g53,     d4*g54,         d5*(1-g65), d6*g56,
0,  0,  0,          d4*g64,         d5*g65,     d6*(1-g56)
    ), c("pcorm", "tuber", "sdlng", "juv", "nonfl", "flwer"))
)
s1<-eval(orpu, as.list(vr[1,]) )
s1


