### R code from vignette source 'probemapper-Documentation.Rnw'

###################################################
### code chunk number 1: setup
###################################################
library(probemapper)
conn <- pm.connect("http://qbrc.swmed.edu/ProbeMapper/");


###################################################
### code chunk number 2: geneinfo
###################################################
gene780 <- pm.getGene(conn, entrezID=780);
gene780;


###################################################
### code chunk number 3: listPlat
###################################################
platforms <- pm.getPlatforms(conn);
platforms


###################################################
### code chunk number 4: probeinfoID
###################################################
probe <- pm.getProbe(conn, probeID=1000008);
probe


###################################################
### code chunk number 5: probeinfoName
###################################################
probe <- pm.getProbe(conn, platformID=1, probeName = "1007_s_at");
probe


###################################################
### code chunk number 6: probeToGenes
###################################################
genes <- pm.getGenesByProbe(conn, probeID=2043812);
genes <- pm.getGenesByProbe(conn, platformID=2, probeName="234562_x_at");
genes


###################################################
### code chunk number 7: probemapper-Documentation.Rnw:75-77
###################################################
genes <- pm.getGenesByProbe(conn, probeID=2043812, authorityID=c(1,2));
genes


###################################################
### code chunk number 8: geneToProbes
###################################################
probes <- pm.getProbesByGene(conn, entrezID=780);
probes


###################################################
### code chunk number 9: probemapper-Documentation.Rnw:93-95
###################################################
probes <- pm.getProbesByGene(conn, entrezID=780, authorityID=2, platformID=1)$probes;
probes


###################################################
### code chunk number 10: probemapper-Documentation.Rnw:102-103
###################################################
pm.getProbesByGene(conn, 57188)$probes;


###################################################
### code chunk number 11: probemapper-Documentation.Rnw:108-109
###################################################
pm.getProbesByGene(conn, 57188)$probes[6,];


