### R code from vignette source 'rake-manual.Snw'

###################################################
### code chunk number 1: rake-manual.Snw:36-42
###################################################
library(rake)
data(certify)
certify$COLLEGE[certify$COLLEGE != "P"] <- "N"
certify$WORKENV[!certify$WORKENV %in% c("I", "A")] <- "O"
r <- rake(certify, "COLLEGE", "WORKENV")
print(r)


###################################################
### code chunk number 2: rake-manual.Snw:50-53
###################################################
r <- rakeadj(r, statpoptotal, TRUE)
print(r)
print(r / sum(r) * sum(statpoptotal$weight[ statpoptotal$name == rownames(r) ]))


###################################################
### code chunk number 3: rake-manual.Snw:58-59
###################################################
print(statpoptotal)


###################################################
### code chunk number 4: rake-manual.Snw:67-74
###################################################
for (i in 1:5) {
	cat("Variable:", names(certify)[i], "\n")
	data <- summary(as.factor(certify[, i]))
	pred <- predict(r, i, forcefactor = TRUE)$data.est
	print(rbind(data, pred))
	cat("\n")
}


###################################################
### code chunk number 5: rake-manual.Snw:87-88
###################################################
example(simpleRake)


