### R code from vignette source 'rv-intro.Rnw'

###################################################
### code chunk number 1: rv-intro.Rnw:43-45
###################################################
  set.seed(20100129)
options(digits=2)


###################################################
### code chunk number 2: rv-intro.Rnw:85-86
###################################################
    library(rv)


###################################################
### code chunk number 3: rv-intro.Rnw:102-103
###################################################
rvnsims(4000)


###################################################
### code chunk number 4: rv-intro.Rnw:115-116
###################################################
x <- rvnorm(mean=1:5, sd=1)


###################################################
### code chunk number 5: rv-intro.Rnw:130-131
###################################################
  x


###################################################
### code chunk number 6: rv-intro.Rnw:138-139
###################################################
  y <- rvpois(lambda=10)


###################################################
### code chunk number 7: rv-intro.Rnw:150-156
###################################################
rvmean(x)
rvsd(x)
rvquantile(x, c(0.025,0.25,0.5,0.75,0.975))
rvmedian(x)
rvmin(y)
rvmax(y)


###################################################
### code chunk number 8: rv-intro.Rnw:183-185
###################################################
x[3:4] <- rvbinom(size=1, prob=c(0.1,0.9))
x[3:4]


###################################################
### code chunk number 9: rv-intro.Rnw:195-198
###################################################
y <- as.rv(1:5)
y[3:4] <- x[3:4]
y


###################################################
### code chunk number 10: rv-intro.Rnw:216-217
###################################################
1/(1+exp(-x[1]))


###################################################
### code chunk number 11: rv-intro.Rnw:220-221
###################################################
2*log(abs(x[2]))


###################################################
### code chunk number 12: rv-intro.Rnw:228-233
###################################################
x <- rvpois(lambda=1:5)
x
sort(x)
min(x)
max(x)


###################################################
### code chunk number 13: rv-intro.Rnw:251-256
###################################################
p <- runif(4) # Some prior probabilities.
y <- rvbinom(size=1, prob=p) # y is now a rv of length 4.
dim(y) <- c(2,2) # Make y into a 2x2 matrix.
y
y %**% y


###################################################
### code chunk number 14: rv-intro.Rnw:261-262
###################################################
E(y)


###################################################
### code chunk number 15: rv-intro.Rnw:270-272
###################################################
z <- rvnorm(1)
z > 1


###################################################
### code chunk number 16: rv-intro.Rnw:277-278
###################################################
Pr(z > 1)


###################################################
### code chunk number 17: rv-intro.Rnw:284-286
###################################################
z <- rvnorm(2)
Pr(z[1] > z[2]^2)


###################################################
### code chunk number 18: rv-intro.Rnw:289-291
###################################################
Pr(x[1] > x[2] & x[1] > x[4])
Pr(x[1] > x[2] | x[1] > x[4])


###################################################
### code chunk number 19: rv-intro.Rnw:304-310
###################################################
z <- rvnorm(n=2, mean=0, sd=1)
y <- exp(z)
y[2] <- y[2] * y[1]
x <- (y[1]-1) * (y[1]>1) * (y[2]>1)
E(x)
Pr(x>1)


###################################################
### code chunk number 20: rv-intro.Rnw:320-328
###################################################
  n <- 10
  ## Some covariates
  X <- data.frame(x1=rnorm(n, mean=0), x2=rpois(n, 10) - 10)
  y.mean <- (1.0 + 2.0 * X$x1 + 3.0 * X$x2)
  y <- rnorm(n, y.mean, sd=1.5) ## n random numbers
  D <- cbind(data.frame(y=y), X)
  ## Regression model fit
  fit <- lm(y ~ x1 + x2, data=D)


###################################################
### code chunk number 21: rv-intro.Rnw:331-333
###################################################
  Post <- posterior(fit)
  Post


###################################################
### code chunk number 22: rv-intro.Rnw:349-354
###################################################
sigma <- Post$sigma
betas <- Post$beta
M <- model.matrix(fit)
y.rep <- rvnorm(mean=M %**% betas, sd=sigma)
mlplot(y.rep) # Summarize graphically.


###################################################
### code chunk number 23: rv-intro.Rnw:360-361
###################################################
M %**% betas


###################################################
### code chunk number 24: rv-intro.Rnw:373-375
###################################################
  ## Replications
  y.rep <- rvpredict(fit)


###################################################
### code chunk number 25: rv-intro.Rnw:379-382
###################################################
  ## Predictions at the mean of the covariates
  X.pred <- data.frame(x1=mean(X$x1), x2=mean(X$x2))
  y.pred <- rvpredict(fit, newdata=X.pred)


###################################################
### code chunk number 26: rv-intro.Rnw:386-389
###################################################
  X.rep <- X
  X.rep$x1 <- rnorm(n=n, mean=X.rep$x1, sd=sd(X.rep$x1))
  y.pred2 <- rvpredict(fit, newdata=X.rep)


###################################################
### code chunk number 27: rv-intro.Rnw:416-419
###################################################
  ## Plot predictions
  plot.rv(D$y, y.rep, rvcol="red")
  points.rv(D$y + 0.33, y.pred2, rvcol="blue")


###################################################
### code chunk number 28: rv-intro.Rnw:429-431
###################################################
  mlplot(y.rep, rvcol="red")
  mlplot(D$y, add=TRUE, col="blue", pch="x")


###################################################
### code chunk number 29: rv-intro.Rnw:436-437
###################################################
rvhist(rvnorm(mean=0, sd=1)^3, xlim=c(-3, 3), col="red", main="Cubed standard normal")


###################################################
### code chunk number 30: <
###################################################
  x <- 1
  for (n in 1:100) {
    x <- x + rvbern(n=1, prob=x / (n + 1))
  }


###################################################
### code chunk number 31: rv-intro.Rnw:464-465
###################################################
  rvhist(x / (n + 1)) # Histogram


###################################################
### code chunk number 32: rv-intro.Rnw:476-478
###################################################
s <- sims(y.rep)
dim(s)


###################################################
### code chunk number 33: rv-intro.Rnw:489-490
###################################################
y <- rvsims(s)


