### R code from vignette source 'gallery.Rnw'

###################################################
### code chunk number 1: require
###################################################
require(scapeMCMC)


###################################################
### code chunk number 2: Auto1
###################################################
plotAuto(xmcmc$P$R0)


###################################################
### code chunk number 3: Auto2
###################################################
plotAuto(xmcmc$P$R0, thin=10)


###################################################
### code chunk number 4: Auto3
###################################################
plotAuto(xmcmc$P, lag.max=50, ann=FALSE, axes=FALSE)


###################################################
### code chunk number 5: Cumu1
###################################################
plotCumu(xmcmc$P$R0, main="R0")


###################################################
### code chunk number 6: Cumu2
###################################################
plotCumu(xmcmc$P$cSfull, main="cSfull")


###################################################
### code chunk number 7: Cumu3
###################################################
plotCumu(xmcmc$P, probs=c(0.25,0.50,0.75), ann=FALSE, axes=FALSE)


###################################################
### code chunk number 8: Dens1
###################################################
plotDens(xmcmc$B$"2004", points=TRUE, div=1000, main="2004\n",
         xlab="Biomass age 4+ (1000 t)", tick.number=6, strip=FALSE)


###################################################
### code chunk number 9: Dens2
###################################################
plotDens(xmcmc$P, xlab="Parameter value", ylab="Posterior density\n")


###################################################
### code chunk number 10: Quant1
###################################################
plotQuant(xmcmc$B, style="lines", div=1000, xlab="Year",
          ylab="Biomass age 4+ (1000 t)")


###################################################
### code chunk number 11: Quant2
###################################################
plotQuant(xmcmc$R, names=substring(names(xmcmc$R),3), div=1000,
          xlab="Year", ylab="Recruitment (million one-year-olds)")


###################################################
### code chunk number 12: Splom1
###################################################
plotSplom(xmcmc$P)


###################################################
### code chunk number 13: Splom2
###################################################
plotSplom(xproj$B$"0.25", axes=TRUE, between=1, div=1000,
          main="Future biomass", cex.labels=1.5)


###################################################
### code chunk number 14: Trace1
###################################################
plotTrace(xmcmc$P, xlab="Iterations", ylab="Parameter value",
          layout=c(2,4))


###################################################
### code chunk number 15: Trace2
###################################################
plotTrace(xmcmc$P$R0, axes=TRUE, div=1000)


