### R code from vignette source 'smacof.Rnw'

###################################################
### code chunk number 1: smacof.Rnw:554-558
###################################################
require("smacof")
data("ekman")
ekman.d <- sim2diss(ekman, method = 1)
res.basic <- smacofSym(ekman.d, metric = FALSE)


###################################################
### code chunk number 2: smacof.Rnw:560-561 (eval = FALSE)
###################################################
## res.sphere <- smacofSphere.primal(ekman.d, metric = FALSE)


###################################################
### code chunk number 3: smacof.Rnw:564-566 (eval = FALSE)
###################################################
## plot(res.basic, main = "Configurations Basic SMACOF", asp = 1)
## plot(res.sphere, main = "Configurations Sphere SMACOF", asp = 1)


###################################################
### code chunk number 4: smacof.Rnw:590-595 (eval = FALSE)
###################################################
## wl <- c(434, 445, 465, 472, 490, 504, 537, 555, 584, 600, 610, 628, 651, 674)
## CIE31 <- read.table("http://cvision.ucsd.edu/database/data/cmfs/ciexyz31_1.txt", header = FALSE, sep = ",", colClasses = rep("numeric", 4), nrows = 471)
## names(CIE31) <- c("WL", "xbar", "ybar", "zbar")
## ekmanWL <- subset(CIE31, WL %in% wl)
## ekmanWL[, -1] <- ekmanWL[, -1]/ekmanWL[, "ybar"]


###################################################
### code chunk number 5: smacof.Rnw:600-605 (eval = FALSE)
###################################################
## ekman.mds.wld <- res.basic$confdiss[cumsum(c(1, 13:2))]
## require(grDevices)
## ekmanLuv <- convertColor(ekmanWL[, -1], "XYZ", "Luv")
## Luv.dist <- dist(ekmanLuv)
## Luv.wld <- Luv.dist[cumsum(c(1, 13:2))]


###################################################
### code chunk number 6: smacof.Rnw:610-613 (eval = FALSE)
###################################################
## plot(wl[-14], ekman.mds.wld, type = "b", ylim = c(0.05, 0.9), xlab = "wavelength", ylab = "distance", main = "Ekman MDS vs. Luv")
## lines(wl[-14], Luv.wld/400, col = "red", type = "b")
## legend(600, 0.9, c("Ekman", "Luv"), lty = 1, col = c("black", "red"))


###################################################
### code chunk number 7: smacof.Rnw:622-624
###################################################
data("breakfast")
res.rect <- smacofRect(breakfast, itmax = 1000)


###################################################
### code chunk number 8: smacof.Rnw:627-629 (eval = FALSE)
###################################################
## plot(res.rect, joint = TRUE, xlim = c(-10, 10), asp = 1)
## plot(res.rect, plot.type = "Shepard", asp = 1)


###################################################
### code chunk number 9: smacof.Rnw:649-652
###################################################
data("bread")
res.uc <- smacofIndDiff(bread)
res.uc


###################################################
### code chunk number 10: smacof.Rnw:655-657
###################################################
res.id <- smacofIndDiff(bread, constraint = "identity")
res.id


###################################################
### code chunk number 11: smacof.Rnw:660-664 (eval = FALSE)
###################################################
## plot(res.uc, main = "Group Configurations Unconstrained", xlim = c(-1.2,1), ylim = c(-1.2,1), asp = 1)
## plot(res.id, main = "Group Configurations Identity", xlim = c(-1.2,1), ylim = c(-1.2,1), asp = 1)
## plot(res.uc, plot.type = "resplot", main = "Residuals Unconstrained", xlim = c(2,14), ylim = c(-3,3), asp = 1)
## plot(res.id, plot.type = "resplot", main = "Residuals Indentity", xlim = c(2,14), ylim = c(-3,3), asp = 1)


###################################################
### code chunk number 12: smacof.Rnw:687-691 (eval = FALSE)
###################################################
## data("kinshipdelta")
## data("kinshipscales")
## res.sym <- smacofSym(kinshipdelta)
## res.lin <- smacofConstraint(kinshipdelta, constraint = "linear", external = kinshipscales)


###################################################
### code chunk number 13: smacof.Rnw:694-698 (eval = FALSE)
###################################################
## plot(res.sym, main = "Configuration Plot SMACOF", xlim = c(-1, 1), ylim = c(-1, 1.5), asp = 1)
## plot(res.lin, main = "Configuration Plot SMACOF Constraint",xlim = c(-1, 1), ylim = c(-1, 1.5), asp = 1)
## plot(res.sym, plot.type = "stressplot", main = "Stress Decomposition SMACOF", xlim = c(0, 16), ylim = c(3, 12), asp = 1)
## plot(res.lin, plot.type = "stressplot", main = "Stress Decomposition SMACOF Constraint", xlim = c(0, 16), ylim = c(3, 12), asp = 1)


###################################################
### code chunk number 14: smacof.Rnw:720-723 (eval = FALSE)
###################################################
## data("trading")
## res.sphere <- smacofSphere.dual(trading, ndim = 3)
## plot3d(res.sphere, plot.sphere = FALSE)


