### R code from vignette source 'spacetime.Rnw'
### Encoding: ISO8859-1

###################################################
### code chunk number 1: spacetime.Rnw:66-67
###################################################
options(prompt = "R> ", continue = "+  ", width = 70, useFancyQuotes = FALSE)


###################################################
### code chunk number 2: spacetime.Rnw:171-173
###################################################
library("foreign")
read.dbf(system.file("shapes/sids.dbf", package="maptools"))[1:5,c(5,9:14)]


###################################################
### code chunk number 3: spacetime.Rnw:180-182
###################################################
data("wind", package = "gstat")
wind[1:6,]


###################################################
### code chunk number 4: spacetime.Rnw:195-197
###################################################
data("Produc", package = "plm")
Produc[1:5,]


###################################################
### code chunk number 5: spacetime.Rnw:241-253
###################################################
s = 1:3
t = c(1, 1.5, 3, 4.5)
g = data.frame(rep(t, each=3), rep(s,4))
plot(g, xaxt = 'n', yaxt = 'n', xlab = "Time points", 
	ylab = "Space locations", xlim = c(.5,5), ylim = c(.5,3.5))
abline(h=s, col = grey(.8))
abline(v=t, col = grey(.8))
points(g)
axis(1, at = t, labels = c("1st", "2nd", "3rd", "4th"))
axis(2, at = s, labels = c("1st", "2nd", "3rd"))
text(g, labels = 1:12, pos=4)
title("STFDF (Space-time full data.frame) layout")


###################################################
### code chunk number 6: spacetime.Rnw:277-290
###################################################
s = 1:3
t = c(1, 2.2, 3, 4.5)
g = data.frame(rep(t, each=3), rep(s,4))
sel = c(1,2,3,5,6,7,11)
plot(g[sel,], xaxt = 'n', yaxt = 'n', xlab = "Time points",                
    ylab = "Space locations", xlim = c(.5,5), ylim = c(.5,3.5))
abline(h=s, col = grey(.8))
abline(v=t, col = grey(.8))
points(g[sel,])
axis(1, at = t, labels = c("1st", "2nd", "3rd", "4th"))
axis(2, at = s, labels = c("1st", "2nd", "3rd"))
text(g[sel,], labels = paste(1:length(sel), "[",c(1,2,3,2,3,1,2),",",c(1,1,1,2,2,3,4),"]", sep=""), pos=4)
title("STSDF (Space-time sparse data.frame) layout")


###################################################
### code chunk number 7: spacetime.Rnw:315-329
###################################################
s = c(1,2,3,1,4)
t = c(1, 2.2, 2.5, 4, 4.5)
g = data.frame(t,s)
plot(g, xaxt = 'n', yaxt = 'n', xlab = "Time points",                
    ylab = "Space locations", xlim = c(.5,5), ylim = c(.5,4.5))
#abline(h=s, col = grey(.8))
#abline(v=t, col = grey(.8))
arrows(t,s,0.5,s,.1,col='red')
arrows(t,s,t,0.5,.1,col='red')
points(g)
axis(1, at = sort(unique(t)), labels = c("1st", "2nd", "3rd", "4th", "5th"))
axis(2, at = sort(unique(s)), labels = c("1st,4th", "2nd", "3rd", "5th"))
text(g, labels = 1:5, pos=4)
title("STIDF (Space-time irregular data.frame) layout")


###################################################
### code chunk number 8: spacetime.Rnw:347-359
###################################################
library("spacetime")
showClass("ST")
showClass("STFDF")
sp = cbind(x = c(0,0,1), y = c(0,1,1))
row.names(sp) = paste("point", 1:nrow(sp), sep="")
sp = SpatialPoints(sp)
time = as.POSIXct("2010-08-05", tz = "GMT")+3600*(10:13)
m = c(10,20,30) # means for each of the 3 point locations
mydata = rnorm(length(sp)*length(time),mean=rep(m, 4))
IDs = paste("ID",1:length(mydata), sep = "_")
mydata = data.frame(values = signif(mydata,3), ID=IDs)
stfdf = STFDF(sp, time, mydata)


###################################################
### code chunk number 9: spacetime.Rnw:362-363
###################################################
str(stfdf)


###################################################
### code chunk number 10: spacetime.Rnw:371-373
###################################################
as.data.frame(stfdf, row.names = IDs)
as(stfdf, "data.frame")[1:4,]


###################################################
### code chunk number 11: spacetime.Rnw:384-387
###################################################
unstack(stfdf)
t(unstack(stfdf))
unstack(stfdf, which = 2)


###################################################
### code chunk number 12: spacetime.Rnw:392-393
###################################################
as(stfdf[,,"values"], "xts")


###################################################
### code chunk number 13: spacetime.Rnw:398-400
###################################################
x = as(stfdf[,,"values"], "xts")
index(x)


###################################################
### code chunk number 14: spacetime.Rnw:407-409
###################################################
x = as(stfdf[,,"values"], "xts")
apply(x, 1, mean)


###################################################
### code chunk number 15: spacetime.Rnw:412-413
###################################################
apply(x, 2, mean)


###################################################
### code chunk number 16: spacetime.Rnw:420-421 (eval = FALSE)
###################################################
## vignette("sto")


###################################################
### code chunk number 17: spacetime.Rnw:435-442
###################################################
stfdf[[1]]
stfdf[["values"]]
stfdf[["newVal"]] = rnorm(12)
stfdf$ID
stfdf$ID = paste("OldIDs", 1:12, sep="")
stfdf$NewID = paste("NewIDs", 12:1, sep="")
stfdf


###################################################
### code chunk number 18: spacetime.Rnw:460-466
###################################################
stfdf[,1] # SpatialPointsDataFrame
stfdf[,,1]
stfdf[1,,1] # xts
stfdf[,,"ID"]
stfdf[1,,"values", drop = FALSE] # stays STFDF:
stfdf[,1, drop=FALSE] #stays STFDF


###################################################
### code chunk number 19: spacetime.Rnw:480-481
###################################################
showClass("STSDF")


###################################################
### code chunk number 20: spacetime.Rnw:494-505
###################################################
showClass("STIDF")
sp = expand.grid(x = 1:3, y = 1:3)
row.names(sp) = paste("point", 1:nrow(sp), sep="")
sp = SpatialPoints(sp)
time = as.POSIXct("2010-08-05", tz = "GMT")+3600*(11:19)
m = 1:9 * 10 # means for each of the 9 point locations
mydata = rnorm(length(sp), mean=m)
IDs = paste("ID",1:length(mydata))
mydata = data.frame(values = signif(mydata,3),ID=IDs)
stidf = STIDF(sp, time, mydata)
stidf


###################################################
### code chunk number 21: spacetime.Rnw:510-511
###################################################
stidf[1:2,]


###################################################
### code chunk number 22: spacetime.Rnw:520-521
###################################################
stfdf[,time[3]]


###################################################
### code chunk number 23: spacetime.Rnw:526-528
###################################################
class(stfdf[,time[3]])
class(stfdf[,time[3],drop=FALSE])


###################################################
### code chunk number 24: spacetime.Rnw:534-535
###################################################
stfdf[1, , "values"]


###################################################
### code chunk number 25: spacetime.Rnw:539-541
###################################################
class(stfdf[1,])
class(stfdf[1,drop=FALSE])


###################################################
### code chunk number 26: spacetime.Rnw:549-553
###################################################
class(stfdf)
class(as(stfdf, "STSDF"))
class(as(as(stfdf, "STSDF"), "STIDF"))
class(as(stfdf, "STIDF"))


###################################################
### code chunk number 27: spacetime.Rnw:557-563
###################################################
x = as(stfdf, "STIDF")
class(as(x, "STSDF"))
class(as(as(x, "STSDF"), "STFDF"))
class(as(x, "STFDF"))
xx = as(x, "STFDF")
identical(stfdf, xx)


###################################################
### code chunk number 28: spacetime.Rnw:571-574
###################################################
xs1 = as(stfdf, "Spatial")
class(xs1)
xs1


###################################################
### code chunk number 29: spacetime.Rnw:578-579
###################################################
attr(xs1, "time")


###################################################
### code chunk number 30: spacetime.Rnw:583-586
###################################################
xs2 = as(x, "Spatial")
class(xs2)
xs2[1:4,]


###################################################
### code chunk number 31: spacetime.Rnw:613-614 (eval = FALSE)
###################################################
## demo(CressieWikle)


###################################################
### code chunk number 32: spacetime.Rnw:623-625 (eval = FALSE)
###################################################
## scales=list(x=list(rot = 45))
## stplot(w, mode = "xt", scales = scales, xlab = NULL)


###################################################
### code chunk number 33: spacetime.Rnw:644-653 (eval = FALSE)
###################################################
## library("lattice")
## library("RColorBrewer")
## b = brewer.pal(12, "Set3")
## par.settings = list(superpose.symbol = list(col = b, fill = b), 
## 	superpose.line = list(col = b),
## 	fontsize = list(text=9)) 
## stplot(w, mode = "ts",  auto.key=list(space="right"), 
## 	xlab = "1961", ylab = expression(sqrt(speed)),
## 	par.settings = par.settings)


###################################################
### code chunk number 34: spacetime.Rnw:681-682
###################################################
.parseISO8601('2010-05')


###################################################
### code chunk number 35: spacetime.Rnw:687-688
###################################################
.parseISO8601('2010-05-01T13:30/2010-05-01T13:39')


###################################################
### code chunk number 36: spacetime.Rnw:727-741
###################################################
library("maptools")
fname = system.file("shapes/sids.shp", package="maptools")[1]
nc = readShapePoly(fname, proj4string=CRS("+proj=longlat +datum=NAD27"))
data = data.frame(
	BIR = c(nc$BIR74, nc$BIR79),
	NWBIR = c(nc$NWBIR74, nc$NWBIR79),
	SID = c(nc$SID74, nc$SID79))
time = as.POSIXct(strptime(c("1974-01-01", "1979-01-01"), "%Y-%m-%d"), 
	tz = "GMT")
nct = STFDF(
	sp = as(nc, "SpatialPolygons"),
	time = time,
	data = data)
stplot(nct[,,"SID"], c("1974-1978", "1979-1984"))


###################################################
### code chunk number 37: spacetime.Rnw:746-747
###################################################
print(stplot(nct[,,"SID"], c("1974-1978", "1979-1984"), par.strip.text = list(cex=.5)))


###################################################
### code chunk number 38: spacetime.Rnw:762-777
###################################################
library("maps")
states.m = map('state', plot=FALSE, fill=TRUE)
IDs <- sapply(strsplit(states.m$names, ":"), function(x) x[1])
    
library("maptools")
states = map2SpatialPolygons(states.m, IDs=IDs)

library("plm")
data("Produc")

yrs = 1970:1986
time = as.POSIXct(paste(yrs, "-01-01", sep=""), tz = "GMT")
# deselect District of Columbia, polygon 8, which is not present in Produc:
Produc.st = STFDF(states[-8], time, Produc[order(Produc[2], Produc[1]),])
stplot(Produc.st[,,"unemp"], yrs)


###################################################
### code chunk number 39: spacetime.Rnw:786-789
###################################################
zz <- plm(log(gsp) ~ log(pcap) + log(pc) + log(emp) + unemp, 
	data = as.data.frame(Produc.st), index = c("state","year"))
summary(zz)


###################################################
### code chunk number 40: spacetime.Rnw:822-828
###################################################
library("gstat")
data("wind")
wind.loc$y = as.numeric(char2dms(as.character(wind.loc[["Latitude"]])))
wind.loc$x = as.numeric(char2dms(as.character(wind.loc[["Longitude"]])))
coordinates(wind.loc) = ~x+y
proj4string(wind.loc) = "+proj=longlat +datum=WGS84"


###################################################
### code chunk number 41: spacetime.Rnw:833-838
###################################################
library("mapdata")
plot(wind.loc, xlim = c(-11,-5.4), ylim = c(51,55.5), axes=T, col="red",
	cex.axis =.7)
map("worldHires", add=T, col = grey(.5))
text(coordinates(wind.loc), pos=1, label=wind.loc$Station, cex=.7)


###################################################
### code chunk number 42: spacetime.Rnw:850-851
###################################################
wind[1:3,]


###################################################
### code chunk number 43: spacetime.Rnw:857-866
###################################################
wind$time = ISOdate(wind$year+1900, wind$month, wind$day)
wind$jday = as.numeric(format(wind$time, '%j'))
stations = 4:15
windsqrt = sqrt(0.5148 * as.matrix(wind[stations])) # knots -> m/s
Jday = 1:366
windsqrt = windsqrt - mean(windsqrt)
daymeans = sapply(split(windsqrt, wind$jday), mean)
meanwind = lowess(daymeans ~ Jday, f = 0.1)$y[wind$jday]
velocities = apply(windsqrt, 2, function(x) { x - meanwind })


###################################################
### code chunk number 44: spacetime.Rnw:873-908
###################################################
# order locations to order of columns in wind;
# connect station names to location coordinates
wind.loc = wind.loc[match(names(wind[4:15]), wind.loc$Code),]
pts = coordinates(wind.loc[match(names(wind[4:15]), wind.loc$Code),])
rownames(pts) = wind.loc$Station
pts = SpatialPoints(pts)
# convert to utm zone 29, to be able to do interpolation in
# proper Euclidian (projected) space:
proj4string(pts) = "+proj=longlat +datum=WGS84"
library("rgdal")
utm29 = CRS("+proj=utm +zone=29 +datum=WGS84")
pts = spTransform(pts, utm29)
# construct from space-wide table:
w = stConstruct(velocities, space = list(values = 1:ncol(velocities)), 
	time = wind$time, SpatialObj = pts)

library("maptools")
m = map2SpatialLines(
	map("worldHires", xlim = c(-11,-5.4), ylim = c(51,55.5), plot=F))
proj4string(m) = "+proj=longlat +datum=WGS84"
m = spTransform(m, utm29)

# setup grid
grd = SpatialPixels(SpatialPoints(makegrid(m, n = 300)),
	proj4string = proj4string(m))
# select april 1961:
w = w[, "1961-04"]
# 10 prediction time points, evenly spread over this month:
n = 10
tgrd = xts(1:n, seq(min(index(w)), max(index(w)), length=n))

# separable covariance model, exponential with ranges 750 km and 1.5 day:
v = list(space = vgm(0.6, "Exp", 750000), time = vgm(1, "Exp", 1.5 * 3600 * 24))
pred = krigeST(values ~ 1, w, STF(grd, tgrd), v)
wind.ST = STFDF(grd, tgrd, data.frame(sqrt_speed = pred))


###################################################
### code chunk number 45: spacetime.Rnw:915-919
###################################################
layout = list(list("sp.lines", m, col='grey'),
	list("sp.points", pts, first=F, cex=.5))
print(stplot(wind.ST, col.regions=bpy.colors(),
	par.strip.text = list(cex=.5), sp.layout = layout))


###################################################
### code chunk number 46: spacetime.Rnw:931-940
###################################################
library("lattice")
library("RColorBrewer")
b = brewer.pal(12,"Set3")
par.settings = list(superpose.symbol = list(col = b, fill = b), 
	superpose.line = list(col = b),
	fontsize = list(text=9)) 
print(stplot(w, mode = "ts",  auto.key=list(space="right"), 
	xlab = "1961", ylab = expression(sqrt(speed)),
	par.settings = par.settings))


###################################################
### code chunk number 47: spacetime.Rnw:950-952
###################################################
scales=list(x=list(rot=45))
print(stplot(w, mode = "xt", scales = scales, xlab = NULL))


###################################################
### code chunk number 48: spacetime.Rnw:962-963 (eval = FALSE)
###################################################
## eof.sp = EOF(wind.ST)


###################################################
### code chunk number 49: spacetime.Rnw:966-967 (eval = FALSE)
###################################################
## eof.xts = EOF(wind.ST, "temporal")


###################################################
### code chunk number 50: spacetime.Rnw:977-979
###################################################
print(spplot(EOF(wind.ST), col.regions=bpy.colors(),
	par.strip.text = list(cex=.5), as.table = TRUE))


###################################################
### code chunk number 51: spacetime.Rnw:1000-1035
###################################################
library("diveMove")
library("trip")

locs = readLocs(gzfile(system.file(file.path("data", "sealLocs.csv.gz"),
	package="diveMove")), idCol=1, dateCol=2,
	dtformat="%Y-%m-%d %H:%M:%S", classCol=3,
	lonCol=4, latCol=5, sep=";")

ringy = subset(locs, id == "ringy" & !is.na(lon) & !is.na(lat))
coordinates(ringy) = ringy[c("lon", "lat")]
tr = trip(ringy, c("time", "id"))
# convert to SPSDFtraj, and plot:
setAs("trip", "STIDFtraj",
	function(from) {
		from$burst = from[[from@TOR.columns[2]]]
		time = from[[from@TOR.columns[1]]]
		new("STIDFtraj", STIDF(as(from, "SpatialPoints"), time, from@data))
	}
)
x = as(tr, "STIDFtraj")
m = map2SpatialLines(map("world", 
	xlim = c(-100,-50), ylim = c(40,77), plot=F))
proj4string(m) = "+proj=longlat +datum=WGS84"
plot(m, axes=TRUE, cex.axis =.7)
plot(x, add=TRUE, col = "red")

# convert back, compare:
setAs("STIDFtraj", "trip", function(from) {
		from$time = index(from@time)
		trip(SpatialPointsDataFrame(from@sp, from@data), c("time", "burst"))
	}
)
y = as(x, "trip")
y$burst = NULL
all.equal(y, tr, check.attributes = FALSE)


###################################################
### code chunk number 52: spacetime.Rnw:1048-1069
###################################################
library("adehabitatLT")
# from: adehabitat/demo/managltraj.r
# demo(managltraj)
data("puechabonsp")
# locations:
locs = puechabonsp$relocs
xy = coordinates(locs)
### Conversion of the date to the format POSIX
da = as.character(locs$Date)
da = as.POSIXct(strptime(as.character(locs$Date),"%y%m%d"), tz = "GMT") 
## object of class "ltraj"
ltr = as.ltraj(xy, da, id = locs$Name)
foo = function(dt) dt > 100*3600*24
## The function foo returns TRUE if dt is longer than 100 days
## We use it to cut ltr:
l2 = cutltraj(ltr, "foo(dt)", nextr = TRUE)
stidfTrj = as(l2, "STIDFtraj")
ltr0 = as(stidfTrj, "ltraj")
all.equal(l2, ltr0, check.attributes = FALSE)
plot(stidfTrj, col = c("red", "green", "blue", "darkgreen", "black"),
	axes=TRUE)


###################################################
### code chunk number 53: spacetime.Rnw:1074-1075 (eval = FALSE)
###################################################
## stplot(stidfTrj,by="time*id")


###################################################
### code chunk number 54: spacetime.Rnw:1081-1082
###################################################
print(stplot(stidfTrj, by="time*id"))


###################################################
### code chunk number 55: spacetime.Rnw:1095-1098
###################################################
library("cshapes")
cs = cshp()
names(cs)


###################################################
### code chunk number 56: spacetime.Rnw:1109-1110
###################################################
cshp.2002 <- cshp(date=as.Date("2002-6-30"), useGW=TRUE)


###################################################
### code chunk number 57: spacetime.Rnw:1116-1121
###################################################
t = as.POSIXct(strptime(paste(cs$COWSYEAR, 
	cs$COWSMONTH,cs$COWSDAY, sep="-"), "%Y-%m-%d"), tz = "GMT")
st = STIDF(geometry(cs), t, as.data.frame(cs))
pt = SpatialPoints(cbind(7, 52), CRS(proj4string(cs)))
as.data.frame(st[pt,,1:5])


