### R code from vignette source 'survBayes.Rnw'

###################################################
### code chunk number 1: aneurism load
###################################################
library(survBayes)
data(AA.data)
AA.data[1:11,]


###################################################
### code chunk number 2: aneurism fit
###################################################
control<-survBayes.control(delta.taylor = 0.3, sigma.lbh.1=0.01,rate.sigma.lbh.1 = 1e-3, shape.sigma.lbh.1 = 1e-3)
AA.res<-survBayes(Surv(t.left,t.right,z*3,type="interval")~mo+lok+frailty(gr,dist="gamma"),data=AA.data,burn.in=0,number.sample=10,control=control)
str(AA.res)


###################################################
### code chunk number 3: aneurismcoda
###################################################
raftery.diag(AA.res$beta)
raftery.diag(AA.res$sigma.lbh)
raftery.diag(AA.res$z.cluster)
raftery.diag(AA.res$mu.cluster)


###################################################
### code chunk number 4: aneurismplot
###################################################
beta.est<-apply(AA.res$beta,2,mean)
baseline.hazard<-survBayes.baseline.hazard(AA.res,start=1,type="cum")
time<-baseline.hazard$time
Lambda0<-baseline.hazard$cum.base.haz
surv.base<-exp(-Lambda0)
plot(time,surv.base,type="l",xlab="time [years]",ylab="Survival function",lty=1,ylim=c(0,1))
lines(time,surv.base^exp(beta.est["mo"]),type="l",lty=2)
lines(time,surv.base^exp(beta.est["lok"]),type="l",lty=3)
lines(time,surv.base^exp(sum(beta.est[c("mo","lok")])),type="l",lty=5)
leg.names<-c("mo=0, lok=0", "mo=1, lok=0","mo=0, lok=1","mo=1, lok=1")
legend(4,1,leg.names,lty=c(1,2,3,5),bty="n")


