### R code from vignette source 'tiger.Snw'
### Encoding: ISO8859-1

###################################################
### code chunk number 1: tiger.Snw:40-47
###################################################
library(tiger)
data(tiger.example)
measured.single <- tiger.single$measured
modelled.single <- tiger.single$modelled

measured.multi <- tiger.multi$measured
modelled.multi <- tiger.multi$modelled


###################################################
### code chunk number 2: fig1plot
###################################################

par(mfrow=c(2,1))
plot(d.dates, measured.single, type="l", col="blue")
lines(d.dates, modelled.single)

legend("topright", legend=c("measured","modelled"), lty=1, col=c("blue", "black"))

plot(d.dates, measured.multi, type="l", col="blue")
for(i in 1:NROW(modelled.multi)){
	lines(d.dates, modelled.multi[i,])
}

lines(d.dates, measured.multi, col="blue")


###################################################
### code chunk number 3: fig1
###################################################

par(mfrow=c(2,1))
plot(d.dates, measured.single, type="l", col="blue")
lines(d.dates, modelled.single)

legend("topright", legend=c("measured","modelled"), lty=1, col=c("blue", "black"))

plot(d.dates, measured.multi, type="l", col="blue")
for(i in 1:NROW(modelled.multi)){
	lines(d.dates, modelled.multi[i,])
}

lines(d.dates, measured.multi, col="blue")


###################################################
### code chunk number 4: tiger.Snw:82-90
###################################################
peaks2 <- synth.peak.error(rise.factor=2, recession.const=0.02,
     rise.factor2=1.5, err1.factor=c(1.3,1.5,2.0),
     err2.factor = c(0.02,0.03,0.06), 
     err4.factor = c(9,22,40), 
     err5.factor = c(0.2,0.3,0.5),
     err6.factor =c(2,3,5),
     err9.factor=c(1.5,3,6)
   )


###################################################
### code chunk number 5: fig2plot
###################################################
    p.synth.peak.error(peaks2)


###################################################
### code chunk number 6: fig2
###################################################
    p.synth.peak.error(peaks2)


###################################################
### code chunk number 7: tiger.Snw:125-127 (eval = FALSE)
###################################################
## result.single <- tiger(modelled=modelled.single, measured=measured.single, window.size=240, synthetic.errors=peaks2)
## result.multi <- tiger(modelled=modelled.multi, measured=measured.multi, window.size=240, synthetic.errors=peaks2)


###################################################
### code chunk number 8: tiger.Snw:129-131
###################################################
result.single <- tiger.single
result.multi <- tiger.multi


###################################################
### code chunk number 9: fig3plot
###################################################
 correlated <- correlated(result.multi, keep=c("CE","RMSE" ))
 print(scatterplot(result.multi$measures.uniform, 
            show.measures=correlated$measures.uniform$to.keep[c(1,2,3,5,6)]))


###################################################
### code chunk number 10: fig3
###################################################
 correlated <- correlated(result.multi, keep=c("CE","RMSE" ))
 print(scatterplot(result.multi$measures.uniform, 
            show.measures=correlated$measures.uniform$to.keep[c(1,2,3,5,6)]))


###################################################
### code chunk number 11: fig4plot
###################################################
show.measures <- which(names(result.multi$measures) %in% 
                       c("CE", "PDIFF", "ME", "MSDE", 
                         "SMSE",  "Rsqr","SMALE",
                         "lagtime", "NSC"))
peaks.measures(result.multi, show.measures=show.measures,
               mfrow=c(2,5), do.out=c(rep(FALSE, 4), TRUE,
                                      TRUE,rep(FALSE, 3)) )


###################################################
### code chunk number 12: fig4
###################################################
show.measures <- which(names(result.multi$measures) %in% 
                       c("CE", "PDIFF", "ME", "MSDE", 
                         "SMSE",  "Rsqr","SMALE",
                         "lagtime", "NSC"))
peaks.measures(result.multi, show.measures=show.measures,
               mfrow=c(2,5), do.out=c(rep(FALSE, 4), TRUE,
                                      TRUE,rep(FALSE, 3)) )


###################################################
### code chunk number 13: fig5plot
###################################################
par(mar=c(4,4,1,1)+0.1)
p.validityIndex(result.multi, validity.max=10)



###################################################
### code chunk number 14: fig5
###################################################
par(mar=c(4,4,1,1)+0.1)
p.validityIndex(result.multi, validity.max=10)



###################################################
### code chunk number 15: fig5aplot
###################################################
par(mfrow=c(2,1),mar=c(2,4,1,2)+0.1)
errors.in.time(d.dates, result.multi, solution=3)
               #show.months=TRUE)
errors.in.time(d.dates, result.multi, solution=5,
                new.order=c(4,3,5,2,1))
               #show.months=TRUE, new.order=c(3,4,5,2,1))
solutions <- 5


###################################################
### code chunk number 16: fig5a
###################################################
par(mfrow=c(2,1),mar=c(2,4,1,2)+0.1)
errors.in.time(d.dates, result.multi, solution=3)
               #show.months=TRUE)
errors.in.time(d.dates, result.multi, solution=5,
                new.order=c(4,3,5,2,1))
               #show.months=TRUE, new.order=c(3,4,5,2,1))
solutions <- 5


###################################################
### code chunk number 17: fig6plot
###################################################
#new.order <- c(4,5,2,1,3)
new.order=c(4,3,5,2,1)
par(mar=c(2,4,1,2)+0.1)
errors.in.time(d.dates, result.multi, solution=solutions,
               #show.months=TRUE, new.order=new.order)
               new.order=new.order)


###################################################
### code chunk number 18: fig6
###################################################
#new.order <- c(4,5,2,1,3)
new.order=c(4,3,5,2,1)
par(mar=c(2,4,1,2)+0.1)
errors.in.time(d.dates, result.multi, solution=solutions,
               #show.months=TRUE, new.order=new.order)
               new.order=new.order)


###################################################
### code chunk number 19: tiger.Snw:272-273
###################################################
peak.cluster <- peaks.in.clusters(result.multi, solution=solutions, new.order=new.order)


###################################################
### code chunk number 20: fig7plot
###################################################
p.synth.peak.error(peaks2, peak.cluster=peak.cluster,
peak.palette=rainbow(5) )


###################################################
### code chunk number 21: fig7
###################################################
p.synth.peak.error(peaks2, peak.cluster=peak.cluster,
peak.palette=rainbow(5) )


###################################################
### code chunk number 22: fig8plot
###################################################
par(mfrow=c(4,6), mar=c(2,2,3,1)+0.1)
summary.table <- box.plots(result.multi, 
                           solution=solutions,
                           show.measures=correlated$measures.uniform$to.keep,
                           new.order=new.order)


###################################################
### code chunk number 23: tiger.Snw:304-305
###################################################
print(summary.table)


###################################################
### code chunk number 24: fig8
###################################################
par(mfrow=c(4,6), mar=c(2,2,3,1)+0.1)
summary.table <- box.plots(result.multi, 
                           solution=solutions,
                           show.measures=correlated$measures.uniform$to.keep,
                           new.order=new.order)


