### R code from vignette source 'tm.Rnw'

###################################################
### code chunk number 1: Init
###################################################
library("tm")
data("crude")


###################################################
### code chunk number 2: Ovid
###################################################
txt <- system.file("texts", "txt", package = "tm")
(ovid <- Corpus(DirSource(txt),
                readerControl = list(language = "lat")))


###################################################
### code chunk number 3: VectorSource
###################################################
docs <- c("This is a text.", "This another one.")
Corpus(VectorSource(docs))


###################################################
### code chunk number 4: Reuters
###################################################
reut21578 <- system.file("texts", "crude", package = "tm")
reuters <- Corpus(DirSource(reut21578),
                  readerControl = list(reader = readReut21578XML))


###################################################
### code chunk number 5: tm.Rnw:119-120 (eval = FALSE)
###################################################
## writeCorpus(ovid)


###################################################
### code chunk number 6: tm.Rnw:131-132
###################################################
inspect(ovid[1:2])


###################################################
### code chunk number 7: tm.Rnw:136-137
###################################################
identical(ovid[[2]], ovid[["ovid_2.txt"]])


###################################################
### code chunk number 8: tm.Rnw:155-156
###################################################
reuters <- tm_map(reuters, as.PlainTextDocument)


###################################################
### code chunk number 9: tm.Rnw:164-165
###################################################
reuters <- tm_map(reuters, stripWhitespace)


###################################################
### code chunk number 10: tm.Rnw:170-171
###################################################
reuters <- tm_map(reuters, tolower)


###################################################
### code chunk number 11: Stopwords
###################################################
reuters <- tm_map(reuters, removeWords, stopwords("english"))


###################################################
### code chunk number 12: Stemming
###################################################
tm_map(reuters, stemDocument)


###################################################
### code chunk number 13: tm.Rnw:203-205
###################################################
query <- "id == '237' & heading == 'INDONESIA SEEN AT CROSSROADS OVER ECONOMIC CHANGE'"
tm_filter(reuters, FUN = sFilter, query)


###################################################
### code chunk number 14: tm.Rnw:210-211
###################################################
tm_filter(reuters, pattern = "company")


###################################################
### code chunk number 15: DublinCore
###################################################
DublinCore(crude[[1]], "Creator") <- "Ano Nymous"
meta(crude[[1]])


###################################################
### code chunk number 16: tm.Rnw:242-246
###################################################
meta(crude, tag = "test", type = "corpus") <- "test meta"
meta(crude, type = "corpus")
meta(crude, "foo") <- letters[1:20]
meta(crude)


###################################################
### code chunk number 17: tm.Rnw:263-265
###################################################
dtm <- DocumentTermMatrix(reuters)
inspect(dtm[1:5,100:105])


###################################################
### code chunk number 18: tm.Rnw:274-275
###################################################
findFreqTerms(dtm, 5)


###################################################
### code chunk number 19: tm.Rnw:280-281
###################################################
findAssocs(dtm, "opec", 0.8)


###################################################
### code chunk number 20: tm.Rnw:293-294
###################################################
inspect(removeSparseTerms(dtm, 0.4))


###################################################
### code chunk number 21: tm.Rnw:305-306
###################################################
(d <- Dictionary(c("prices", "crude", "oil")))


###################################################
### code chunk number 22: tm.Rnw:314-315
###################################################
inspect(DocumentTermMatrix(reuters, list(dictionary = d)))


