### R code from vignette source 'treecm.Rnw'

###################################################
### code chunk number 1: ex1
###################################################
library(treecm)
data(treeData)
print(treeData)


###################################################
### code chunk number 2: ex11
###################################################
vectors  <- treeVectors(treeData)
CM       <- centreOfMass(vectors)
summary(CM)


###################################################
### code chunk number 3: ex2
###################################################
plot.vectors(vectors, 
  CM = CM,
  main = "A stone pine centre of mass"
)


###################################################
### code chunk number 4: ex3
###################################################
plot.vectors(vectors, 
  CM = CM,
  main = "A stone pine centre of mass",
  xlim = c(-8, 10),
  ylim = c(-12, 4)
)
plotPolarSegment(210, 10.6, 140, 14.4)


###################################################
### code chunk number 5: exSnow
###################################################
rows <- substr(row.names(treeData$fieldData), 1, 1)
q1 <- subset(treeData$fieldData, subset=(height < 12 | rows == "L"))
q2 <- subset(treeData$fieldData, subset=(height > 12 & rows != "L"))
q2$biomass <- q2$biomass * 2
treeData$fieldData <- rbind(q1, q2)
rm(list = c("q1", "q2", "rows"))


###################################################
### code chunk number 6: exSnow2
###################################################
vectors  <- treeVectors(treeData)
CM       <- centreOfMass(vectors)
summary(CM)
plot.vectors(vectors, 
  CM = CM,
  main = "A stone pine centre of mass under 2x snow load",
  xlim = c(-8,10),
  ylim = c(-12,4)
)
plotPolarSegment(210, 10.6, 140, 14.4)


###################################################
### code chunk number 7: exWind
###################################################
data(treeData)

rows <- substr(row.names(treeData$fieldData), 1, 1)
treeData$fieldData <- within(
  treeData$fieldData, {
  biomass[((azimuth >= 270 | azimuth < 90) & rows != "L")] <- biomass[((azimuth >= 270 | azimuth < 90) & rows != "L")] / 2
  biomass[((azimuth >= 90 | azimuth < 270) & rows != "L")] <- biomass[((azimuth >= 90 | azimuth < 270) & rows != "L")] * 2  
})
rm(rows)

vectors  <- treeVectors(treeData)
CM       <- centreOfMass(vectors)
summary(CM)


###################################################
### code chunk number 8: exPruning
###################################################
library(treecm)
data(treeData)
vectors  <- treeVectors(treeData)
CM       <- centreOfMass(vectors)

op <- par(mfrow = c(2, 1), mai = c(0.5,0.5,0.5,0.2))

plot.vectors(vectors, 
  CM = CM,
  main = "Centre of mass of a stone pine"
)

treeData <- switchBranchPruningStatus(treeData, c(4, 6))
vectors  <- treeVectors(treeData)
CM       <- centreOfMass(vectors)
plot.vectors(vectors, 
  CM = CM,
  main = "Centre of mass of a stone pine, B2 and B4 removed"
)

par(op)
rm(op)


###################################################
### code chunk number 9: exSR
###################################################
data(treeData)
# assign length to branches
treeData$fieldData$length <- c(10.2, 3.9, 7, 7, 7, 7, 7, 7, 3.95, 7, 7, 3.95, 7, 7, 3.95, 7, 7, 7, 3.95, 7, 7, 3.95, 3.95, 7, 7, 3.00)
vectors <-treeVectors(treeData)
SR      <- treeSR(treeData,vectors)
plot.SR(SR, main = "Branches slenderness ratio", xaxt='n', yaxt = 'n', xlab = "", ylab = "")


###################################################
### code chunk number 10: bst
###################################################
library(treecm)
data(Dst)
print(Dst)


