### R code from vignette source 'Animal.Rnw'
### Encoding: ISO8859-1

###################################################
### code chunk number 1: Animal.Rnw:74-75
###################################################
options(width=70)


###################################################
### code chunk number 2: Animal.Rnw:103-105
###################################################
library(Animal)
analyzed <- cowAnalyze(file='calf1.bh1',states=c(1,2,3),state.names=c('walking','standing','lying'))


###################################################
### code chunk number 3: Animal.Rnw:117-118
###################################################
data(RIC)


###################################################
### code chunk number 4: Animal.Rnw:124-127
###################################################
RIC2 <- clean.RIC(RIC)
bouts <- bouts.RIC(RIC2)
head(bouts,5)


###################################################
### code chunk number 5: Animal.Rnw:132-134
###################################################
boxplot(intake~partOfDay(begin),data=bouts,ylab='Feed intake (kg)',
     xlab='Time of day',main='Default settings: start =1, nsplit=4')


###################################################
### code chunk number 6: Animal.Rnw:154-158
###################################################
attach(bouts)
hourly.visits <- hourly(intake,begin,fun=length)
head(hourly.visits)
plot(Result~Hour,data=hourly.visits,type='b')


###################################################
### code chunk number 7: Animal.Rnw:163-167
###################################################
cow.intake <- hourly(intake,begin,fun=sum,subject=cowID)
head(cow.intake)
boxplot(Result~Hour,data=cow.intake)
detach(bouts)


