/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.packageManagement;

import java.io.File;
import java.io.PrintStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.pentaho.packageManagement.Dependency;
import org.pentaho.packageManagement.Package;
import org.pentaho.packageManagement.PackageConstraint;
import org.pentaho.packageManagement.PackageManager;
import org.pentaho.packageManagement.VersionPackageConstraint;
import org.pentaho.packageManagement.VersionRangePackageConstraint;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultPackage
extends Package {
    protected File m_packageHome;
    protected PackageManager m_packageManager;

    @Override
    public Object clone() {
        DefaultPackage defaultPackage = null;
        defaultPackage = this.m_packageHome != null ? new DefaultPackage(new File(this.m_packageHome.toString()), this.m_packageManager) : new DefaultPackage(null, this.m_packageManager);
        HashMap hashMap = new HashMap();
        Set set = this.m_packageMetaData.keySet();
        for (Object k : set) {
            Object v = this.m_packageMetaData.get(k);
            hashMap.put(k, v);
        }
        defaultPackage.setPackageMetaData(hashMap);
        return defaultPackage;
    }

    public DefaultPackage(File file, PackageManager packageManager, Map<?, ?> map) {
        this(file, packageManager);
        this.setPackageMetaData(map);
    }

    public DefaultPackage(File file, PackageManager packageManager) {
        this.m_packageHome = file;
        this.m_packageManager = packageManager;
    }

    @Override
    public URL getPackageURL() throws Exception {
        String string = this.getPackageMetaDataElement("PackageURL").toString().trim();
        URL uRL = new URL(string);
        return uRL;
    }

    @Override
    public String getName() {
        return this.getPackageMetaDataElement("PackageName").toString();
    }

    protected static String[] splitNameVersion(String string) {
        String[] stringArray = new String[3];
        if ((string = string.trim()).indexOf(40) < 0) {
            stringArray[0] = string;
        } else if (string.indexOf(41) >= 0) {
            boolean bl = true;
            stringArray[0] = string.substring(0, string.indexOf(40));
            stringArray[0] = stringArray[0].trim();
            String string2 = null;
            int n = string.indexOf(124);
            if (n >= 0) {
                string2 = string.substring(n + 1, string.length());
                string2 = string2.trim();
                String[] stringArray2 = new String[5];
                stringArray2[0] = stringArray[0];
                stringArray = stringArray2;
            } else {
                n = string.length();
            }
            string = string.substring(string.indexOf(40) + 1, n);
            string = string.trim();
            int n2 = 1;
            if (string.charAt(0) == '=') {
                stringArray[1] = "=";
            } else if (string.charAt(1) == '=') {
                ++n2;
                stringArray[1] = string.charAt(0) == '<' ? "<=" : ">=";
            } else if (string.charAt(0) == '<') {
                stringArray[1] = "<";
            } else if (string.charAt(0) == '>') {
                stringArray[1] = ">";
            } else {
                bl = false;
            }
            if (bl) {
                n = string2 != null ? string.length() : string.indexOf(41);
                string = string.substring(n2, n);
                stringArray[2] = string.trim();
            }
            if (string2 != null) {
                bl = true;
                n2 = 1;
                if (string2.charAt(0) == '=') {
                    stringArray[3] = "=";
                } else if (string2.charAt(1) == '=') {
                    ++n2;
                    stringArray[3] = string2.charAt(0) == '<' ? "<=" : ">=";
                } else if (string2.charAt(0) == '<') {
                    stringArray[3] = "<";
                } else if (string2.charAt(0) == '>') {
                    stringArray[3] = ">";
                } else {
                    bl = false;
                }
                if (bl) {
                    string2 = string2.substring(n2, string2.indexOf(41));
                    stringArray[4] = string2.trim();
                }
            }
        }
        return stringArray;
    }

    @Override
    public List<Dependency> getDependencies() throws Exception {
        ArrayList<Dependency> arrayList = new ArrayList<Dependency>();
        String string = this.getPackageMetaDataElement("Depends").toString();
        if (string != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
            while (stringTokenizer.hasMoreTokens()) {
                Object object;
                PackageConstraint packageConstraint;
                String string2 = stringTokenizer.nextToken().trim();
                String[] stringArray = DefaultPackage.splitNameVersion(string2);
                Package package_ = null;
                if (stringArray[0].equalsIgnoreCase(this.m_packageManager.getBaseSystemName())) continue;
                package_ = this.m_packageManager.getRepositoryPackageInfo(stringArray[0], stringArray[2]);
                if (stringArray.length == 3) {
                    packageConstraint = new VersionPackageConstraint(package_);
                    if (stringArray[2] == null) {
                        ((VersionPackageConstraint)packageConstraint).setVersionConstraint(VersionPackageConstraint.VersionComparison.LESSTHANOREQUAL);
                    } else {
                        ((VersionPackageConstraint)packageConstraint).setVersionConstraint(stringArray[1]);
                    }
                    object = new Dependency(this, packageConstraint);
                    arrayList.add((Dependency)object);
                    continue;
                }
                packageConstraint = new VersionRangePackageConstraint(package_);
                object = VersionPackageConstraint.getVersionComparison(stringArray[1]);
                VersionPackageConstraint.VersionComparison versionComparison = VersionPackageConstraint.getVersionComparison(stringArray[3]);
                ((VersionRangePackageConstraint)packageConstraint).setRangeConstraint(stringArray[2], (VersionPackageConstraint.VersionComparison)((Object)object), stringArray[4], versionComparison);
                Dependency dependency = new Dependency(this, packageConstraint);
                arrayList.add(dependency);
            }
        }
        return arrayList;
    }

    @Override
    public List<Dependency> getBaseSystemDependency() throws Exception {
        String string = this.getPackageMetaDataElement("Depends").toString();
        Dependency dependency = null;
        ArrayList<Dependency> arrayList = new ArrayList<Dependency>();
        if (string != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
            while (stringTokenizer.hasMoreTokens()) {
                VersionPackageConstraint.VersionComparison versionComparison;
                PackageConstraint packageConstraint;
                String string2 = stringTokenizer.nextToken().trim();
                String[] stringArray = DefaultPackage.splitNameVersion(string2);
                if (!stringArray[0].equalsIgnoreCase(this.m_packageManager.getBaseSystemName())) continue;
                HashMap<String, String> hashMap = new HashMap<String, String>();
                hashMap.put("PackageName", "weka");
                stringArray[2] = stringArray[2] == null ? "1000.1000.1000" : stringArray[2];
                hashMap.put("Version", stringArray[2]);
                DefaultPackage defaultPackage = new DefaultPackage(null, this.m_packageManager, hashMap);
                if (stringArray.length == 3) {
                    packageConstraint = new VersionPackageConstraint(defaultPackage);
                    versionComparison = VersionPackageConstraint.VersionComparison.LESSTHANOREQUAL;
                    if (stringArray[1] != null) {
                        versionComparison = VersionPackageConstraint.getVersionComparison(stringArray[1]);
                    }
                    ((VersionPackageConstraint)packageConstraint).setVersionConstraint(versionComparison);
                    dependency = new Dependency(this, packageConstraint);
                    arrayList.add(dependency);
                    continue;
                }
                packageConstraint = new VersionRangePackageConstraint(defaultPackage);
                versionComparison = VersionPackageConstraint.getVersionComparison(stringArray[1]);
                VersionPackageConstraint.VersionComparison versionComparison2 = VersionPackageConstraint.getVersionComparison(stringArray[3]);
                ((VersionRangePackageConstraint)packageConstraint).setRangeConstraint(stringArray[2], versionComparison, stringArray[4], versionComparison2);
                dependency = new Dependency(this, packageConstraint);
            }
        }
        if (arrayList.size() == 0) {
            throw new Exception("[Package] " + this.getPackageMetaDataElement("PackageName").toString() + " can't determine what version of the base system is required!!");
        }
        return arrayList;
    }

    private boolean findPackage(String string, List<Package> list) {
        boolean bl = false;
        for (Package package_ : list) {
            String string2 = package_.getPackageMetaDataElement("PackageName").toString();
            if (!string.equals(string2)) continue;
            bl = true;
            break;
        }
        return bl;
    }

    @Override
    public List<Dependency> getMissingDependencies(List<Package> list) throws Exception {
        ArrayList<Dependency> arrayList = new ArrayList<Dependency>();
        String string = this.getPackageMetaDataElement("Depends").toString();
        if (string != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken().trim();
                String[] stringArray = DefaultPackage.splitNameVersion(string2);
                if (stringArray[0].equalsIgnoreCase(this.m_packageManager.getBaseSystemName())) continue;
                Package package_ = this.m_packageManager.getRepositoryPackageInfo(stringArray[0], stringArray[2]);
                if (this.findPackage(stringArray[0], list)) continue;
                VersionPackageConstraint versionPackageConstraint = new VersionPackageConstraint(package_);
                if (stringArray[2] == null) {
                    versionPackageConstraint.setVersionConstraint(VersionPackageConstraint.VersionComparison.LESSTHANOREQUAL);
                    arrayList.add(new Dependency(this, versionPackageConstraint));
                    continue;
                }
                if (stringArray.length == 3) {
                    versionPackageConstraint.setVersionConstraint(stringArray[1]);
                    arrayList.add(new Dependency(this, versionPackageConstraint));
                    continue;
                }
                VersionRangePackageConstraint versionRangePackageConstraint = new VersionRangePackageConstraint(package_);
                VersionPackageConstraint.VersionComparison versionComparison = VersionPackageConstraint.getVersionComparison(stringArray[1]);
                VersionPackageConstraint.VersionComparison versionComparison2 = VersionPackageConstraint.getVersionComparison(stringArray[3]);
                versionRangePackageConstraint.setRangeConstraint(stringArray[2], versionComparison, stringArray[4], versionComparison2);
                arrayList.add(new Dependency(this, versionRangePackageConstraint));
            }
        }
        return arrayList;
    }

    @Override
    public List<Dependency> getMissingDependencies() throws Exception {
        List<Package> list = this.m_packageManager.getInstalledPackages();
        String string = this.getPackageMetaDataElement("Depends").toString();
        return this.getMissingDependencies(list);
    }

    @Override
    public List<Dependency> getIncompatibleDependencies(List<Package> list) throws Exception {
        ArrayList<Dependency> arrayList = new ArrayList<Dependency>();
        String string = this.getPackageMetaDataElement("Depends").toString();
        if (string != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken().trim();
                String[] stringArray = DefaultPackage.splitNameVersion(string2);
                if (stringArray[1] == null || stringArray[2] == null) continue;
                for (Package package_ : list) {
                    Object object;
                    Object object2;
                    String string3 = package_.getPackageMetaDataElement("PackageName").toString();
                    if (!string3.trim().equalsIgnoreCase(stringArray[0].trim())) continue;
                    String string4 = package_.getPackageMetaDataElement("Version").toString().trim();
                    if (stringArray.length == 3) {
                        object2 = VersionPackageConstraint.getVersionComparison(stringArray[1]);
                        if (VersionPackageConstraint.checkConstraint(string4, object2, stringArray[2])) continue;
                        object = new VersionPackageConstraint(package_);
                        ((VersionPackageConstraint)object).setVersionConstraint((VersionPackageConstraint.VersionComparison)((Object)object2));
                        arrayList.add(new Dependency(this, (PackageConstraint)object));
                        continue;
                    }
                    object2 = new VersionRangePackageConstraint(package_);
                    object = VersionPackageConstraint.getVersionComparison(stringArray[1]);
                    VersionPackageConstraint.VersionComparison versionComparison = VersionPackageConstraint.getVersionComparison(stringArray[3]);
                    ((VersionRangePackageConstraint)object2).setRangeConstraint(stringArray[2], (VersionPackageConstraint.VersionComparison)((Object)object), stringArray[4], versionComparison);
                    arrayList.add(new Dependency(this, (PackageConstraint)object2));
                }
            }
        }
        return arrayList;
    }

    @Override
    public List<Dependency> getIncompatibleDependencies() throws Exception {
        List<Package> list = this.m_packageManager.getInstalledPackages();
        String string = this.getPackageMetaDataElement("Depends").toString();
        return this.getIncompatibleDependencies(list);
    }

    @Override
    public boolean isCompatibleBaseSystem() throws Exception {
        String string = this.m_packageManager.getBaseSystemName();
        String string2 = this.m_packageManager.getBaseSystemVersion().toString();
        String string3 = this.getPackageMetaDataElement("Depends").toString();
        if (string3 == null) {
            return true;
        }
        boolean bl = true;
        StringTokenizer stringTokenizer = new StringTokenizer(string3, ",");
        while (stringTokenizer.hasMoreTokens()) {
            Object object;
            String string4 = stringTokenizer.nextToken().trim();
            String[] stringArray = DefaultPackage.splitNameVersion(string4);
            if (!stringArray[0].startsWith(string.toLowerCase()) || stringArray[1] == null) continue;
            if (stringArray.length == 3) {
                object = VersionPackageConstraint.getVersionComparison(stringArray[1]);
                if (VersionPackageConstraint.checkConstraint(string2, (VersionPackageConstraint.VersionComparison)((Object)object), stringArray[2])) continue;
                bl = false;
                break;
            }
            object = new HashMap();
            object.put("PackageName", "weka");
            object.put("Version", string2);
            DefaultPackage defaultPackage = new DefaultPackage(null, this.m_packageManager, (Map<?, ?>)object);
            VersionRangePackageConstraint versionRangePackageConstraint = new VersionRangePackageConstraint(defaultPackage);
            VersionPackageConstraint.VersionComparison versionComparison = VersionPackageConstraint.getVersionComparison(stringArray[1]);
            VersionPackageConstraint.VersionComparison versionComparison2 = VersionPackageConstraint.getVersionComparison(stringArray[3]);
            versionRangePackageConstraint.setRangeConstraint(stringArray[2], versionComparison, stringArray[4], versionComparison2);
            if (versionRangePackageConstraint.checkConstraint(defaultPackage)) continue;
            bl = false;
            break;
        }
        return bl;
    }

    @Override
    public void install() throws Exception {
        URL uRL = this.getPackageURL();
        this.m_packageManager.installPackageFromURL(uRL, new PrintStream[0]);
    }

    @Override
    public boolean isInstalled() {
        File file = new File(this.m_packageHome.getAbsoluteFile() + File.separator + this.m_packageMetaData.get("PackageName") + File.separator + "Description.props");
        return file.exists();
    }

    public static void main(String[] stringArray) {
        String string = stringArray[0];
        String string2 = stringArray[1];
        String[] stringArray2 = DefaultPackage.splitNameVersion(string);
        String[] stringArray3 = DefaultPackage.splitNameVersion(string2);
        try {
            if (stringArray3.length == 3) {
                System.out.println("Checking first version number against second constraint");
                VersionPackageConstraint.VersionComparison versionComparison = VersionPackageConstraint.getVersionComparison(stringArray3[1]);
                if (VersionPackageConstraint.checkConstraint(stringArray2[2], versionComparison, stringArray3[2])) {
                    System.out.println(stringArray2[2] + " is compatible with " + stringArray[1]);
                } else {
                    System.out.println(stringArray2[2] + " is not compatible with " + stringArray[1]);
                }
                HashMap<String, String> hashMap = new HashMap<String, String>();
                hashMap.put("PackageName", stringArray3[0]);
                hashMap.put("Version", stringArray3[2]);
                DefaultPackage defaultPackage = new DefaultPackage(null, null, hashMap);
                defaultPackage.setPackageMetaData(hashMap);
                VersionPackageConstraint versionPackageConstraint = new VersionPackageConstraint(defaultPackage);
                versionPackageConstraint.setVersionConstraint(versionComparison);
                if (stringArray2.length == 3) {
                    VersionPackageConstraint.VersionComparison versionComparison2 = VersionPackageConstraint.getVersionComparison(stringArray2[1]);
                    Package package_ = (Package)((Package)defaultPackage).clone();
                    package_.setPackageMetaDataElement(VersionPackageConstraint.VERSION_KEY, stringArray2[2]);
                    VersionPackageConstraint versionPackageConstraint2 = new VersionPackageConstraint(package_);
                    versionPackageConstraint2.setVersionConstraint(versionComparison2);
                    PackageConstraint packageConstraint = null;
                    packageConstraint = versionPackageConstraint2.checkConstraint(versionPackageConstraint);
                    if (packageConstraint != null) {
                        System.out.println(versionPackageConstraint2 + " and " + versionPackageConstraint + " are compatible\n\n" + "compatible constraint " + packageConstraint);
                    } else {
                        System.out.println(versionPackageConstraint2 + " and " + versionPackageConstraint + " are not compatible");
                    }
                }
            } else {
                System.out.println("Checking first version number against second constraint");
                HashMap<String, String> hashMap = new HashMap<String, String>();
                hashMap.put("PackageName", stringArray2[0]);
                hashMap.put("Version", stringArray2[2]);
                DefaultPackage defaultPackage = new DefaultPackage(null, null, hashMap);
                VersionRangePackageConstraint versionRangePackageConstraint = new VersionRangePackageConstraint(defaultPackage);
                VersionPackageConstraint.VersionComparison versionComparison = VersionPackageConstraint.getVersionComparison(stringArray3[1]);
                VersionPackageConstraint.VersionComparison versionComparison3 = VersionPackageConstraint.getVersionComparison(stringArray3[3]);
                versionRangePackageConstraint.setRangeConstraint(stringArray3[2], versionComparison, stringArray3[4], versionComparison3);
                if (versionRangePackageConstraint.checkConstraint(defaultPackage)) {
                    System.out.println(stringArray2[2] + " is compatible with " + stringArray[1]);
                } else {
                    System.out.println(stringArray2[2] + " is not compatible with " + stringArray[1]);
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    @Override
    public void setPackageMetaDataElement(Object object, Object object2) throws Exception {
        if (this.m_packageMetaData == null) {
            throw new Exception("[DefaultPackage] no meta data map has been set!");
        }
        Map map = this.m_packageMetaData;
        map.put(object, object2);
    }

    public String toString() {
        String string = this.getPackageMetaDataElement("PackageName").toString();
        String string2 = this.getPackageMetaDataElement("Version").toString();
        return string + " (" + string2 + ")";
    }
}

