/*
 * Decompiled with CFR 0.152.
 */
package weka.gui.beans;

import java.awt.BorderLayout;
import java.awt.Component;
import java.beans.EventSetDescriptor;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import javax.swing.JPanel;
import weka.core.Environment;
import weka.core.EnvironmentHandler;
import weka.gui.Logger;
import weka.gui.beans.BeanCommon;
import weka.gui.beans.BeanVisual;
import weka.gui.beans.KFStep;
import weka.gui.beans.TextEvent;
import weka.gui.beans.TextListener;
import weka.gui.beans.Visible;

@KFStep(category="DataSinks", toolTipText="Save text output to a file")
public class TextSaver
extends JPanel
implements TextListener,
BeanCommon,
Visible,
Serializable,
EnvironmentHandler {
    private static final long serialVersionUID = 6363577506969809332L;
    protected BeanVisual m_visual = new BeanVisual("TextSaver", "weka/gui/beans/icons/DefaultText.gif", "weka/gui/beans/icons/DefaultText_animated.gif");
    protected transient Logger m_logger = null;
    protected transient Environment m_env;
    protected String m_fileName;
    protected boolean m_append = true;

    public String globalInfo() {
        return "Save/append static text to a file.";
    }

    public TextSaver() {
        this.useDefaultVisual();
        this.setLayout(new BorderLayout());
        this.add((Component)this.m_visual, "Center");
        this.m_env = Environment.getSystemWide();
    }

    public void setFilename(String filename) {
        this.m_fileName = filename;
    }

    public String getFilename() {
        return this.m_fileName;
    }

    public void setAppend(boolean append) {
        this.m_append = append;
    }

    public boolean getAppend() {
        return this.m_append;
    }

    public void setEnvironment(Environment env) {
        this.m_env = env;
    }

    public void useDefaultVisual() {
        this.m_visual.loadIcons("weka/gui/beans/icons/DefaultText.gif", "weka/gui/beans/icons/DefaultText_animated.gif");
        this.m_visual.setText("TextSaver");
    }

    public void setVisual(BeanVisual newVisual) {
        this.m_visual = newVisual;
    }

    public BeanVisual getVisual() {
        return this.m_visual;
    }

    public void setCustomName(String name) {
        this.m_visual.setText(name);
    }

    public String getCustomName() {
        return this.m_visual.getText();
    }

    public void stop() {
    }

    public boolean isBusy() {
        return false;
    }

    public void setLog(Logger logger) {
        this.m_logger = logger;
    }

    public boolean connectionAllowed(EventSetDescriptor esd) {
        return this.connectionAllowed(esd.getName());
    }

    public boolean connectionAllowed(String eventName) {
        return true;
    }

    public void connectionNotification(String eventName, Object source) {
    }

    public void disconnectionNotification(String eventName, Object source) {
    }

    public synchronized void acceptText(TextEvent textEvent) {
        block13: {
            String content = textEvent.getText();
            if (this.m_fileName != null && this.m_fileName.length() > 0) {
                File file;
                if (this.m_env == null) {
                    this.m_env = Environment.getSystemWide();
                }
                String filename = this.m_fileName;
                try {
                    filename = this.m_env.substitute(this.m_fileName);
                }
                catch (Exception ex) {
                    // empty catch block
                }
                if (filename.toLowerCase().indexOf(".txt") < 0) {
                    filename = filename + ".txt";
                }
                if (!(file = new File(filename)).isDirectory()) {
                    BufferedWriter writer = null;
                    try {
                        writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file, this.m_append), "utf-8"));
                        writer.write(content);
                        writer.close();
                    }
                    catch (IOException e) {
                        if (this.m_logger != null) {
                            this.m_logger.statusMessage(this.statusMessagePrefix() + "WARNING: " + "an error occurred whilte trying to write text (see log)");
                            this.m_logger.logMessage("[" + this.getCustomName() + "] " + "an error occurred whilte trying to write text: " + e.getMessage());
                            break block13;
                        }
                        e.printStackTrace();
                    }
                } else {
                    String message = "Can't write text to file because supplied filename is a directory!";
                    if (this.m_logger != null) {
                        this.m_logger.statusMessage(this.statusMessagePrefix() + "WARNING: " + message);
                        this.m_logger.logMessage("[" + this.getCustomName() + "] " + message);
                    }
                }
            } else {
                String message = "Can't write text because no file has been supplied is a directory!";
                if (this.m_logger != null) {
                    this.m_logger.statusMessage(this.statusMessagePrefix() + "WARNING: " + message);
                    this.m_logger.logMessage("[" + this.getCustomName() + "] " + message);
                }
            }
        }
    }

    private String statusMessagePrefix() {
        return this.getCustomName() + "$" + this.hashCode() + "|";
    }
}

