### R code from vignette source 'SDisc-vignette.Snw'
### Encoding: ISO8859-1

###################################################
### code chunk number 1: dir
###################################################
options(continue="   ")
options(width=85)
dir0 <- dir(recursive=TRUE)


###################################################
### code chunk number 2: installRSDisc (eval = FALSE)
###################################################
## install.packages('SDisc', dep=TRUE)


###################################################
### code chunk number 3: loadRSDisc
###################################################
library(SDisc)


###################################################
### code chunk number 4: pre-cleanup-iris
###################################################
if(file.exists('iris/IMAGE.RData')) 
   file.remove('iris/IMAGE.RData')


###################################################
### code chunk number 5: SDisc-vignette.Snw:84-86
###################################################
iris.set <- SDDataSettings(iris)
iris.set['Species',] <- c(NA,'FALSE',NA,NA,NA,NA)


###################################################
### code chunk number 6: SDisc-vignette.Snw:93-97
###################################################
iris.dat <- SDData(iris, prefix='iris', settings=iris.set)
print(iris.dat, rseed=6014, latex=TRUE)
plot(iris.dat, latex=TRUE)
summary(iris.dat, latex=TRUE)


###################################################
### code chunk number 7: SDisc-vignette.Snw:102-103
###################################################
iris.sd <- SDisc(iris.dat)


###################################################
### code chunk number 8: SDisc-vignette.Snw:110-113
###################################################
plot(iris.sd, latex=TRUE)
print(iris.sd, latex=TRUE)
summary(iris.sd, latex=TRUE)


###################################################
### code chunk number 9: normdep
###################################################
set.seed(6015)
time <- sample(1:5, 50, replace=TRUE)
normdep.df <- matrix(c(rnorm(50), time, 2*time+runif(50)), 50, 3, dimnames=list(list(),c("norm","t","v")))


###################################################
### code chunk number 10: SDisc-vignette.Snw:132-133
###################################################
normdep.df[sample(1:nrow(normdep.df))[1:5]] <- NA


###################################################
### code chunk number 11: SDisc-vignette.Snw:150-153
###################################################
normdep.set <- SDDataSettings(normdep.df)
normdep.set[,'tFun'] <- c('mean sd','', 'lm(v~t)')
normdep <- SDData(normdep.df, settings=normdep.set, prefix='normdep')


###################################################
### code chunk number 12: SDisc-vignette.Snw:155-156
###################################################
SDDataSettings(normdep, latex=TRUE)


###################################################
### code chunk number 13: SDisc-vignette.Snw:162-163
###################################################
naPattern(normdep)


###################################################
### code chunk number 14: SDisc-vignette.Snw:165-166
###################################################
naPattern(normdep, latex=TRUE)


###################################################
### code chunk number 15: SDisc-vignette.Snw:173-174
###################################################
print(normdep, rseed=6013, latex=TRUE)


###################################################
### code chunk number 16: SDisc-vignette.Snw:180-181
###################################################
plot(normdep, latex=TRUE)


###################################################
### code chunk number 17: SDisc-vignette.Snw:188-190
###################################################
summary(normdep, q='mean|sd', latex=TRUE)
summary(normdep, q='lm', latex=TRUE)


###################################################
### code chunk number 18: SDisc-vignette.Snw:196-200
###################################################
set.seed(6016)
time <- sample(1:5, 30, replace=TRUE)
normdep.df2 <- matrix(c(rnorm(30), time, 2*time+runif(30)), 30, 3, dimnames=list(list(), c("norm","t","v")))
normdep2 <- predict(normdep, newdata=normdep.df2, prefix='normdep2')


###################################################
### code chunk number 19: SDisc-vignette.Snw:202-204
###################################################
summary(normdep2, q='lm', latex=TRUE, sanitize=FALSE)
summary(normdep2, q='mean|sd', latex=TRUE)


###################################################
### code chunk number 20: SDisc-vignette.Snw:222-224
###################################################
normdep <- SDisc(normdep, settings=normdep.set, prefix='normdep', cFunSettings=list(modelName=c("EII", "VII",
   "VEI","VVI"), G=3:5, rseed=6013:6023))


###################################################
### code chunk number 21: SDiscBictable
###################################################
summary(bicTable(normdep), latex=TRUE)
print(bicTable(normdep), modelName='VII', G=4, latex=TRUE)


###################################################
### code chunk number 22: SDiscCompare
###################################################
print(normdep, latex=TRUE)


###################################################
### code chunk number 23: SDisc-vignette.Snw:289-293
###################################################
bestAll <- bestModel(normdep)[1]
bestAll
bestG4 <- bestModel(normdep, G=4)[1]
bestG4


###################################################
### code chunk number 24: SDisc-vignette.Snw:296-297
###################################################
print(normdep,  m1=bestAll, m2=bestG4, latex=TRUE)


###################################################
### code chunk number 25: SDiscCharacterize
###################################################
summary(normdep, q=1, latex=TRUE)


###################################################
### code chunk number 26: SDisc-vignette.Snw:315-316
###################################################
sessionInfo()


###################################################
### code chunk number 27: cleanup
###################################################
dir1 <- dir(recursive=TRUE)
dir1 <- dir1[grep('pdf', dir1, invert=T)]
file.remove(dir1[which(!(dir1 %in% dir0))])
# file.remove(c('normdep/IMAGE.RData'))
file.remove(c('normdep2/figures','normdep2/tables'))
file.remove(c('normdep2'))


