### R code from vignette source 'allelematchSuppDoc.Rnw'

###################################################
### code chunk number 1: allelematchSuppDoc.Rnw:46-48
###################################################
library(allelematch)
options(width=65)


###################################################
### code chunk number 2: allelematchSuppDoc.Rnw:176-177
###################################################
data(amExample1)


###################################################
### code chunk number 3: allelematchSuppDoc.Rnw:182-184
###################################################
example1 <- amDataset(amExample1, indexColumn="sampleId",
ignoreColumn="knownIndividual", missingCode="-99")


###################################################
### code chunk number 4: allelematchSuppDoc.Rnw:189-190
###################################################
amUniqueProfile(example1, doPlot=TRUE)


###################################################
### code chunk number 5: allelematchSuppDoc.Rnw:196-197
###################################################
amUniqueProfile(example1, doPlot=TRUE)


###################################################
### code chunk number 6: allelematchSuppDoc.Rnw:209-210
###################################################
uniqueExample1 <- amUnique(example1, alleleMismatch=2)


###################################################
### code chunk number 7: allelematchSuppDoc.Rnw:215-219
###################################################
## Save to disk
## summary(uniqueExample1, html="example1_1.html")
## View in default browser
## summary(uniqueExample1, html=TRUE)


###################################################
### code chunk number 8: allelematchSuppDoc.Rnw:226-227
###################################################
summary(uniqueExample1, csv="example1_1.csv")


###################################################
### code chunk number 9: allelematchSuppDoc.Rnw:232-233
###################################################
summary(uniqueExample1, csv="example1_2.csv", uniqueOnly=TRUE)


###################################################
### code chunk number 10: allelematchSuppDoc.Rnw:238-242
###################################################
example1chk <- amDataset(amExample1, indexColumn="sampleId",
metaDataColumn="knownIndividual", missingCode="-99")
uniqueExample1chk <- amUnique(example1chk, alleleMismatch=2)
## summary(uniqueExample1chk, html="example1_2.html")


###################################################
### code chunk number 11: allelematchSuppDoc.Rnw:251-252
###################################################
data(amExample2)


###################################################
### code chunk number 12: allelematchSuppDoc.Rnw:259-261
###################################################
example2 <- amDataset(amExample2, indexColumn="sampleId",
metaDataColumn="knownIndividual", missingCode="-99")


###################################################
### code chunk number 13: allelematchSuppDoc.Rnw:266-267
###################################################
amUniqueProfile(example2, doPlot=TRUE)


###################################################
### code chunk number 14: allelematchSuppDoc.Rnw:273-274
###################################################
amUniqueProfile(example2, doPlot=TRUE)


###################################################
### code chunk number 15: allelematchSuppDoc.Rnw:286-288
###################################################
uniqueExample2 <- amUnique(example2, alleleMismatch=3)
## summary(uniqueExample2, html="example2_1.html")


###################################################
### code chunk number 16: allelematchSuppDoc.Rnw:295-297
###################################################
uniqueExample2 <- amUnique(example2, alleleMismatch=3, doPsib="all")
## summary(uniqueExample2, html="example2_2.html")


###################################################
### code chunk number 17: allelematchSuppDoc.Rnw:306-307
###################################################
data(amExample3)


###################################################
### code chunk number 18: allelematchSuppDoc.Rnw:314-316
###################################################
example3 <- amDataset(amExample3, indexColumn="sampleId",
metaDataColumn="knownIndividual", missingCode="-99")


###################################################
### code chunk number 19: allelematchSuppDoc.Rnw:321-322
###################################################
amUniqueProfile(example3, doPlot=TRUE)


###################################################
### code chunk number 20: allelematchSuppDoc.Rnw:328-329
###################################################
amUniqueProfile(example3, doPlot=TRUE)


###################################################
### code chunk number 21: allelematchSuppDoc.Rnw:341-343
###################################################
uniqueExample3 <- amUnique(example3, alleleMismatch=6)
## summary(uniqueExample3, html="example3_1.html")


###################################################
### code chunk number 22: allelematchSuppDoc.Rnw:352-354
###################################################
unclassifiedExample3 <- amPairwise(uniqueExample3$unclassified,
uniqueExample3$unique, alleleMismatch=7)


###################################################
### code chunk number 23: allelematchSuppDoc.Rnw:359-360
###################################################
## summary(unclassifiedExample3, html="example3_2.html")


###################################################
### code chunk number 24: allelematchSuppDoc.Rnw:369-373
###################################################
multipleMatchExample3 <- amPairwise(uniqueExample3$multipleMatch,
uniqueExample3$unique, alleleMismatch=6)

## summary(multipleMatchExample3, html="example3_3.html")


###################################################
### code chunk number 25: allelematchSuppDoc.Rnw:382-383
###################################################
summary(uniqueExample3, csv="example3_1.csv")


###################################################
### code chunk number 26: allelematchSuppDoc.Rnw:390-391
###################################################
data(amExample4)


###################################################
### code chunk number 27: allelematchSuppDoc.Rnw:398-400
###################################################
example4 <- amDataset(amExample4, indexColumn="sampleId",
metaDataColumn="knownIndividual", missingCode="-99")


###################################################
### code chunk number 28: allelematchSuppDoc.Rnw:405-406
###################################################
amUniqueProfile(example4, doPlot=TRUE)


###################################################
### code chunk number 29: allelematchSuppDoc.Rnw:412-413
###################################################
amUniqueProfile(example4, doPlot=TRUE)


###################################################
### code chunk number 30: allelematchSuppDoc.Rnw:424-426
###################################################
uniqueExample4 <- amUnique(example4, alleleMismatch=1)
## summary(uniqueExample4, html="example4_1.html")


###################################################
### code chunk number 31: allelematchSuppDoc.Rnw:433-435
###################################################
uniqueExample4ballpark <- amUnique(example4, alleleMismatch=6)
## summary(uniqueExample4ballpark, html="example4_2.html")


###################################################
### code chunk number 32: allelematchSuppDoc.Rnw:442-444
###################################################
uniqueExample4high <- amUnique(example4, alleleMismatch=8)
## summary(uniqueExample4high, html="example4_3.html")


###################################################
### code chunk number 33: allelematchSuppDoc.Rnw:453-454
###################################################
data(amExample5)


###################################################
### code chunk number 34: allelematchSuppDoc.Rnw:461-466
###################################################
head(levels(amExample5$samplingData))
head(levels(amExample5$sampleId))
head(levels(amExample5$gender))
example5 <- amDataset(amExample5, indexColumn="sampleId",
metaDataColumn="samplingData", missingCode="-99")


###################################################
### code chunk number 35: allelematchSuppDoc.Rnw:473-474
###################################################
names(amExample5)


###################################################
### code chunk number 36: allelematchSuppDoc.Rnw:479-480
###################################################
example5map <- c("gender", "LOC1", "LOC1", "LOC2", "LOC2", "LOC3", "LOC3", "LOC4", "LOC4", "LOC5", "LOC5", "LOC6", "LOC6", "LOC7", "LOC7", "LOC8", "LOC8", "LOC9", "LOC9", "LOC10", "LOC10")


###################################################
### code chunk number 37: allelematchSuppDoc.Rnw:485-486
###################################################
example5map <- c(1, rep(2:11, each=2))


###################################################
### code chunk number 38: allelematchSuppDoc.Rnw:491-492
###################################################
amUniqueProfile(example5, multilocusMap = example5map, doPlot=TRUE)


###################################################
### code chunk number 39: allelematchSuppDoc.Rnw:498-499
###################################################
amUniqueProfile(example5, multilocusMap = example5map, doPlot=TRUE)


###################################################
### code chunk number 40: allelematchSuppDoc.Rnw:510-512
###################################################
uniqueExample5 <- amUnique(example5, multilocusMap = example5map, alleleMismatch=3)
## summary(uniqueExample5, html="example5_1.html")


###################################################
### code chunk number 41: allelematchSuppDoc.Rnw:519-522
###################################################
unclassifiedExample5 <-  amPairwise(uniqueExample5$unclassified,
uniqueExample5$unique, alleleMismatch=4)
## summary(unclassifiedExample5, html="example5_2.html")


###################################################
### code chunk number 42: allelematchSuppDoc.Rnw:527-530
###################################################
multipleMatchExample5 <-  amPairwise(uniqueExample5$multipleMatch,
uniqueExample5$unique, alleleMismatch=3)
## summary(multipleMatchExample5, html="example5_3.html")


###################################################
### code chunk number 43: allelematchSuppDoc.Rnw:535-536
###################################################
summary(uniqueExample5, csv="example5_1.csv")


