### R code from vignette source 'tutorial_hmmm.rnw'

###################################################
### code chunk number 1: tutorial_hmmm.rnw:99-100
###################################################
options(prompt = "R> ", continue = "+  ", width = 80, useFancyQuotes = FALSE)


###################################################
### code chunk number 2: tutorial_hmmm.rnw:102-105
###################################################
library("hmmm")
data("accident", package = "hmmm")
y <- getnames(accident, st = 9)


###################################################
### code chunk number 3: tutorial_hmmm.rnw:111-114
###################################################
count<-cbind(row.names(y)[61:72],y[61:72])
colnames(count)<-c("cell names", "counts")
print(count,quote=F)


###################################################
### code chunk number 4: tutorial_hmmm.rnw:132-137
###################################################
margin <- marg.list(c("marg-marg-b-b", "b-marg-b-b", 
"marg-b-b-b", "b-b-b-b"))
model <- hmmm.model(marg = margin, lev = c(3, 4, 3, 2),
names = c("Type", "Time", "Age", "Hour"))
model


###################################################
### code chunk number 5: tutorial_hmmm.rnw:145-148
###################################################
modelB <- hmmm.model(marg = margin, lev = c(3, 4, 3, 2),
names = c("Type", "Time", "Age", "Hour"),
sel = c(12:13, 14:17))


###################################################
### code chunk number 6: tutorial_hmmm.rnw:152-154
###################################################
modB <- hmmm.mlfit(y, modelB)
modB


###################################################
### code chunk number 7: tutorial_hmmm.rnw:157-158 (eval = FALSE)
###################################################
## print(modB, aname = "model B", printflag = TRUE)


###################################################
### code chunk number 8: tutorial_hmmm.rnw:162-163 (eval = FALSE)
###################################################
## summary(modB)


###################################################
### code chunk number 9: tutorial_hmmm.rnw:179-183
###################################################
modelA <- hmmm.model(marg = margin, lev = c(3, 4, 3, 2),
names = c("Type", "Time", "Age", "Hour"), sel = c(12:13, 14:17),
formula = ~ Type * Age * Hour + Time * Age * Hour + Type : Time)
modA <- hmmm.mlfit(y, modelA)


###################################################
### code chunk number 10: tutorial_hmmm.rnw:187-188
###################################################
anova(modA, modB)


###################################################
### code chunk number 11: tutorial_hmmm.rnw:194-198 (eval = FALSE)
###################################################
## modellog <- loglin.model(lev = c(3, 4, 3, 2),
## formula = ~ Type * Age * Hour + Time * Age * Hour + Type : Time,
## names = c("Type", "Time", "Age", "Hour"))
## modlog <- hmmm.mlfit(y, modellog)


###################################################
### code chunk number 12: tutorial_hmmm.rnw:246-251
###################################################
margin <- marg.list(c("marg-marg-l-l", "g-marg-l-l", 
"marg-g-l-l", "g-g-l-l"))
model <- hmmm.model(marg = margin, lev = c(3, 3, 2, 4), 
names = c("In", "Sa", "Co", "Ho"))
model


###################################################
### code chunk number 13: tutorial_hmmm.rnw:263-269
###################################################
modelad1 <- hmmm.model(marg = margin, lev = c(3, 3, 2, 4),
names = c("In", "Sa", "Co", "Ho"), sel = c(18:23, 34:39))
data("madsen", package = "hmmm")
y <- getnames(madsen, st = 6)
modadd1 <- hmmm.mlfit(y, modelad1)
modadd1


###################################################
### code chunk number 14: tutorial_hmmm.rnw:276-280
###################################################
modelad2 <- hmmm.model(marg = margin, lev = c(3, 3, 2, 4),
names = c("In", "Sa", "Co", "Ho"), sel = c(18:23, 34:39, 44:71))
modadd2 <- hmmm.mlfit(y, modelad2)
modadd2


###################################################
### code chunk number 15: tutorial_hmmm.rnw:332-345
###################################################
marginals <- marg.list(c("r-marg", "marg-r", "r-r"))
R1 <- matrix(c(-1, -1,  1,
               -1,  1,  0), 2, 3, byrow = TRUE)
R2<-matrix(c(-1, -1, -1,  0,  1,  1,  1,
             -1, -1, -1,  1,  0,  0,  0,
              1, -1,  0,  0,  0,  0,  0,
              0, -1,  1,  0,  0,  0,  0,
              0,  0,  0,  0,  1, -1,  0,
              0,  0,  0,  0,  0, -1,  1), 6, 7, byrow = TRUE)
rec <- recursive(R1, R2)
model <- hmmm.model(marg = marginals, lev = c(3, 7), 
names = c("Rel", "Pol"), cocacontr = rec)
model


###################################################
### code chunk number 16: tutorial_hmmm.rnw:362-370
###################################################
Emat <- cbind(matrix(0, 2, 4), matrix(c(0, 1, 1, 0, -1, 0, 0, -1), 2, 4), 
matrix(0, 2, 12))
modelE <- hmmm.model(marg = marginals, lev = c(3, 7), 
names = c("Rel", "Pol"), cocacontr = rec, E = Emat)
data("relpol", package = "hmmm")
y <- getnames(relpol, st = 4)
modE <- hmmm.mlfit(y, modelE)
print(modE, printflag = TRUE)


###################################################
### code chunk number 17: tutorial_hmmm.rnw:401-405
###################################################
data("polbirth", package = "hmmm")
y <- getnames(polbirth)
marginals <- marg.list(c("g-marg", "marg-l", "g-l"))
names <- c("Politics", "Birth")


###################################################
### code chunk number 18: tutorial_hmmm.rnw:411-412
###################################################
ineq <- list(marg = c(1, 2), int = list(c(1, 2)), types = c("g", "l"))


###################################################
### code chunk number 19: tutorial_hmmm.rnw:418-420
###################################################
model <- hmmm.model(marg = marginals, dismarg = ineq, lev = c(7, 4), 
names = names)


###################################################
### code chunk number 20: tutorial_hmmm.rnw:430-431
###################################################
mlr <- hmmm.mlfit(y, model, noineq = FALSE)


###################################################
### code chunk number 21: tutorial_hmmm.rnw:437-440
###################################################
model0 <- hmmm.model(marg = marginals, lev = c(7, 4), sel = c(10:27), 
names = names)
mnull <- hmmm.mlfit(y, model0)


###################################################
### code chunk number 22: tutorial_hmmm.rnw:445-446
###################################################
msat <- hmmm.mlfit(y, model)


###################################################
### code chunk number 23: tutorial_hmmm.rnw:454-455
###################################################
test <- hmmm.chibar(nullfit = mnull, disfit = mlr, satfit = msat)


###################################################
### code chunk number 24: tutorial_hmmm.rnw:473-474
###################################################
test


###################################################
### code chunk number 25: tutorial_hmmm.rnw:501-502
###################################################
marginals <- marg.list(c("b-marg", "marg-g", "b-g"))


###################################################
### code chunk number 26: tutorial_hmmm.rnw:516-520
###################################################
al <- list(
Type = ~ Type * (Age + Hour),
Time = ~ Time * (Age + Hour),
Type.Time = ~ Type.Time * (Age + Hour))


###################################################
### code chunk number 27: tutorial_hmmm.rnw:535-538
###################################################
model <- hmmm.model.X(marg = marginals, lev = c(3, 4), 
names = c("Type", "Time"), Formula = al, strata = c(3, 2), 
fnames = c("Age", "Hour"))


###################################################
### code chunk number 28: tutorial_hmmm.rnw:544-548
###################################################
data("accident", package = "hmmm")
y <- getnames(accident, st = 9, sep = ";")
mod1 <- hmmm.mlfit(y, model, y.eps = 0.1)
mod1


###################################################
### code chunk number 29: tutorial_hmmm.rnw:555-556 (eval = FALSE)
###################################################
## summary(mod1)


###################################################
### code chunk number 30: tutorial_hmmm.rnw:568-572
###################################################
alind <- list(
Type = ~ Type * Age + Type * Hour,
Time = ~ Time * Age + Time * Hour,
Type.Time = "zero")


###################################################
### code chunk number 31: tutorial_hmmm.rnw:584-588
###################################################
alpar <- list(
Type = ~ Type + Age + Hour,
Time = ~ Time + Age + Hour,
Type.Time = ~ Type.Time + Age + Hour)


