/*
 * Decompiled with CFR 0.152.
 */
package com.nexagis.jawbone;

import com.nexagis.jawbone.PartOfSpeech;
import com.nexagis.jawbone.Synset;

public final class Pointer {
    private String pointerSymbol;
    private Synset synset = null;
    private PartOfSpeech partOfSpeech;
    private int sourceSynsetWordNumber = 0;
    private int targetSynsetWordNumber = 0;

    private Pointer() {
    }

    public Pointer(String string, long l, char c, int n, int n2) {
        this.pointerSymbol = string;
        this.partOfSpeech = PartOfSpeech.getInstance(c);
        this.sourceSynsetWordNumber = n;
        this.targetSynsetWordNumber = n2;
        this.synset = new Synset(l, this.partOfSpeech);
    }

    public PartOfSpeech getPartOfSpeech() {
        return this.partOfSpeech;
    }

    protected void setPartOfSpeech(char c) {
        this.partOfSpeech = PartOfSpeech.getInstance(c);
    }

    public String getPointerSymbol() {
        return this.pointerSymbol;
    }

    protected void setPointerSymbol(String string) {
        this.pointerSymbol = string;
    }

    public int getSourceSynsetWordNumber() {
        return this.sourceSynsetWordNumber;
    }

    protected void setSourceSynsetWordNumber(int n) {
        this.sourceSynsetWordNumber = n;
    }

    public Synset getSynset() {
        return this.synset;
    }

    protected void setSynset(Synset synset) {
        this.synset = synset;
    }

    public int getTargetSynsetWordNumber() {
        return this.targetSynsetWordNumber;
    }

    protected void setTargetSynsetWordNumber(int n) {
        this.targetSynsetWordNumber = n;
    }

    public static String getPointerDescription(PartOfSpeech partOfSpeech, String string) {
        if (string == null || string.length() < 1) {
            return "";
        }
        if (partOfSpeech.equals(PartOfSpeech.ADJECTIVE)) {
            if (string.equals("!")) {
                return "Antonym";
            }
            if (string.equals("&")) {
                return "Similar to";
            }
            if (string.equals("<")) {
                return "Participle of verb";
            }
            if (string.equals("\\")) {
                return "Partainym (pertains to noun)";
            }
            if (string.equals("=")) {
                return "Attribute";
            }
            if (string.equals("^")) {
                return "Also see";
            }
            if (string.equals(";c")) {
                return "Domain of synset - Topic";
            }
            if (string.equals(";r")) {
                return "Domain of synset - Region";
            }
            if (string.equals(";u")) {
                return "Domain of synset - Usage";
            }
        } else if (partOfSpeech.equals(PartOfSpeech.ADVERB)) {
            if (string.equals("!")) {
                return "Antonym";
            }
            if (string.equals("\\")) {
                return "Derived from adjective";
            }
            if (string.equals(";c")) {
                return "Domain of synset - Topic";
            }
            if (string.equals(";r")) {
                return "Domain of synset - Region";
            }
            if (string.equals(";u")) {
                return "Domain of synset - Usage";
            }
        } else if (partOfSpeech.equals(PartOfSpeech.NOUN)) {
            if (string.equals("!")) {
                return "Antonym";
            }
            if (string.equals("@")) {
                return "Hypernym";
            }
            if (string.equals("@i")) {
                return "Instance Hypernym";
            }
            if (string.equals("~")) {
                return "Hyponym";
            }
            if (string.equals("~i")) {
                return "Instance Hyponym";
            }
            if (string.equals("#m")) {
                return "Member holonym";
            }
            if (string.equals("#s")) {
                return "Substance holonym";
            }
            if (string.equals("#p")) {
                return "Part holonym";
            }
            if (string.equals("%m")) {
                return "Member meronym";
            }
            if (string.equals("%s")) {
                return "Substance meronym";
            }
            if (string.equals("%p")) {
                return "Part meronym";
            }
            if (string.equals("=")) {
                return "Attribute";
            }
            if (string.equals("+")) {
                return "Derivationally related form";
            }
            if (string.equals(";c")) {
                return "Domain of synset - Topic";
            }
            if (string.equals("-c")) {
                return "Member of this domain - Topic";
            }
            if (string.equals(";r")) {
                return "Domain of synset - Region";
            }
            if (string.equals("-r")) {
                return "Member of this domain - Region";
            }
            if (string.equals(";u")) {
                return "Domain of synset - Usage";
            }
            if (string.equals("-u")) {
                return "Member of this domain - Usage";
            }
        } else if (partOfSpeech.equals(PartOfSpeech.VERB)) {
            if (string.equals("!")) {
                return "Antonym";
            }
            if (string.equals("@")) {
                return "Hypernym";
            }
            if (string.equals("~")) {
                return "Hyponym";
            }
            if (string.equals("*")) {
                return "Entailment";
            }
            if (string.equals(">")) {
                return "Cause";
            }
            if (string.equals("^")) {
                return "Also see";
            }
            if (string.equals("$")) {
                return "Verb Group";
            }
            if (string.equals("+")) {
                return "Derivationally related form";
            }
            if (string.equals(";c")) {
                return "Domain of synset - Topic";
            }
            if (string.equals(";r")) {
                return "Domain of synset - Region";
            }
            if (string.equals(";u")) {
                return "Domain of synset - Usage";
            }
        }
        return "[Unknown]";
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(100);
        stringBuffer.append("Symbol: ").append(this.pointerSymbol).append("  Synset-Offset: ").append(this.synset.getSynsetOffset()).append("  POS: ").append(this.partOfSpeech).append("  Source-Word-Number: ").append(this.sourceSynsetWordNumber).append("  Target-Word-Number: ").append(this.targetSynsetWordNumber);
        return stringBuffer.toString();
    }
}

