### R code from vignette source 'vignette.Rnw'

###################################################
### code chunk number 1: vignette.Rnw:17-28
###################################################
library(ezsim)
ezsim_basic<-ezsim(
    m             = 50,
    run           = TRUE,
    display_name  = c(mean_hat="hat(mu)",sd_mean_hat="hat(sigma[hat(mu)])"),
    parameter_def = createParDef(list(n=seq(20,80,20),mu=c(0,2),sigma=c(1,3,5))),
    dgp           = function() rnorm(n,mu,sigma),
    estimator     = function(x) c(mean_hat = mean(x), 
                                 sd_mean_hat=sd(x)/sqrt(length(x)-1)),
    true_value    = function() c(mu, sigma / sqrt(n-1))
)


###################################################
### code chunk number 2: vignette.Rnw:29-31
###################################################
summary_ezsim_basic<-summary(ezsim_basic)
head(summary_ezsim_basic,16)


###################################################
### code chunk number 3: vignette.Rnw:32-34 (eval = FALSE)
###################################################
## plot(ezsim_basic)
## plot(ezsim_basic,"density")


###################################################
### code chunk number 4: vignette.Rnw:37-38
###################################################
print(plot(ezsim_basic,return_print=TRUE)[[1]])


###################################################
### code chunk number 5: vignette.Rnw:41-42
###################################################
print(plot(ezsim_basic,return_print=TRUE)[[2]])


###################################################
### code chunk number 6: vignette.Rnw:45-46
###################################################
print(plot(ezsim_basic,"density",return_print=TRUE)[[1]])


###################################################
### code chunk number 7: vignette.Rnw:49-50
###################################################
print(plot(ezsim_basic,"density",return_print=TRUE)[[2]])


###################################################
### code chunk number 8: vignette.Rnw:73-75
###################################################
par_def<-createParDef(selection=list(n=seq(20,80,20),mu=c(0,2),sigma=c(1,3,5)))
par_def


###################################################
### code chunk number 9: vignette.Rnw:78-79
###################################################
generate(par_def)[1:3]


###################################################
### code chunk number 10: vignette.Rnw:83-85
###################################################
par_def2<-createParDef(selection=list(mu1=5,mu2=3,n=c(10,20)), banker=list(Sigma=matrix(c(1,.4,.4,1),nrow=2)))
generate(par_def2)


###################################################
### code chunk number 11: vignette.Rnw:91-94
###################################################
dgp<-function(){
	rnorm(n,mu,sigma)
}


###################################################
### code chunk number 12: vignette.Rnw:96-99
###################################################
evalFunctionOnParameterDef(par_def,dgp,index=1)
evalFunctionOnParameterDef(par_def,dgp,index=2)



###################################################
### code chunk number 13: vignette.Rnw:101-108
###################################################
dgp_2<-function(){
    z1<-rnorm(n)
    z2<-rnorm(n)
    cbind(x1=mu1+z1*Sigma[1,1], x2=mu2+ Sigma[2,2]*(Sigma[1,2]*z1+ sqrt(1-Sigma[1,2]^2)*z2 ))
}
evalFunctionOnParameterDef(par_def2,dgp_2)



###################################################
### code chunk number 14: vignette.Rnw:112-116
###################################################
estimator<-function(x){
    c(mean_hat = mean(x), sd_mean_hat=sd(x)/sqrt(length(x)-1))
}
estimator(evalFunctionOnParameterDef(par_def,dgp,index=1))


###################################################
### code chunk number 15: vignette.Rnw:121-125
###################################################
true<-function(){
    c(mu, sigma / sqrt(n-1))
}
evalFunctionOnParameterDef(par_def,true)


###################################################
### code chunk number 16: vignette.Rnw:130-131
###################################################
display_name<-c(mean_hat="hat(mu)",sd_mean_hat="hat(sigma[hat(mu)])")


###################################################
### code chunk number 17: vignette.Rnw:139-140
###################################################
summary(ezsim_basic,subset=list(estimator="mean_hat",n=c(20,40),sigma=c(1,3)))


###################################################
### code chunk number 18: vignette.Rnw:144-145
###################################################
summary(ezsim_basic,simple=FALSE,subset=list(estimator="mean_hat",n=c(20,40),sigma=c(1,3)))


###################################################
### code chunk number 19: vignette.Rnw:149-152
###################################################
summary(ezsim_basic,stat=c("q25","median","q75"),Q025=quantile(value_of_estimator,0.025),
Q975=quantile(value_of_estimator,0.975),
subset=list(estimator="mean_hat",n=c(20,40),sigma=c(1,3)))


###################################################
### code chunk number 20: vignette.Rnw:162-163 (eval = FALSE)
###################################################
## plot(ezsim_basic,subset=list(estimator="sd_mean_hat",mu=3))


###################################################
### code chunk number 21: vignette.Rnw:164-166
###################################################
print(plot(ezsim_basic,subset=list(estimator="sd_mean_hat",mu=0),return_print=TRUE)[[1]])



###################################################
### code chunk number 22: vignette.Rnw:167-168 (eval = FALSE)
###################################################
## plot(ezsim_basic,subset=list(estimator="mean_hat",sigma=3))


###################################################
### code chunk number 23: vignette.Rnw:169-170
###################################################
print(plot(ezsim_basic,subset=list(estimator="mean_hat",sigma=3),return_print=TRUE)[[1]])


###################################################
### code chunk number 24: vignette.Rnw:176-178 (eval = FALSE)
###################################################
## plot(ezsim_basic,subset=list(estimator="sd_mean_hat",mu=0),
## parameters_priority=c("sigma","n"))


###################################################
### code chunk number 25: vignette.Rnw:179-180
###################################################
print(plot(ezsim_basic,subset=list(estimator="sd_mean_hat",mu=0),parameters_priority="sigma",return_print=TRUE)[[1]])


###################################################
### code chunk number 26: vignette.Rnw:181-182 (eval = FALSE)
###################################################
## plot(ezsim_basic,subset=list(estimator="mean_hat",sigma=c(1,3)),parameters_priority="mu")


###################################################
### code chunk number 27: vignette.Rnw:183-184
###################################################
print(plot(ezsim_basic,subset=list(estimator="mean_hat",sigma=c(1,3)),parameters_priority="mu",return_print=TRUE)[[1]])


###################################################
### code chunk number 28: vignette.Rnw:190-191 (eval = FALSE)
###################################################
## plot(ezsim_basic,"density",subset=list(estimator="mean_hat",sigma=3),parameters_priority="n",benchmark=dnorm)


###################################################
### code chunk number 29: vignette.Rnw:192-193
###################################################
print(plot(ezsim_basic,"density",benchmark=dnorm,subset=list(estimator="mean_hat",sigma=3),parameters_priority="n",return_print=TRUE)[[1]])


###################################################
### code chunk number 30: vignette.Rnw:194-195 (eval = FALSE)
###################################################
## plot(ezsim_basic,"density",subset=list(estimator="mean_hat",mu=0),parameters_priority="n" ,benchmark=dnorm)


###################################################
### code chunk number 31: vignette.Rnw:196-197
###################################################
print(plot(ezsim_basic,"density",benchmark=dnorm,subset=list(estimator="mean_hat",mu=0),parameters_priority="n",return_print=TRUE)[[1]])


###################################################
### code chunk number 32: vignette.Rnw:202-203 (eval = FALSE)
###################################################
## plot(summary(ezsim_basic,c("q25","q75")))


###################################################
### code chunk number 33: vignette.Rnw:204-205
###################################################
print(plot(summary(ezsim_basic,c("q25","q75")),return_print=TRUE))


###################################################
### code chunk number 34: vignette.Rnw:206-207 (eval = FALSE)
###################################################
## plot(summary(ezsim_basic,c("q25","q75"),subset=list(estimator="mean_hat")))


###################################################
### code chunk number 35: vignette.Rnw:208-209
###################################################
print(plot(summary(ezsim_basic,c("q25","q75"),subset=list(estimator="mean_hat")),return_print=TRUE))


###################################################
### code chunk number 36: vignette.Rnw:210-211 (eval = FALSE)
###################################################
## plot(summary(ezsim_basic,c("median"),subset=list(estimator="sd_mean_hat")))


###################################################
### code chunk number 37: vignette.Rnw:212-213
###################################################
print(plot(summary(ezsim_basic,c("median"),subset=list(estimator="sd_mean_hat")),return_print=TRUE))


###################################################
### code chunk number 38: vignette.Rnw:220-242
###################################################
ez_powerfun<-ezsim(
    m             = 100,
    run           = TRUE,
    display_name  = c(b="beta",es="sigma[e]^2",xs="sigma[x]^2"),
    parameter_def = createParDef(selection=list(xs=1,n=50,es=5,b=seq(-1,1,0.1))),
    dgp           = function(){
                        x<-rnorm(n,0,xs)
                        e<-rnorm(n,0,es)
                        y<-b * x + e
                        data.frame(y,x)
                    },
    estimator     = function(d){
                        r<-summary(lm(y~x-1,data=d))
                        stat<-r$coef[,1]/r$coef[,2]

                        # test whether b > 0
                        # level of significance : 5%
                        out <- stat > c(qnorm(.95), qt(0.95,df=r$df[2]))
                        names(out)<-c("z-test","t-test")
                        out
                    }
)


###################################################
### code chunk number 39: vignette.Rnw:245-246 (eval = FALSE)
###################################################
## plot(ez_powerfun,"powerfun",null_hypothesis=0)


###################################################
### code chunk number 40: vignette.Rnw:247-248
###################################################
print(plot(ez_powerfun,"powerfun",null_hypothesis=0,return_print=TRUE))


