/*
 * Decompiled with CFR 0.152.
 */
package org.af.gMCP.gui.dialogs;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseListener;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.text.JTextComponent;
import org.af.commons.io.FileTools;
import org.af.commons.widgets.RightClickTextMenuListener;
import org.af.gMCP.config.Configuration;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class TextFileViewer
extends JDialog
implements ActionListener {
    JTextArea jta;
    JButton save = new JButton("Save");
    private static final Log logger = LogFactory.getLog(TextFileViewer.class);

    public TextFileViewer(JFrame p, File file) {
        super((Frame)p, file.getName());
        String text;
        try {
            text = FileTools.readFileAsString((File)file);
        }
        catch (IOException e) {
            JOptionPane.showMessageDialog(p, "File \"" + file.getAbsolutePath() + "\" not found!", "File not found", 0);
            this.dispose();
            return;
        }
        this.setUp(text, null);
        this.jta.addMouseListener((MouseListener)new RightClickTextMenuListener((JTextComponent)this.jta));
    }

    public TextFileViewer(JFrame p, String title, String text) {
        super((Frame)p, title);
        this.setUp(text, null);
        this.jta.addMouseListener((MouseListener)new RightClickTextMenuListener((JTextComponent)this.jta));
    }

    public TextFileViewer(JFrame p, String title, String text, boolean save) {
        super((Frame)p, title);
        if (save) {
            this.save.addActionListener(this);
            this.setUp(text, this.save, 2, 6, 1);
        } else {
            this.setUp(text, null);
        }
        this.jta.addMouseListener((MouseListener)new RightClickTextMenuListener((JTextComponent)this.jta));
    }

    public TextFileViewer(JFrame p, String title, String text, String label) {
        super((Frame)p, title);
        JTextArea jlabel = new JTextArea(label);
        jlabel.setOpaque(false);
        jlabel.setEditable(false);
        this.setUp(text, jlabel);
        this.jta.addMouseListener((MouseListener)new RightClickTextMenuListener((JTextComponent)this.jta));
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.save) {
            File f = null;
            try {
                JFileChooser fc = new JFileChooser(Configuration.getInstance().getClassProperty(this.getClass(), "SaveDirectory"));
                fc.setDialogType(1);
                int returnVal = fc.showSaveDialog(this);
                if (returnVal == 0) {
                    f = fc.getSelectedFile();
                    Configuration.getInstance().setClassProperty(this.getClass(), "SaveDirectory", f.getParent());
                    if (!f.getName().toLowerCase().endsWith(".txt")) {
                        f = new File(f.getAbsolutePath() + ".txt");
                    }
                } else {
                    return;
                }
                logger.info((Object)("Export to: " + f.getAbsolutePath() + "."));
                BufferedWriter out = new BufferedWriter(new FileWriter(f));
                String output = this.jta.getText().replaceAll("\n", System.getProperty("line.separator"));
                out.write(output);
                out.close();
            }
            catch (IOException ioe) {
                JOptionPane.showMessageDialog(this, "Saving to '" + f.getAbsolutePath() + "' failed: " + ioe.getMessage(), "Saving failed.", 0);
            }
            return;
        }
        this.dispose();
    }

    private void setUp(String text, Component comp) {
        this.setUp(text, comp, 2, 4, 3);
    }

    private void setUp(String text, Component comp, int row, int col, int w) {
        this.jta = new JTextArea(text);
        this.jta.setFont(new Font("Monospaced", 0, 12));
        this.jta.setLineWrap(true);
        this.jta.setWrapStyleWord(true);
        this.jta.setMargin(new Insets(4, 4, 4, 4));
        String cols = "5dlu, fill:pref:grow, 5dlu, pref, 5dlu";
        String rows = "5dlu, fill:200dlu:grow, 5dlu, pref, 5dlu, pref, 5dlu";
        FormLayout layout = new FormLayout(cols, rows);
        this.getContentPane().setLayout((LayoutManager)layout);
        CellConstraints cc = new CellConstraints();
        JScrollPane jsp = new JScrollPane(this.jta);
        this.getContentPane().add((Component)jsp, cc.xyw(2, 2, 3));
        if (comp != null) {
            this.getContentPane().add(comp, cc.xyw(row, col, w));
        }
        JButton jb = new JButton("OK");
        jb.addActionListener(this);
        this.getContentPane().add((Component)jb, cc.xy(4, 6));
        this.pack();
        this.setSize(800, 600);
        this.setLocationRelativeTo(this.getParent());
        this.setVisible(true);
    }
}

