/*
 * Decompiled with CFR 0.152.
 */
package org.af.gMCP.gui.options;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import org.af.commons.widgets.WidgetFactory;
import org.af.commons.widgets.lists.IntegerJComboBox;
import org.af.gMCP.config.Configuration;
import org.af.gMCP.gui.options.OptionsDialog;
import org.af.gMCP.gui.options.OptionsPanel;
import org.af.gMCP.gui.options.SetLookAndFeelException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class GeneralPanel
extends OptionsPanel
implements ActionListener {
    private static final Log logger = LogFactory.getLog(GeneralPanel.class);
    private IntegerJComboBox cbFontSize;
    private JComboBox cbLookAndFeel;
    private JTextField jtfGrid;
    private JTextField jtfNumberOfDigits;
    private JTextField jtfLineWidth;
    private Configuration conf = Configuration.getInstance();
    private OptionsDialog odialog;
    private JCheckBox colorImages;
    private JCheckBox showRejected;
    private JCheckBox showFractions;
    private JCheckBox useJLaTeXMath;
    private JCheckBox markEpsilon;
    JFrame parent;

    public GeneralPanel(JFrame parent, OptionsDialog odialog) {
        this.odialog = odialog;
        this.parent = parent;
        this.makeComponents();
        this.doTheLayout();
    }

    private void makeComponents() {
        this.cbFontSize = new IntegerJComboBox(8, 20);
        this.cbFontSize.setSelectedObject((Object)this.conf.getGeneralConfig().getFontSize());
        this.cbFontSize.setToolTipText("<html>Font size of the text in the GUI widgets.</html>");
        this.jtfGrid = new JTextField(30);
        this.jtfGrid.setText("" + this.conf.getGeneralConfig().getGridSize());
        this.jtfGrid.setToolTipText("<html>For easier placement of nodes a grid can be used that aligns the<br>nodes to its intersections. You can specify a positive integer<br>that sets the grid size, i.e. the width in pixels between two<br>proximate parallel lines. If you set the grid size to 1 this would<br>allow unrestricted placement and therefore disables the grid.</html>");
        this.jtfNumberOfDigits = new JTextField(30);
        this.jtfNumberOfDigits.setText("" + this.conf.getGeneralConfig().getDigits());
        this.jtfNumberOfDigits.setToolTipText("<html>Number of digits to be shown at various places.<br>In this version not every part of the GUI will use<br>this value, but this will improve in further versions.</html>");
        this.jtfLineWidth = new JTextField(30);
        this.jtfLineWidth.setText("" + this.conf.getGeneralConfig().getLineWidth());
        this.jtfLineWidth.setToolTipText("<html>Especially if you want to use exported PNG graphics in other<br>documents, you may want to adjust the line width of edges<br>and nodes, when borders look to thin or thick.</html>");
        Vector<String> looknfeel = new Vector<String>();
        looknfeel.add("System");
        looknfeel.add("Windows");
        looknfeel.add("Mac OS");
        looknfeel.add("Motif");
        looknfeel.add("Metal (highly recommended default)");
        this.cbLookAndFeel = new JComboBox(looknfeel);
        String currentLookNFeel = this.conf.getJavaConfig().getLooknFeel();
        logger.info((Object)("LooknFeel is " + currentLookNFeel + "."));
        for (int i = 0; i < looknfeel.size(); ++i) {
            this.cbLookAndFeel.setSelectedIndex(i);
            if (this.getLooknFeel().equals(currentLookNFeel)) break;
            logger.debug((Object)("Not " + this.getLooknFeel()));
        }
        this.cbLookAndFeel.setToolTipText("<html>The way the widgets of a GUI look and how they behave is<br>called \"look and feel\" in Java. Depending on your operating<br>system and classpath several Look'n'Feel implementations may<br>be available (e.g. Metal (Java default), Windows, Mac OS,<br>Motif and/or System/GTK).<br>If you are used to a particular Look'n'Feel, you can select<br>it here. But if you have problems with the graphical interface,<br>please try to use the default Metal theme to check whether it<br>could be a problem with the selected Look'n'Feel.</html>");
        this.colorImages = new JCheckBox("Colored image files and pdf reports");
        this.colorImages.setSelected(this.conf.getGeneralConfig().getColoredImages());
        this.colorImages.setToolTipText("<html>Colors are used to highlight different conditions in the graph<br>like hypotheses that could be rejected. While these colors are<br>helpful in the GUI, you perhaps prefer black and white PNG image<br>files and PDF reports.</html>");
        this.showFractions = new JCheckBox("Show fractions instead of decimal numbers");
        this.showFractions.setSelected(this.conf.getGeneralConfig().showFractions());
        this.showFractions.setToolTipText("<html>Floating point numbers are used for all calculations and<br>values like $1/3$ would be normally shown as $0.3333333$.<br>When this option is active the method fractions from package<br>MASS is used to display fractions whenever the floating point<br>numbers are close to a fraction that looks right.</html>");
        this.showRejected = new JCheckBox("Show rejected nodes in GUI");
        this.showRejected.setSelected(this.conf.getGeneralConfig().showRejected());
        this.showRejected.setToolTipText("<html>When using the GUI to for stepwise rejection of hypotheses,<br>this options determines whether rejected nodes should<br>\"disappear\" or whether they remain on the screen and are<br>only marked as rejected.</html>");
        this.useJLaTeXMath = new JCheckBox("Use JLaTeXMath");
        this.useJLaTeXMath.setSelected(this.conf.getGeneralConfig().useJLaTeXMath());
        this.useJLaTeXMath.setToolTipText("<html>There are not many reasons not to use the free Java library<br>JLaTeXMath to render numbers, symbols and formulas in the<br>GUI. The option is mainly provided in case that errors occur<br>displaying the numbers and formulas.</html>");
        this.markEpsilon = new JCheckBox("Show epsilon edges as dashed lines.");
        this.markEpsilon.setSelected(this.conf.getGeneralConfig().markEpsilon());
        this.markEpsilon.setToolTipText("<html>You can set whether epsilon edges should<br>been shown as dashed or solid lines.</html>");
    }

    private void doTheLayout() {
        JPanel p1 = new JPanel();
        String cols = "pref, 5dlu, fill:pref:grow";
        String rows = "pref, 5dlu, pref, 5dlu, pref, 5dlu, pref, 5dlu, pref, 5dlu, pref, 5dlu, pref, 5dlu, pref, 5dlu, pref, 5dlu, pref, 5dlu, pref, 5dlu, pref, 5dlu, pref, 5dlu, pref";
        FormLayout layout = new FormLayout(cols, rows);
        p1.setLayout((LayoutManager)layout);
        CellConstraints cc = new CellConstraints();
        int row = 1;
        p1.add((Component)new JLabel("Grid:"), cc.xy(1, row));
        p1.add((Component)this.jtfGrid, cc.xy(3, row));
        p1.add((Component)new JLabel("Number of digits:"), cc.xy(1, row += 2));
        p1.add((Component)this.jtfNumberOfDigits, cc.xy(3, row));
        p1.add((Component)new JLabel("Line width:"), cc.xy(1, row += 2));
        p1.add((Component)this.jtfLineWidth, cc.xy(3, row));
        p1.add((Component)new JLabel("Font Size"), cc.xy(1, row += 2));
        p1.add((Component)this.cbFontSize, cc.xy(3, row));
        p1.add((Component)new JLabel("Look'n'Feel"), cc.xy(1, row += 2));
        p1.add((Component)this.cbLookAndFeel, cc.xy(3, row));
        p1.add((Component)this.colorImages, cc.xyw(1, row += 2, 3));
        p1.add((Component)this.showRejected, cc.xyw(1, row += 2, 3));
        p1.add((Component)this.useJLaTeXMath, cc.xyw(1, row += 2, 3));
        p1.add((Component)this.showFractions, cc.xyw(1, row += 2, 3));
        p1.add((Component)this.markEpsilon, cc.xyw(1, row += 2, 3));
        row += 2;
        this.add(p1);
    }

    private String lfID2FullName(String id) {
        if (id.equals("Metal (highly recommended default)")) {
            return UIManager.getCrossPlatformLookAndFeelClassName();
        }
        if (id.equals("System")) {
            return UIManager.getSystemLookAndFeelClassName();
        }
        if (id.equals("Motif")) {
            return "com.sun.java.swing.plaf.motif.MotifLookAndFeel";
        }
        if (id.equals("Windows")) {
            return "com.sun.java.swing.plaf.windows.WindowsLookAndFeel";
        }
        if (id.equals("Mac OS")) {
            return "javax.swing.plaf.mac.MacLookAndFeel";
        }
        return null;
    }

    private String getLooknFeel() {
        String lf = this.lfID2FullName(this.cbLookAndFeel.getSelectedItem().toString());
        if (lf == null) {
            logger.warn((Object)"No LooknFeel selected! How can this be?");
        }
        return lf;
    }

    public void setProperties() throws SetLookAndFeelException {
        try {
            int grid = Integer.parseInt(this.jtfGrid.getText());
            this.conf.getGeneralConfig().setGridSize(grid);
        }
        catch (NumberFormatException e) {
            JOptionPane.showMessageDialog(this, "\"" + this.jtfGrid.getText() + "\" is not a valid integer for grid size.", "Invalid input", 0);
        }
        try {
            int lw = Integer.parseInt(this.jtfLineWidth.getText());
            this.conf.getGeneralConfig().setLineWidth(lw);
        }
        catch (NumberFormatException e) {
            JOptionPane.showMessageDialog(this, "\"" + this.jtfLineWidth.getText() + "\" is not a valid integer for line width.", "Invalid input", 0);
        }
        try {
            int digits = Integer.parseInt(this.jtfNumberOfDigits.getText());
            this.conf.getGeneralConfig().setDigits(digits);
        }
        catch (NumberFormatException e) {
            JOptionPane.showMessageDialog(this, "\"" + this.jtfNumberOfDigits.getText() + "\" is not a valid integer for the number of digits.", "Invalid input", 0);
        }
        this.conf.getGeneralConfig().setColoredImages(this.colorImages.isSelected());
        this.conf.getGeneralConfig().setShowRejected(this.showRejected.isSelected());
        this.conf.getGeneralConfig().setShowFractions(this.showFractions.isSelected());
        this.conf.getGeneralConfig().setUseJLaTeXMath(this.useJLaTeXMath.isSelected());
        this.conf.getGeneralConfig().setMarkEpsilon(this.markEpsilon.isSelected());
        try {
            String currentLF = this.conf.getJavaConfig().getLooknFeel();
            logger.info((Object)("Selected LooknFeel:" + this.getLooknFeel()));
            if (!this.getLooknFeel().equals(currentLF)) {
                this.setLooknFeel(this.getLooknFeel());
                int n = JOptionPane.showConfirmDialog(this.parent, "Keep this Look'n'Feel?", "Keep this Look'n'Feel?", 0);
                if (n == 0) {
                    this.conf.getJavaConfig().setLooknFeel(this.getLooknFeel());
                } else {
                    this.setLooknFeel(currentLF);
                }
            }
        }
        catch (Exception exc) {
            JOptionPane.showMessageDialog(this.parent, "The selected LooknFeel is not available.", "Selected LooknFeel not available.", 2);
        }
        int fontSize = (Integer)this.cbFontSize.getSelectedObject();
        if (this.conf.getGeneralConfig().getFontSize() != fontSize) {
            this.conf.getGeneralConfig().setFontSize(fontSize);
            WidgetFactory.setFontSizeGlobal((int)this.conf.getGeneralConfig().getFontSize());
            SwingUtilities.updateComponentTreeUI(this.parent);
            SwingUtilities.updateComponentTreeUI(this.odialog);
            this.odialog.pack();
        }
    }

    private void setLooknFeel(String id) throws ClassNotFoundException, IllegalAccessException, InstantiationException, UnsupportedLookAndFeelException {
        UIManager.setLookAndFeel(id);
        SwingUtilities.updateComponentTreeUI(this.parent);
        SwingUtilities.updateComponentTreeUI(this.odialog);
        this.odialog.pack();
    }

    private void setLooknFeel(LookAndFeel lf) throws ClassNotFoundException, IllegalAccessException, InstantiationException, UnsupportedLookAndFeelException {
        this.setLooknFeel(this.lfID2FullName(lf.getID()));
    }

    public void actionPerformed(ActionEvent e) {
    }
}

