/*
 * Decompiled with CFR 0.152.
 */
package org.af.gMCP.gui.options;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.af.commons.widgets.validate.ValidationException;
import org.af.gMCP.config.Configuration;
import org.af.gMCP.gui.options.OptionsPanel;

public class NumericPanel
extends OptionsPanel
implements ActionListener {
    private JCheckBox useEpsApprox;
    private JTextField jtfEps;
    private JCheckBox tryToSimplify;
    private JTextField jtfDigits;
    private JCheckBox verbose;
    private Configuration conf;
    private JTextField numberOfSimulations;
    private JComboBox randomNumbers;
    private JComboBox parametricAlgo;
    String[] tests = new String[]{"Bretz2011", "simple-parametric"};

    public NumericPanel(Configuration conf) {
        this.conf = conf;
        this.makeComponents();
        this.doTheLayout();
    }

    private void makeComponents() {
        this.useEpsApprox = new JCheckBox("Use epsilon approximation");
        this.useEpsApprox.setSelected(this.conf.getGeneralConfig().useEpsApprox());
        this.useEpsApprox.addActionListener(this);
        this.useEpsApprox.setEnabled(false);
        this.useEpsApprox.setToolTipText("<html>In this version this value can not be changed.<br>No calculations with infinitesimal small values are done<br>but instead the epsilon is approximated by a small real number.</html>");
        this.jtfEps = new JTextField(30);
        this.jtfEps.setText("" + this.conf.getGeneralConfig().getEpsilon());
        this.jtfEps.setEnabled(this.conf.getGeneralConfig().useEpsApprox());
        this.jtfEps.setToolTipText("<html>The small real value that should be used to approximate<br>the infinitesimal small epsilon. Default is 0.001.</html>");
        this.tryToSimplify = new JCheckBox("Try to show fractions / rounded numbers");
        this.tryToSimplify.setSelected(this.conf.getGeneralConfig().simplify());
        this.tryToSimplify.addActionListener(this);
        this.tryToSimplify.setEnabled(false);
        this.tryToSimplify.setToolTipText("<html></html>");
        this.jtfDigits = new JTextField(30);
        this.jtfDigits.setText("" + this.conf.getGeneralConfig().getDigits2());
        this.jtfDigits.setEnabled(this.conf.getGeneralConfig().simplify());
        this.jtfDigits.setToolTipText("<html></html>");
        this.verbose = new JCheckBox("Verbose output of algorithms");
        this.verbose.setSelected(this.conf.getGeneralConfig().verbose());
        this.verbose.setToolTipText("<html>If checked the selected the algorithms produce a verbose<br>output that is shown in the GUI. For example the Simes<br>test specifies for each intersection of elementar hypotheses<br>whether and why it could be rejected.</html>");
        this.numberOfSimulations = new JTextField(30);
        this.numberOfSimulations.setText("" + this.conf.getGeneralConfig().getNumberOfSimulations());
        this.numberOfSimulations.setToolTipText("<html>The Monte Carlo sample size for power calculations.<br>Default is 10000.</html>");
        this.randomNumbers = new JComboBox<String>(new String[]{"quasirandom", "pseudorandom"});
        this.randomNumbers.setSelectedIndex(this.conf.getGeneralConfig().getTypeOfRandom().equals("quasirandom") ? 0 : 1);
        this.randomNumbers.setToolTipText("<html>You can select quasirandom or pseudorandom numbers for<br>power calculations. The quasirandom option uses a randomized<br>Lattice rule, and should be more efficient than the<br>pseudorandom option that uses ordinary (pseudo) random numbers.</html>");
        this.parametricAlgo = new JComboBox<String>(new String[]{"Yes", "No"});
        this.parametricAlgo.setSelectedIndex(this.conf.getGeneralConfig().getParametricTest().equals("Bretz2011") ? 0 : 1);
        this.parametricAlgo.setToolTipText("<html>Please see the manual for an explanation.</html>");
    }

    private void doTheLayout() {
        JPanel p1 = new JPanel();
        String cols = "pref, 5dlu, fill:pref:grow";
        String rows = "pref, 5dlu, pref, 5dlu, pref, 5dlu, pref, 5dlu, pref, 5dlu, pref, 5dlu, pref, 5dlu, pref";
        FormLayout layout = new FormLayout(cols, rows);
        p1.setLayout((LayoutManager)layout);
        CellConstraints cc = new CellConstraints();
        int row = 1;
        p1.add((Component)this.useEpsApprox, cc.xyw(1, row, 3));
        p1.add((Component)new JLabel("Epsilon:"), cc.xy(1, row += 2));
        p1.add((Component)this.jtfEps, cc.xy(3, row));
        p1.add((Component)this.verbose, cc.xyw(1, row += 2, 3));
        p1.add((Component)new JLabel("Monte Carlo sample size for power:"), cc.xy(1, row += 2));
        p1.add((Component)this.numberOfSimulations, cc.xy(3, row));
        p1.add((Component)new JLabel("Type of random numbers:"), cc.xy(1, row += 2));
        p1.add((Component)this.randomNumbers, cc.xy(3, row));
        p1.add((Component)new JLabel("Weights of subgraphs are upscaled to 1:"), cc.xy(1, row += 2));
        p1.add((Component)this.parametricAlgo, cc.xy(3, row));
        this.add(p1);
    }

    public void setProperties() throws ValidationException {
        this.conf.getGeneralConfig().setVerbose(this.verbose.isSelected());
        this.conf.getGeneralConfig().setUseEpsApprox(this.useEpsApprox.isSelected());
        try {
            double eps = Double.parseDouble(this.jtfEps.getText());
            this.conf.getGeneralConfig().setEps(eps);
        }
        catch (NumberFormatException e) {
            JOptionPane.showMessageDialog(this, "\"" + this.jtfEps.getText() + "\" is not a valid double for epsilon.", "Invalid input", 0);
        }
        this.conf.getGeneralConfig().setSimplify(this.tryToSimplify.isSelected());
        try {
            int nr = Integer.parseInt(this.jtfDigits.getText());
            this.conf.getGeneralConfig().setDigits2(nr);
        }
        catch (NumberFormatException e) {
            JOptionPane.showMessageDialog(this, "\"" + this.jtfDigits.getText() + "\" is not a valid integer.", "Invalid input", 0);
        }
        try {
            this.conf.getGeneralConfig().setNumberOfSimulations(Integer.parseInt(this.numberOfSimulations.getText()));
        }
        catch (NumberFormatException e) {
            JOptionPane.showMessageDialog(this, "\"" + this.numberOfSimulations.getText() + "\" is not a valid integer.", "Invalid input", 0);
        }
        this.conf.getGeneralConfig().setTypeOfRandom(this.randomNumbers.getSelectedItem().toString());
        this.conf.getGeneralConfig().setParametricTest(this.tests[this.parametricAlgo.getSelectedIndex()]);
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.useEpsApprox) {
            this.jtfEps.setEnabled(this.useEpsApprox.isSelected());
        }
    }
}

