### R code from vignette source 'mixstock.Rnw'

###################################################
### code chunk number 1: mixstock.Rnw:27-30
###################################################
Rver <- paste(R.version$major,R.version$minor,sep=".")
Rver <- "2.14.1"  ## override -- using devel version
options(continue=" ")


###################################################
### code chunk number 2: mixstock.Rnw:140-141 (eval = FALSE)
###################################################
## install.packages(c("mixstock","plotrix","coda","abind","R2WinBUGS"))


###################################################
### code chunk number 3: mixstock.Rnw:156-157
###################################################
library(mixstock)


###################################################
### code chunk number 4: mixstock.Rnw:229-230 (eval = FALSE)
###################################################
## mydata = read.table("mydata.dat",header=TRUE)


###################################################
### code chunk number 5: mixstock.Rnw:235-236 (eval = FALSE)
###################################################
## mydata = read.csv("mydata.csv")


###################################################
### code chunk number 6: mixstock.Rnw:255-257
###################################################
data(lahanas98raw)
mydata = lahanas98raw


###################################################
### code chunk number 7: mixstock.Rnw:262-263 (eval = FALSE)
###################################################
## mydata


###################################################
### code chunk number 8: mixstock.Rnw:266-267
###################################################
head(mydata)


###################################################
### code chunk number 9: mixstock.Rnw:273-274
###################################################
mydata = as.mixstock.data(mydata)


###################################################
### code chunk number 10: mixstock.Rnw:282-283
###################################################
plot(mydata,mix.off=2)


###################################################
### code chunk number 11: mixstock.Rnw:293-309 (eval = FALSE)
###################################################
## require(ggplot2)
## require(reshape2)
## tmpf <- function(m0) {
##   mm1 <- as.matrix(m0)
##   mm2 <- sweep(mm1,2,colSums(mm1),"/")
##   transform(melt(mm2),
##             Var1=factor(Var1,levels=rownames(m0)))
## }
## m2 <- matrix(mydata$mixsamp,ncol=1,dimnames=list(names(mydata$mixsamp),"Mixed"))
## g1 <- ggplot(tmpf(mydata$sourcesamp),aes(x=Var2,y=value,fill=Var1))+geom_bar()+coord_flip()+
##   scale_fill_brewer(palette="Set3")+theme_bw()+labs(x="")
## g2 <- ggplot(tmpf(m2),aes(x=Var2,y=value,fill=Var1))+geom_bar()+coord_flip()+
##   scale_fill_brewer(palette="Set3")+theme_bw()+labs(x="")+opts(legend.position="none")
## ## library(ggExtra)
## ## align.plots(g1,g2,heights=unit(c(0.1,0.9)))
## print()


###################################################
### code chunk number 12: mixstock.Rnw:332-333
###################################################
mydata = markfreq.condense(mydata)


###################################################
### code chunk number 13: mixstock.Rnw:344-345
###################################################
data(lahanas98)


###################################################
### code chunk number 14: mixstock.Rnw:349-350
###################################################
data(bolten98)


###################################################
### code chunk number 15: mixstock.Rnw:358-359
###################################################
plot(lahanas98,mix.off=2,leg.space=0.4)


###################################################
### code chunk number 16: mixstock.Rnw:379-381
###################################################
mydata.cml = cml(mydata)
mydata.cml


###################################################
### code chunk number 17: mixstock.Rnw:392-393 (eval = FALSE)
###################################################
## plot(mydata.cml)


###################################################
### code chunk number 18: mixstock.Rnw:397-398
###################################################
plot(mydata.cml)


###################################################
### code chunk number 19: mixstock.Rnw:420-421
###################################################
mydata.uml = uml(mydata)


###################################################
### code chunk number 20: mixstock.Rnw:436-439 (eval = FALSE)
###################################################
## par(ask=TRUE)
## plot(mydata.uml,plot.freqs=TRUE)
## par(ask=FALSE)


###################################################
### code chunk number 21: mixstock.Rnw:446-447 (eval = FALSE)
###################################################
## mydata.umlboot = genboot(mydata,"uml")


###################################################
### code chunk number 22: mixstock.Rnw:449-453
###################################################
if (!file.exists("umlboot.RData")) {
  t1 <- system.time(mydata.umlboot <- genboot(mydata,"uml"))
  save("t1","mydata.umlboot",file="umlboot.RData",compress=TRUE)
} else load("umlboot.RData")


###################################################
### code chunk number 23: mixstock.Rnw:466-467
###################################################
confint(mydata.umlboot)


###################################################
### code chunk number 24: mixstock.Rnw:471-472
###################################################
plot(mydata.umlboot)


###################################################
### code chunk number 25: mixstock.Rnw:479-480 (eval = FALSE)
###################################################
## mydata.mcmc = tmcmc(mydata)


###################################################
### code chunk number 26: mixstock.Rnw:482-486
###################################################
if (!file.exists("mcmc.RData")) {
  mydata.mcmc <- tmcmc(mydata)
  save("mydata.mcmc",file="mcmc.RData",compress=TRUE)
} else load("mcmc.RData")


###################################################
### code chunk number 27: mixstock.Rnw:489-491
###################################################
mydata.mcmc
confint(mydata.mcmc)


###################################################
### code chunk number 28: mixstock.Rnw:493-494 (eval = FALSE)
###################################################
## plot(mydata.mcmc)


###################################################
### code chunk number 29: mixstock.Rnw:504-505
###################################################
plot(mydata.mcmc)


###################################################
### code chunk number 30: mixstock.Rnw:519-520 (eval = FALSE)
###################################################
## diag1=calc.RL.0(mydata)


###################################################
### code chunk number 31: mixstock.Rnw:524-528
###################################################
if (!file.exists("RL.RData")) {
  diag1=calc.RL.0(mydata)
  save("diag1",file="RL.RData")
} else load("RL.RData")


###################################################
### code chunk number 32: mixstock.Rnw:550-551
###################################################
head(diag1$current)


###################################################
### code chunk number 33: mixstock.Rnw:560-561
###################################################
diag1$history


###################################################
### code chunk number 34: mixstock.Rnw:569-570 (eval = FALSE)
###################################################
## diag2=calc.GR(mydata)


###################################################
### code chunk number 35: mixstock.Rnw:572-576
###################################################
if (!file.exists("GR.RData")) {
  diag2=calc.GR(mydata)
  save("diag2",file="GR.RData")
} else load("GR.RData")


###################################################
### code chunk number 36: mixstock.Rnw:626-632
###################################################
Z = simmixstock2(nsource=4,nmark=5,nmix=3,
                 sourcesize=c(4,2,1,1),
                 sourcesampsize=rep(25,4),
                 mixsampsize=rep(30,3),rseed=1001)               
Z
plot(Z)


###################################################
### code chunk number 37: mixstock.Rnw:636-647
###################################################
if (!file.exists("wbugs_cache.RData")) {
  ## FIXME: would be more efficient to run Zfit0 and then convert
  ##  the results rather than fitting the whole model twice!
  st0 <- system.time(Zfit0 <- mm.wbugs(Z,sourcesize=c(4,2,1,1),
                                       returntype="bugs",pkg="JAGS"))
  st1 <- system.time(Zfit <- mm.wbugs(Z,sourcesize=c(4,2,1,1),
                                      pkg="JAGS"))
  st2 <- system.time(Zfit2 <- mm.wbugs(Z,sourcesize=c(4,2,1,1),
                                       bugs.code="BB",pkg="JAGS"))
  save("st0","st1","st2","Zfit","Zfit2","Zfit0",file="wbugs_cache.RData")
} else load("wbugs_cache.RData")


###################################################
### code chunk number 38: mixstock.Rnw:650-655 (eval = FALSE)
###################################################
## ## tests
## st3 <- system.time(Zfit0 <- mm.wbugs(Z,sourcesize=c(4,2,1,1),
##                                      bugs.code="BB",pkg="JAGS"))
## Zfit2 <- mm.wbugs(Z,sourcesize=c(4,2,1,1),bugs.code="BB",n.iter=200)
## Zfit3 <- mm.wbugs(Z,sourcesize=c(4,2,1,1),bugs.code="BB",n.iter=1000,pkg="JAGS")


###################################################
### code chunk number 39: mixstock.Rnw:659-660 (eval = FALSE)
###################################################
## Zfit0 = mm.wbugs(Z,sourcesize=c(4,2,1,1),returntype="bugs")


###################################################
### code chunk number 40: mixstock.Rnw:709-710 (eval = FALSE)
###################################################
## plot(Zfit0)


###################################################
### code chunk number 41: mixstock.Rnw:714-715
###################################################
plot(as.mcmc.bugs(Zfit0))


###################################################
### code chunk number 42: mixstock.Rnw:719-720
###################################################
print(plot(Zfit))


###################################################
### code chunk number 43: mixstock.Rnw:724-725
###################################################
print(plot(Zfit,sourcectr=TRUE))


###################################################
### code chunk number 44: mixstock.Rnw:729-730
###################################################
summary(Zfit)


###################################################
### code chunk number 45: mixstock.Rnw:749-755 (eval = FALSE)
###################################################
## install.packages("mixstock")
## install.packages("plotrix")
## install.packages("coda")
## install.packages("abind")
## install.packages("R2WinBUGS") ## or 
## install.packages("R2jags")


###################################################
### code chunk number 46: mixstock.Rnw:764-765 (eval = FALSE)
###################################################
## mydata = hapfreq.condense(as.mixstock.data(read.csv("myfile.dat")))


###################################################
### code chunk number 47: mixstock.Rnw:769-773 (eval = FALSE)
###################################################
## mydata.mcmc = tmcmc(mydata)
## mydata.mcmc
## intervals(mydata.mcmc)
## plot(mydata.mcmc)


