/*
 * Decompiled with CFR 0.152.
 */
package dsa;

import dsa.NodeInfoModel;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.logging.Logger;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.text.Document;

public class NodeInfoComponent
extends JComponent
implements PropertyChangeListener {
    private static Logger logger = Logger.getLogger(NodeInfoComponent.class.getName());
    private NodeInfoModel model;
    private final JLabel plot;

    public NodeInfoComponent(NodeInfoModel model) {
        this.model = model;
        model.addPropertyChangeListener(this);
        this.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.weightx = 100.0;
        gbc.weighty = 0.0;
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridwidth = 2;
        gbc.gridheight = 1;
        gbc.insets = new Insets(12, 6, 6, 6);
        JLabel title = new JLabel(model.getTitle());
        if (model.getToolTip() != null) {
            title.setToolTipText(model.getToolTip());
        }
        title.setFont(new Font("SansSerif", 1, 20));
        this.add((Component)title, gbc);
        String[] labels = model.getLabels();
        for (int i = 0; i < labels.length; ++i) {
            String label = labels[i];
            Document doc = model.getDocument(label);
            JLabel lab = new JLabel(label);
            GridBagConstraints lgbc = new GridBagConstraints();
            lgbc.weightx = 0.0;
            lgbc.weighty = 0.0;
            lgbc.gridx = 0;
            lgbc.gridy = i + 1;
            lgbc.gridwidth = 1;
            lgbc.gridheight = 1;
            lgbc.anchor = 17;
            this.add((Component)lab, lgbc);
            JTextField tf = new JTextField(doc, "", 10);
            tf.setEditable(false);
            GridBagConstraints tgbc = new GridBagConstraints();
            tgbc.weightx = 100.0;
            tgbc.weighty = 0.0;
            tgbc.weighty = 0.0;
            tgbc.gridx = 1;
            tgbc.gridy = i + 1;
            tgbc.gridwidth = 1;
            tgbc.gridheight = 1;
            tgbc.fill = 2;
            this.add((Component)tf, tgbc);
        }
        gbc = new GridBagConstraints();
        gbc.weightx = 100.0;
        gbc.weighty = 100.0;
        gbc.gridx = 0;
        gbc.gridy = labels.length + 1;
        gbc.gridwidth = 2;
        gbc.gridheight = 1;
        Icon image = model.getImage();
        this.plot = new JLabel(image);
        this.add((Component)this.plot, gbc);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        this.plot.setIcon(this.model.getImage());
    }
}

