### R code from vignette source 'PlanorInRmanual.Rnw'

###################################################
### code chunk number 1: ex1a
###################################################
library("planor")
ABCD.fact <- planor.factors(factors=c("A","B","C","D"), 
                            nlevels=rep(2,4))


###################################################
### code chunk number 2: ex1b
###################################################
ABCD.mod <- planor.model(
      model= ~ A + B + C + D + A:B + A:C + A:D + B:C + B:D + C:D,
      estimate=~ A + B + C + D)


###################################################
### code chunk number 3: ex1c
###################################################
ABCD.key <- planor.designkey(factors=ABCD.fact, 
                             model=ABCD.mod, 
                             nunits=8,
                             base=~A+B+C)


###################################################
### code chunk number 4: ex1d
###################################################
ABCD.sys <- planor.design(ABCD.key)
print(ABCD.sys@design)


###################################################
### code chunk number 5: ex1e
###################################################
ABCD.factL <- planor.factors(factors=list(
                               A=c("small","big"), 
                               B=c("cold","hot"), 
                               C=c("black","white"), 
                               D=c("yes","no")))
ABCD.key <- planor.designkey(factors=ABCD.factL, 
                             model=ABCD.mod, 
                             nunits=8)


###################################################
### code chunk number 6: ex1f
###################################################
ABCD.rand <- planor.design(ABCD.key, randomize=~UNITS)
print(ABCD.rand@design)


###################################################
### code chunk number 7: ABCD3.a
###################################################
ABCD3.key <- planor.designkey(factors=c("Bl",LETTERS[1:4]),
                              nlevels=rep(3,5),
                              block=~Bl,
                              model=~Bl+(A+B+C+D)^2,
                              estimate=~A+B+C+D,
                              nunits=27,
                              base=~A+B+C,
                              max.sol=Inf)


###################################################
### code chunk number 8: ABCD3niv.b
###################################################
print(ABCD3.key[1])


###################################################
### code chunk number 9: ABCD3.b
###################################################
alias(ABCD3.key[1], model=~Bl+(A+B+C+D)^2)


###################################################
### code chunk number 10: ABCD3.c
###################################################
alias(ABCD3.key[34], model=~Bl+(A+B+C+D)^2)


###################################################
### code chunk number 11: robot.a1
###################################################
robotFac <- planor.factors( factors=list(
                        conc=c("1%","3%"),
                        Tact=c("15mn","30mn"),
                        nsoil=c("curd","Saint-Paulin"),
                        qsoil=c("10mg","100mg"),
                        rough=c(0.25,0.73),
                        plate=1:4,
                        col=1:4,
                        u=1:2),
                     block=~plate+col,
                     hierarchy=list(~nsoil/(plate*col),
                                    ~qsoil/(plate*col),
                                    ~conc/plate,
                                    ~Tact/plate))


###################################################
### code chunk number 12: robot.a2
###################################################
robotMod <- planor.model( model=~nsoil * qsoil * rough * conc * Tact,
                    listofmodels=list(c(~plate*col+rough,~rough)) )


###################################################
### code chunk number 13: robot.a3
###################################################
robotKeyA <- planor.designkey(factors=robotFac, 
                              model=robotMod,
                              nunits=32, 
                              base=~plate+col+u)


###################################################
### code chunk number 14: robot.b
###################################################
robotFacB <- planor.factors(factors=list(
                        nsoil=c("curd","Saint-Paulin"),
                        qsoil=c("10mg","100mg"),
                        rough=c(0.25,0.73),
                        conc=c("1%","3%"),
                        Tact=c("15mn","30mn"),
                        plate=5:6,
                        col=1:4,
                        u=1:2),
                     block=~plate+col,
                     hierarchy=list(~nsoil/(plate*col),
                                    ~qsoil/(plate*col),
                                    ~conc/plate,
                                    ~Tact/plate))
robotModB <- planor.model( model=~nsoil * qsoil * rough * conc,
                    listofmodels=list(c(~plate*col+rough,~rough),
                                      c(~Tact,~Tact)) )
robotKeyB <- planor.designkey(factors=robotFacB, model=robotModB, 
                    nunits=16, base=~plate+col+u )


###################################################
### code chunk number 15: robot.print (eval = FALSE)
###################################################
## print(robotKeyA)
## print(robotKeyB)


###################################################
### code chunk number 16: robot.print
###################################################
print(robotKeyA)


###################################################
### code chunk number 17: robot.print
###################################################
print(robotKeyB)


###################################################
### code chunk number 18: robot.plan
###################################################
robotPlanA <- planor.design(robotKeyA)@design
robotPlanB <- planor.design(robotKeyB)@design
robotPlan <- rbind(robotPlanA[c("plate","col",
                                "nsoil","qsoil",
                                "rough","conc","Tact")],
                   robotPlanB[c("plate","col",
                                "nsoil","qsoil",
                                "rough","conc","Tact")])


###################################################
### code chunk number 19: robot.planA.print (eval = FALSE)
###################################################
## print(robotPlanA)
## print(robotPlanB)
## print(robotPlan)


###################################################
### code chunk number 20: robot.planA.print
###################################################
print(robotPlanA)


###################################################
### code chunk number 21: robot.planB.print
###################################################
print(robotPlanB)


###################################################
### code chunk number 22: robot.plan.print
###################################################
print(robotPlan)


###################################################
### code chunk number 23: robot.rand
###################################################
robotRand <- planor.randomize(~plate/col/UNITS, data=robotPlan) 
write.table(robotRand, file="ROBOT.out", quote=FALSE, 
                       row.names=FALSE, sep=" ")


###################################################
### code chunk number 24: robot.rand
###################################################
print(robotRand)


###################################################
### code chunk number 25: robpl1r4.a
###################################################
robpl1r4.fac <- planor.factors(factors=list(
                                 row1=1:2,
                                 row2=1:2,
                                 col1=1:2,
                                 col2=1:2,
                                 nsoil=c("curd","Saint-Paulin"),
                                 qsoil=c("10mg","100mg"),
                                 cbact=c("3%","6%"),
                                 Tact=c("15mn","30mn"),
                                 conc=c("1%","3%"),
                                 brush=c("strong","weak"),
                                 rough=c(0.25,0.75),
                                 nat=1:2),
                               block=~row1+row2+col1+col2,
                               hierarchy=list(~nsoil/(col1*col2*row2),
                                 ~cbact/(col1*col2*row2),
                                 ~Tact/(row1*row2),
                                 ~conc/(row1*row2),
                                 ~brush/(row1*row2*col1)))

robpl1r4.mod <- planor.model( listofmodels=list(
  c( ~row2 + (nsoil+qsoil+cbact+Tact+conc+brush+rough+nat)^2,
     ~nsoil+qsoil+cbact+Tact+conc+brush+rough+nat), 
  c( ~col1*col2*row2 + row1*row2*col1,                        
     ~rough+nat)) )

robpl1r4.key <- planor.designkey(factors=robpl1r4.fac, 
                                 model=robpl1r4.mod, 
                                 nunits=16, 
                                 base=~row1+row2+col1+col2 )

#summary(robpl1r4.key)


###################################################
### code chunk number 26: robpl1r4.rand
###################################################
robpl1r4.rand <- planor.design(robpl1r4.key, 
                               randomize=~col1/col2 + row1/row2)
print(robpl1r4.rand@design)


###################################################
### code chunk number 27: robpl1r4.alias
###################################################
alias(robpl1r4.key, 
      model=~row1*row2*col1*col2 + 
             (nsoil+qsoil+cbact+Tact+conc+brush+rough+nat)^2)


###################################################
### code chunk number 28: robpl1r5.a
###################################################
robpl1r5.fac <- planor.factors(factors=list(
                                 row1=1:2, row2=1:2, col=1:4,
                                 nsoil=c("curd","Saint-Paulin"),
                                 #qsoil=c("10mg","100mg"),
                                 cbact=c("3%","6%"),
                                 Tact=c("15mn","30mn"),
                                 conc=c("1%","3%"),
                                 #brush=c("strong","weak"),
                                 rough=c(0.25,0.75)),
                                 #nat=1:2),
                               block=~row1+row2+col,
                               hierarchy=list(~nsoil/(col*row2),
                                 ~cbact/(col*row2),
                                 ~Tact/(row1*row2),
                                 ~conc/(row1*row2)))
                                 #~brush/(row1*row2*col1)))

robpl1r5.mod <- planor.model( listofmodels=list(
 c(~(nsoil+cbact+Tact+conc+rough)^2, ~(nsoil+cbact+Tact+conc+rough)^2), 
 c(~row2 + nsoil+cbact+Tact+conc+rough, ~nsoil+cbact+Tact+conc+rough),
 c(~col + rough, ~rough) ) )

robpl1r5.key <- planor.designkey(factors=robpl1r5.fac, 
                                 model=robpl1r5.mod, 
                                 nunits=16, 
                                 base=~row1+row2+col)



###################################################
### code chunk number 29: robpl1r5.a
###################################################
robpl1r5.modbis <- planor.model( listofmodels=list(
 c(~(nsoil+cbact+Tact+conc+rough)^2, ~(nsoil+cbact+Tact+conc+rough)^2), 
 c(~row2 + nsoil+cbact+Tact+conc+rough, ~nsoil+cbact+Tact+conc+rough),
 c(~col*row2 + rough, ~rough) ) )

robpl1r5bis.key <- planor.designkey(factors=robpl1r5.fac, 
                                 model=robpl1r5.modbis, 
                                 nunits=16, 
                                 base=~row1+row2+col)



###################################################
### code chunk number 30: robpl1r5.b
###################################################
#summary(robpl1r5.key)
alias(robpl1r5.key, 
      model=~col*row1*row2 + (nsoil+cbact+Tact+conc+rough)^2)


###################################################
### code chunk number 31: robpl1r5.a (eval = FALSE)
###################################################
## size32r4.fac <- planor.factors(factors=LETTERS[1:12], 
##                                nlevels=c(4, rep(2,11)))
## 
## size32r4.mod <- planor.model(model=~(A+B+C+D+E+F+G+H+I+J+K+L)^2,
##                              estimate=~A+B+C+D+E+F+G+H+I+J+K+L)
## 
## size32r4.key <- planor.designkey(factors=size32r4.fac,
##                                  model=size32r4.mod, 
##                                  nunits=32, 
##                                  base=~A+B+C+D)


###################################################
### code chunk number 32: robpl2r5.a (eval = FALSE)
###################################################
## robpl2r5.fac <- planor.factors(factors=list(
##                                  plate=1:2, 
##                                  row1=1:2, row2=1:2, col=1:4,
##                                  nsoil=c("curd","Saint-Paulin"),
##                                  qsoil=c("10mg","100mg"),
##                                  cbact=c("3%","6%"),
##                                  Tact=c("15mn","30mn"),
##                                  conc=c("1%","3%"),
##                                  #brush=c("strong","weak"),
##                                  rough=c(0.25,0.75)),
##                                  #nat=1:2),
##                                block=~plate+row1+row2+col,
##                                hierarchy=list(~nsoil/(col*row2),
##                                  ~cbact/(col*row2),
##                                  ~Tact/(row1*row2),
##                                  ~conc/(row1*row2)))
##                                  #~brush/(row1*row2*col1)))
## 
## robpl2r5.mod <- planor.model( listofmodels=list(
##   c( ~plate + (nsoil+qsoil+cbact+Tact+conc+rough)^2,    
##      ~plate + (nsoil+qsoil+cbact+Tact+conc+rough)^2), 
##   c( ~plate*row2 + nsoil+qsoil+cbact+Tact+conc+rough,     
##      ~             nsoil+qsoil+cbact+Tact+conc+rough),
##   c( ~plate*col*row2 + rough, 
##      ~                 rough) ) )
## 
## robpl2r5.key <- planor.designkey(factors=robpl2r5.fac, 
##                                  model=robpl2r5.mod, 
##                                  nunits=32, 
##                                  base=~plate+row1+row2+col)
## 
## summary(robpl2r5.key)
## alias(robpl2r5.key, 
##       model=~plate + (nsoil+qsoil+cbact+Tact+conc+rough)^2)


###################################################
### code chunk number 33: robpl2f8r4.a (eval = FALSE)
###################################################
## robpl2f8r4.fac <- planor.factors(factors=list(
##                                  plate=1:2, 
##                                  row1=1:2, row2=1:2, 
##                                  col1=1:2, col2=1:2,
##                                  nsoil=c("curd","Saint-Paulin"),
##                                  qsoil=c("10mg","100mg"),
##                                  cbact=c("3%","6%"),
##                                  Tact=c("15mn","30mn"),
##                                  conc=c("1%","3%"),
##                                  brush=c("strong","weak"),
##                                  rough=c(0.25,0.75),
##                                  nat=1:2),
##                                  block=~plate+row1+row2+col1+col2,
##                                  hierarchy=list(
##                                    ~nsoil/(plate*col1*col2*row2),
##                                    ~cbact/(plate*col1*col2*row2),
##                                    ~Tact/(plate*row1*row2),
##                                    ~conc/(plate*row1*row2),
##                                    ~brush/(plate*row1*row2*col1)))
## 
## robpl2f8r4.mod <- planor.model( listofmodels=list(
##   c( ~plate + (nsoil+qsoil+cbact+Tact+conc+brush+rough+nat)^2,    
##      ~plate +  nsoil+qsoil+cbact+Tact+conc+brush+rough+nat), 
##   c( ~plate*row2 + nsoil+qsoil+cbact+Tact+conc+brush+rough+nat,     
##      ~             nsoil+qsoil+cbact+Tact+conc+brush+rough+nat),
##   c( ~plate*col1*col2*row2 + rough+nat, 
##      ~                       rough+nat) ) )
## 
## robpl2f8r4.key <- planor.designkey(factors=robpl2f8r4.fac, 
##                                    model=robpl2f8r4.mod, 
##                                    nunits=32, 
##                                    base=~plate+row1+row2+col1+col2,
##                                    max.sol=20,
##                                    randomsearch=TRUE)
## 
## summary(robpl2f8r4.key)
## alias(robpl2f8r4.key, 
##       model=~plate*row1*row2*col1*col2 +
##         (nsoil+qsoil+cbact+Tact+conc+brush+rough+nat)^2)


###################################################
### code chunk number 34: robpl2f4r5.a (eval = FALSE)
###################################################
## robpl2f4r5.fac <- planor.factors(factors=list(
##                                    plate=1:2, 
##                                    row1=1:2, row2=1:2, col=1:4, 
##                                    nsoil=1:4,
##                                    cbact=c("3%","6%"),
##                                    Tact=c("15mn","30mn"),
##                                    conc=c("1%","3%"),
##                                    rough=c(0.25,0.75)),
##                                  block=~plate+row1+row2+col,
##                                  hierarchy=list(
##                                    ~nsoil/(plate*col*row2),
##                                    ~cbact/(plate*col*row2),
##                                    ~Tact/(plate*row1*row2),
##                                    ~conc/(plate*row1*row2)))
## 
## robpl2f4r5.mod <- planor.model( listofmodels=list(
##   c( ~plate + (nsoil+cbact+Tact+conc+rough)^2,    
##                       ~plate + (nsoil+cbact+Tact+conc+rough)^2), 
##   c( ~plate*row2 + cbact+Tact+conc+rough,     
##                       ~cbact+Tact+conc+rough) ) )
## 
## robpl2f4r5.key <- planor.designkey(factors=robpl2f4r5.fac, 
##                                    model=robpl2f4r5.mod, 
##                                    nunits=32, 
##                                    base=~plate+row1+row2+col)
## 
## summary(robpl2f4r5.key)
## alias(robpl2f4r5.key, model=~plate*row1*row2*col
##                              + (nsoil+cbact+Tact+conc+rough)^2)


###################################################
### code chunk number 35: n32f4and7f2r4.a (eval = FALSE)
###################################################
## n32f4and7f2r4.fac <- planor.factors(factors=LETTERS[1:8], 
##                                      nlevels=c(4, rep(2,7)))
## 
## n32f4and7f2r4.mod <- planor.model( model=~(A+B+C+D+E+F+G+H)^2,
##                                    estimate=~A+B+C+D+E+F+G+H )
## 
## n32f4and7f2r4.key <- planor.designkey(factors=n32f4and7f2r4.fac, 
##                                       model=n32f4and7f2r4.mod, 
##                                       nunits=32, 
##                                       base=~A+B+C+D,
##                                       max.sol=20,
##                                       randomsearch=TRUE)
## 
## summary(n32f4and7f2r4.key)
## alias(n32f4and7f2r4.key, model=~(A+B+C+D+E+F+G+H)^2)


###################################################
### code chunk number 36: rop2f4r4.a (eval = FALSE)
###################################################
## rop2f4r4.fac <- planor.factors(factors=list(
##                                  plate=1:2, 
##                                  row1=1:2, row2=1:2, 
##                                  col1=1:2, col2=1:2,
##                                  nsoil=1:4,
##                                  qsoil=c("10mg","100mg"),
##                                  cbact=c("3%","6%"),
##                                  Tact=c("15mn","30mn"),
##                                  conc=c("1%","3%"),
##                                  brush=c("strong","weak"),
##                                  rough=c(0.25,0.75),
##                                  nat=1:2),
##                                  block=~plate+row1+row2+col1+col2,
##                                  hierarchy=list(
##                                    ~nsoil/(plate*col1*col2*row2),
##                                    ~cbact/(plate*col1*col2*row2),
##                                    ~Tact/(plate*row1*row2),
##                                    ~conc/(plate*row1*row2),
##                                    ~brush/(plate*row1*row2*col1)))
## 
## rop2f4r4.mod <- planor.model(
##   model= ~plate + (nsoil+qsoil+cbact+Tact+conc+brush+rough+nat)^2,   
##   estimate= ~      nsoil+qsoil+cbact+Tact+conc+brush+rough+nat )
## 
## rop2f4r4.key <- planor.designkey(factors=rop2f4r4.fac, 
##                                    model=rop2f4r4.mod, 
##                                    nunits=32, 
##                                    base=~plate+row1+row2+col1+col2)
## 
## summary(rop2f4r4.key)
## alias(rop2f4r4.key, 
##   model=~plate*row1*row2*col1*col2
##         + (nsoil+qsoil+cbact+Tact+conc+brush+rough+nat)^2)


###################################################
### code chunk number 37: n64fr4f4and13f2r4.a (eval = FALSE)
###################################################
## n64w4f4f2r4.key <- planor.designkey(
##   factors=LETTERS[1:17], 
##   nlevels=c(rep(4,4), rep(2,13)), 
##   model=~(A+B+C+D+E+F+G+H+I+J+K+L+M+N+O+P+Q)^2, 
##   estimate=~A+B+C+D+E+F+G+H+I+J+K+L+M+N+O+P+Q, 
##   nunits=64, base=~A+B+C)
## 
## n64w3f4f2r4.key <- planor.designkey(
##   factors=LETTERS[1:17], 
##   nlevels=c(rep(4,3), rep(2,14)), 
##   model=~(A+B+C+D+E+F+G+H+I+J+K+L+M+N+O+P+Q)^2, 
##   estimate=~A+B+C+D+E+F+G+H+I+J+K+L+M+N+O+P+Q, 
##   nunits=64, base=~A+B+C)
## 
## n64w2f4f2r4.key <- planor.designkey(
##   factors=LETTERS[1:17], 
##   nlevels=c(rep(4,2), rep(2,15)), 
##   model=~(A+B+C+D+E+F+G+H+I+J+K+L+M+N+O+P+Q)^2, 
##   estimate=~A+B+C+D+E+F+G+H+I+J+K+L+M+N+O+P+Q, 
##   nunits=64, base=~A+B+C+D)
## 
## n64w1f4f2r4.key <- planor.designkey(
##   factors=LETTERS[1:17], 
##   nlevels=c(rep(4,1), rep(2,16)), 
##   model=~(A+B+C+D+E+F+G+H+I+J+K+L+M+N+O+P+Q)^2, 
##   estimate=~A+B+C+D+E+F+G+H+I+J+K+L+M+N+O+P+Q,
##   nunits=64, base=~A+B+C+D+E)
## 


###################################################
### code chunk number 38: par5522.a (eval = FALSE)
###################################################
## par5522.key <- planor.designkey(
##   factors=c("A1","A2","B1","B2","C1","C2",LETTERS[4:13]), 
##   nlevels=rep(2,16), 
##   listofmodels=list(
##     c(~A1*A2+B1*B2+C1*C2+D+E+F+G+H+I+J+K+L+M, 
##       ~A1*A2+B1*B2+C1*C2+D+E+F+G+H+I+J+K+L+M),
##     c(~1,
##       ~(A1:A2+B1:B2+C1:C2)^3 + 
##         (A1:A2+B1:B2+C1:C2)*(A1+A2+B1+B2+C1+C2+D+E+F+G+H+I+J+K+L+M)^2)),
##   nunits=32, base=~A1+A2+B1+B2+D)


###################################################
### code chunk number 39: par5522n64.a (eval = FALSE)
###################################################
## par5522n64.key <- planor.designkey(
##   factors=c("A1","A2","B1","B2","C1","C2","D1","D2",LETTERS[5:23]), 
##   nlevels=rep(2,27), 
##   listofmodels=list(
##     c(~A1*A2+B1*B2+C1*C2+D1*D2+E+F+G+H+I+J+K+L+M+N+O+P+Q+R+S+T+U+V+W, 
##       ~A1*A2+B1*B2+C1*C2+D1*D2+E+F+G+H+I+J+K+L+M+N+O+P+Q+R+S+T+U+V+W),
##     c(~1,
##       ~(A1:A2+B1:B2+C1:C2+D1:D2)^3 + 
##         (A1:A2+B1:B2+C1:C2+D1:D2)*
##         (A1+A2+B1+B2+C1+C2+D1+D2+E+F+G+H+I+
##                                   J+K+L+M+N+O+P+Q+R+S+T+U+V+W)^2)),
##   nunits=64, base=~A1+A2+B1+B2+C1+C2)


###################################################
### code chunk number 40: resol34g.a
###################################################
set.seed(1234)
completeFoldover.key <- planor.designkey(
  factors=c("A1","A2","C1","C2",LETTERS[c(5:8,10:12)]), 
  nlevels=rep(2,11), 
  listofmodels=list(c(~A1*A2+C1*C2+E+F+G+H+J+K+L, 
                      ~A1*A2+C1*C2+E+F+G+H+J+K+L),
                    c(~(A1+A2+C1+C2+E+F+G+H+J+K+L)^2, 
                      ~A1:A2+C1:C2)),
  nunits=32, base=~A1+A2+C1+C2+E, max.sol=10, randomsearch=TRUE)

partialFoldover.key <- planor.designkey(
  factors=c("A1","A2","C1","C2",LETTERS[c(5:8,10:12)]),
  nlevels=rep(2,11), 
  listofmodels=list(
    c(~A1*A2+C1*C2+E+F+G+H+J+K+L, 
      ~A1*A2+C1*C2+E+F+G+H+J+K+L),
    c(~1, ~(A1*A2+G+H+J+K+C1:C2)^3 + 
      (A1*A2+G+H+J+K+C1:C2)*(C1+C2+E+F+L)^2)),
  nunits=32, base=~A1+A2+C1+C2+E, max.sol=10, randomsearch=TRUE)


###################################################
### code chunk number 41: unir4a.a (eval = FALSE)
###################################################
## iblock.key <- planor.designkey(factors=c("Bl","T",LETTERS[1:9]), 
##                                nlevels=c(8,2,4,4,4,rep(2,6)),
##                                block=~Bl,
##                                hierarchy=~T/Bl,
##                                listofmodels=list(
##                                  c(~Bl + (A+B+C+D+E+F+G+H+I+T)^2,
##                                    ~A+B+C+D+E+F+G+H+I),
##                                  c(~(A+B+C+D+E+F+G+H+I+T)^2, ~T)),
##                                nunits=64, base=~A+B+C, 
##                                max.sol=20, randomsearch=TRUE)


###################################################
### code chunk number 42: several.models.and.hierachies
###################################################
typical <- planor.designkey(
  factors=c(LETTERS[1:8], "BL"), 
  nlevels=c(rep(2,8),8), 
  hierarchy=list(~A/BL, ~B/BL, ~C/BL, ~D/BL),
  listofmodels=list(
    noblock.model=c(~(A+B+C+D)^2, ~A+B+C+D),
    block.model=c(~BL + (A+B+C+D+E+F+G+H)^2, 
                  ~(A+B+C+D+E+F+G+H) : (E+F+G+H))),
  nunits=64, base=~BL+E+F+G)
print(typical)


###################################################
### code chunk number 43: randomtricky
###################################################
set.seed(123)
bprs.key <- planor.designkey(factors=list(LIG=c("L1","L2","L3"), 
                               MINILIG=1:2, 
                               COL=c("C1","C2"), 
                               MICROCOL=1:2), 
                             model=~LIG*COL*MINILIG*COL*MICROCOL, 
                             estimate=~1, 
                             nunits=24, 
                             base=~LIG+MINILIG+COL+MICROCOL)

unrand <- planor.design(bprs.key)@design
unrand <- unrand[order(unrand$LIG,unrand$MINILIG,
                       unrand$COL,unrand$MICROCOL),]
unrand$U <- letters[1:24]
cat("\n The unrandomized design\n")
print(t(matrix(unrand$U,4,6)))

rand <- planor.randomize(
          blockformula=~LIG+COL+LIG:MINILIG+COL:LIG:MICROCOL, 
          data=unrand)
rand <- rand[order(rand$LIG,rand$MINILIG,rand$COL,rand$MICROCOL),]
cat("\n The randomized design\n")
print(t(matrix(rand$U,4,6)))


