### R code from vignette source 'planorVignette.Rnw'

###################################################
### code chunk number 1: full1
###################################################
library("planor")
ABCfull <- regular.design(factors=list(A=1:2,B=1:2,C=1:3), 
                          model=~A*B*C, 
                          nunits=2*2*3, 
                          randomize=~UNITS)
print(ABCfull)


###################################################
### code chunk number 2: full2
###################################################
set.seed(123)
dataABCfull= as.data.frame(ABCfull)
dataABCfull$Y <- runif(2*2*3)
ABCfull.aov <- aov(Y~A*B*C, data=dataABCfull)
summary(ABCfull.aov)


###################################################
### code chunk number 3: cbd1
###################################################
CBD <- regular.design(factors=list(
               Block=1:4, Treatment=c("T1","T2","T3","T4", "T5")), 
                      model=~Block+Treatment, 
                      nunits=4*5, 
                      randomize=~Block/UNITS)
print(CBD)


###################################################
### code chunk number 4: cbd2
###################################################
dataCBD= as.data.frame(CBD)
dataCBD$Y <- runif(20)
CBD.aov <- aov(Y~Block+Treatment, data=dataCBD)
summary(CBD.aov)


###################################################
### code chunk number 5: LS1
###################################################
LS <- regular.design(factors=list(
  Judge=c("J1","J2","J3","J4"), Period=1:4, Product=c("P1","P2","P3","P4")), 
                       model= ~Judge + Period + Product, 
                       nunits=4*4, 
                       randomize=~Judge+Period)
print(LS)


###################################################
### code chunk number 6: LS2
###################################################
dataLS=as.data.frame(LS)
dataLS$Y <- runif(16)
LS.aov <- aov(Y~Judge + Period + Product, data=dataLS)
summary(LS.aov)


###################################################
### code chunk number 7: FFD
###################################################
FFD <- regular.design(factors=LETTERS[1:10], nlevels=4, 
                      resolution=5, 
                      nunits=2^10)
print(dim(FFD))
print(FFD[1:5,])


###################################################
### code chunk number 8: ex1
###################################################
ex1Key <- planor.designkey(factors=c("block","A","B","C","D"),nlevels=rep(2,5), 
                           model=~block+(A+B+C+D)^2, 
                           nunits=2^3)


###################################################
### code chunk number 9: ex1a
###################################################
ex1Key <- planor.designkey(factors=c("block","A","B","C","D"),nlevels=rep(2,5), 
                           model=~block+(A+B+C+D)^2, 
                           estimate=~A+B+C+D, 
                           nunits=2^3)


###################################################
### code chunk number 10: ex1a.bis
###################################################
ex1Fac <- planor.factors(factors=c("block","A","B","C","D"), nlevels=rep(2,5),
                         block=~block)
ex1Mod <- planor.model( model=~block+(A+B+C+D)^2, estimate=~A+B+C+D )
ex1Key <- planor.designkey(factors=ex1Fac, model=ex1Mod, nunits=2^3)


###################################################
### code chunk number 11: ex1b
###################################################
summary(ex1Key, show="dtb")
alias(ex1Key)


###################################################
### code chunk number 12: ex1c
###################################################
ex1Des <- planor.design(ex1Key)
print(getDesign(ex1Des))
ex1Rand <- planor.design(ex1Key, randomize=~block/UNITS)
print(getDesign(ex1Rand))


###################################################
### code chunk number 13: ex2
###################################################
# ***************** EXAMPLE 2 *****************
# Four 3-level treatment factors and one 3-level block factor
# Model: block+(A+B+C+D)^2  -   Estimate: A+B+C+D
# N = 3^3 = 27 units
#
ex2Key <- planor.designkey(factors=c(LETTERS[1:4],"block"),
                           nlevels=rep(3,5),  
                           block=~block,
                           model=~block+(A+B+C+D)^2,
                           estimate=~A+B+C+D,
                           nunits=3^3, base=~A+B+C, max.sol=2)
summary(ex2Key)
summary(ex2Key)
ex2Des <- planor.design(ex2Key[2])


###################################################
### code chunk number 14: ex2
###################################################
ex2Fac <- planor.factors(factors=c(LETTERS[1:4], "block", "BASE"),
                         nlevels=rep(3,6) )
ex2Mod <- planor.model(model=~block+(A+B+C+D)^2, 
                       estimate=~A+B+C+D )
ex2Key <- planor.designkey(factors=ex2Fac, 
                           model=ex2Mod, 
                           nunits=3^3,
                           base=~A+B+BASE, 
                           max.sol=2)


###################################################
### code chunk number 15: mix
###################################################
# Four treatment factors at 6, 6, 4, 2 levels and one 6-level block factor
# Model: block+(A+B+C+D)^2 ; Estimate: A+B+C+D\n")
# N = 144 = 2^4 x 3^2 experimental units
mixKey <- planor.designkey(factors=c( LETTERS[1:4], "block"), 
                           nlevels=c(6,6,4,2,6), 
                           block=~block,
                           model=~block+(A+B+C+D)^2, 
                           estimate=~A+B+C+D, 
                           nunits=144,
                       base=~A+B+D, max.sol=2)
summary(mixKey)
mixPlan <- planor.design(key=mixKey, select=c(1,1), randomize=~block/UNITS)
print(getDesign(mixPlan)[1:25,])


###################################################
### code chunk number 16: splitplota
###################################################
splitKey <- planor.designkey(factors=list(block=1:2,
                               subblock=1:2,
                               variety=LETTERS[1:2],
                               fert=c("organic","mineral")), 
                             block=~block+subblock,
                             hierarchy=list(~variety/(block*subblock)), 
                             listofmodels=
                             list(c( ~block*subblock+variety*fert, ~fert+fert:variety),
                                  c( ~block+variety,               ~variety)), 
                             nunits=2*2*2, 
                             base=~block+subblock)
summary(splitKey)
alias(splitKey)
print(getDesign(planor.design(splitKey, randomize=~block/subblock/UNITS)))


###################################################
### code chunk number 17: splitplotb
###################################################
splitKey <- planor.designkey(factors=list(block=1:2,
                               subblock=1:4,
                               variety=LETTERS[1:2],
                               fert=c("organic","mineral")), 
                             block=~block+subblock,
                             hierarchy=list( ~block/subblock, ~variety/subblock), 
                             listofmodels=
                             list(c( ~subblock+variety*fert, ~fert+fert:variety),
                                  c( ~block+variety,               ~variety)), 
                             nunits=2*2*2, 
                             base=~subblock)
print(getDesign(planor.design(splitKey, randomize=~block/subblock/UNITS)))


###################################################
### code chunk number 18: ex3a
###################################################
# ************ ROBOT1A EXAMPLE *************
# Block structure: 4 plates / (2 rows x 4 columns)
# Treatments: 4 2-level factors
# Hierarchy 1: conc constant in plate
# Hierarchy 2: Tact constant in plate
# Hierarchy 3: nsoil constant in plate x column
# Hierarchy 4: qsoil constant in plate x column
# N = 32 units
#
robotFac <- planor.factors( factors=list(
                            conc=c(1,3),
                            Tact=c(15,30),
                            nsoil=c("curd","Saint-Paulin"),
                            qsoil=c("0.01g","0.10g"),
                            Rug=c(0.25,0.73),
                            plate=1:4,
                            row=1:2,
                            col=1:4),
                           hierarchy=list(~conc/plate,
                           ~Tact/plate,
                           ~nsoil/(plate*col),
                           ~qsoil/(plate*col)))


###################################################
### code chunk number 19: ex3b
###################################################
robotMod <- planor.model( model=~nsoil*qsoil*Rug*conc*Tact,
                          listofmodels=list(c(~plate+row+col+Rug, ~Rug)) )


###################################################
### code chunk number 20: ex3c
###################################################
robotKey <- planor.designkey(factors=robotFac, model=robotMod,
                             nunits=32, base=~plate+row+col)
summary(robotKey[1])
robotDes <- planor.design(robotKey[1], randomize=~plate/(row*col))
print(getDesign(robotDes))


