/*
 * Decompiled with CFR 0.152.
 */
package org.fife.ui.rsyntaxtextarea;

import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.Timer;
import javax.swing.ToolTipManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Element;
import javax.swing.text.Position;
import org.fife.ui.rsyntaxtextarea.RSyntaxDocument;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextAreaHighlighter;
import org.fife.ui.rsyntaxtextarea.SquiggleUnderlineHighlightPainter;
import org.fife.ui.rsyntaxtextarea.parser.ParseResult;
import org.fife.ui.rsyntaxtextarea.parser.Parser;
import org.fife.ui.rsyntaxtextarea.parser.ParserNotice;
import org.fife.ui.rsyntaxtextarea.parser.ToolTipInfo;

class ParserManager
implements DocumentListener,
ActionListener,
HyperlinkListener {
    private RSyntaxTextArea textArea;
    private List parsers;
    private Timer timer;
    private boolean running;
    private Map noticesToHighlights;
    private Parser parserForTip;
    private Position firstOffsetModded;
    private Position lastOffsetModded;
    private SquiggleUnderlineHighlightPainter parserErrorHighlightPainter = new SquiggleUnderlineHighlightPainter(Color.RED);
    private static final boolean DEBUG_PARSING = false;
    private static final int DEFAULT_DELAY_MS = 1250;

    public ParserManager(RSyntaxTextArea rSyntaxTextArea) {
        this(1250, rSyntaxTextArea);
    }

    public ParserManager(int n, RSyntaxTextArea rSyntaxTextArea) {
        this.textArea = rSyntaxTextArea;
        rSyntaxTextArea.getDocument().addDocumentListener(this);
        this.parsers = new ArrayList(1);
        this.timer = new Timer(n, this);
        this.timer.setRepeats(false);
        this.running = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void actionPerformed(ActionEvent actionEvent) {
        int n = this.getParserCount();
        if (n == 0) {
            return;
        }
        long l = 0L;
        RSyntaxDocument rSyntaxDocument = (RSyntaxDocument)this.textArea.getDocument();
        Element element = rSyntaxDocument.getDefaultRootElement();
        int n2 = this.firstOffsetModded == null ? 0 : element.getElementIndex(this.firstOffsetModded.getOffset());
        int n3 = this.lastOffsetModded == null ? element.getElementCount() - 1 : element.getElementIndex(this.lastOffsetModded.getOffset());
        this.lastOffsetModded = null;
        this.firstOffsetModded = null;
        String string = this.textArea.getSyntaxEditingStyle();
        rSyntaxDocument.readLock();
        try {
            for (int i = 0; i < n; ++i) {
                Parser parser = this.getParser(i);
                ParseResult parseResult = parser.parse(rSyntaxDocument, string);
                this.addParserNoticeHighlights(parseResult);
            }
            this.textArea.fireParserNoticesChange();
        }
        finally {
            rSyntaxDocument.readUnlock();
        }
    }

    public void addParser(Parser parser) {
        if (parser != null && !this.parsers.contains(parser)) {
            if (this.running) {
                this.timer.stop();
            }
            this.parsers.add(parser);
            if (this.parsers.size() == 1) {
                ToolTipManager.sharedInstance().registerComponent(this.textArea);
            }
            if (this.running) {
                this.timer.restart();
            }
        }
    }

    private void addParserNoticeHighlights(ParseResult parseResult) {
        if (this.noticesToHighlights == null) {
            this.noticesToHighlights = new HashMap();
        }
        this.removeParserNotices(parseResult);
        List list = parseResult.getNotices();
        if (list.size() > 0) {
            RSyntaxTextAreaHighlighter rSyntaxTextAreaHighlighter = (RSyntaxTextAreaHighlighter)this.textArea.getHighlighter();
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                ParserNotice parserNotice = (ParserNotice)iterator.next();
                try {
                    Object object = null;
                    if (parserNotice.getShowInEditor()) {
                        object = rSyntaxTextAreaHighlighter.addParserHighlight(parserNotice, this.parserErrorHighlightPainter);
                    }
                    this.noticesToHighlights.put(parserNotice, object);
                }
                catch (BadLocationException badLocationException) {
                    badLocationException.printStackTrace();
                }
            }
        }
    }

    public void changedUpdate(DocumentEvent documentEvent) {
    }

    private void clearParserNoticeHighlights() {
        RSyntaxTextAreaHighlighter rSyntaxTextAreaHighlighter = (RSyntaxTextAreaHighlighter)this.textArea.getHighlighter();
        if (rSyntaxTextAreaHighlighter != null) {
            rSyntaxTextAreaHighlighter.clearParserHighlights();
        }
        if (this.noticesToHighlights != null) {
            this.noticesToHighlights.clear();
        }
    }

    public void clearParsers() {
        this.timer.stop();
        this.clearParserNoticeHighlights();
        this.parsers.clear();
        this.textArea.fireParserNoticesChange();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void forceReparsing(int n) {
        Parser parser = this.getParser(n);
        RSyntaxDocument rSyntaxDocument = (RSyntaxDocument)this.textArea.getDocument();
        String string = this.textArea.getSyntaxEditingStyle();
        rSyntaxDocument.readLock();
        try {
            ParseResult parseResult = parser.parse(rSyntaxDocument, string);
            this.addParserNoticeHighlights(parseResult);
            this.textArea.fireParserNoticesChange();
        }
        finally {
            rSyntaxDocument.readUnlock();
        }
    }

    public int getDelay() {
        return this.timer.getDelay();
    }

    public Parser getParser(int n) {
        return (Parser)this.parsers.get(n);
    }

    public int getParserCount() {
        return this.parsers.size();
    }

    public List getParserNotices() {
        ArrayList<ParserNotice> arrayList = new ArrayList<ParserNotice>();
        if (this.noticesToHighlights != null) {
            Iterator iterator = this.noticesToHighlights.keySet().iterator();
            while (iterator.hasNext()) {
                ParserNotice parserNotice = (ParserNotice)iterator.next();
                arrayList.add(parserNotice);
            }
        }
        return arrayList;
    }

    public ToolTipInfo getToolTipText(MouseEvent mouseEvent) {
        Iterator iterator;
        String string = null;
        HyperlinkListener hyperlinkListener = null;
        this.parserForTip = null;
        int n = this.textArea.viewToModel(mouseEvent.getPoint());
        if (this.noticesToHighlights != null) {
            iterator = this.noticesToHighlights.keySet().iterator();
            while (iterator.hasNext()) {
                ParserNotice parserNotice = (ParserNotice)iterator.next();
                if (!parserNotice.containsPosition(n)) continue;
                string = parserNotice.getToolTipText();
                this.parserForTip = parserNotice.getParser();
                if (!(parserNotice.getParser() instanceof HyperlinkListener)) break;
                hyperlinkListener = (HyperlinkListener)((Object)parserNotice.getParser());
                break;
            }
        }
        iterator = this.parserForTip == null ? null : this.parserForTip.getImageBase();
        return new ToolTipInfo(string, hyperlinkListener, (URL)((Object)iterator));
    }

    public void handleDocumentEvent(DocumentEvent documentEvent) {
        if (this.running && this.parsers.size() > 0) {
            this.timer.restart();
        }
    }

    public void hyperlinkUpdate(HyperlinkEvent hyperlinkEvent) {
        if (this.parserForTip != null && this.parserForTip.getHyperlinkListener() != null) {
            this.parserForTip.getHyperlinkListener().linkClicked(this.textArea, hyperlinkEvent);
        }
    }

    public void insertUpdate(DocumentEvent documentEvent) {
        try {
            int n = documentEvent.getOffset();
            if (this.firstOffsetModded == null || n < this.firstOffsetModded.getOffset()) {
                this.firstOffsetModded = documentEvent.getDocument().createPosition(n);
            }
            n = documentEvent.getOffset() + documentEvent.getLength();
            if (this.lastOffsetModded == null || n > this.lastOffsetModded.getOffset()) {
                this.lastOffsetModded = documentEvent.getDocument().createPosition(n);
            }
        }
        catch (BadLocationException badLocationException) {
            badLocationException.printStackTrace();
        }
        this.handleDocumentEvent(documentEvent);
    }

    public boolean removeParser(Parser parser) {
        this.removeParserNotices(parser);
        boolean bl = this.parsers.remove(parser);
        if (bl) {
            this.textArea.fireParserNoticesChange();
        }
        return bl;
    }

    private void removeParserNotices(Parser parser) {
        if (this.noticesToHighlights != null) {
            RSyntaxTextAreaHighlighter rSyntaxTextAreaHighlighter = (RSyntaxTextAreaHighlighter)this.textArea.getHighlighter();
            Iterator iterator = this.noticesToHighlights.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                ParserNotice parserNotice = (ParserNotice)entry.getKey();
                if (parserNotice.getParser() != parser || entry.getValue() == null) continue;
                rSyntaxTextAreaHighlighter.removeParserHighlight(entry.getValue());
                iterator.remove();
            }
        }
    }

    private void removeParserNotices(ParseResult parseResult) {
        if (this.noticesToHighlights != null) {
            RSyntaxTextAreaHighlighter rSyntaxTextAreaHighlighter = (RSyntaxTextAreaHighlighter)this.textArea.getHighlighter();
            Iterator iterator = this.noticesToHighlights.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                ParserNotice parserNotice = (ParserNotice)entry.getKey();
                if (!this.shouldRemoveNotice(parserNotice, parseResult)) continue;
                if (entry.getValue() != null) {
                    rSyntaxTextAreaHighlighter.removeParserHighlight(entry.getValue());
                }
                iterator.remove();
            }
        }
    }

    public void removeUpdate(DocumentEvent documentEvent) {
        try {
            int n = documentEvent.getOffset();
            if (this.firstOffsetModded == null || n < this.firstOffsetModded.getOffset()) {
                this.firstOffsetModded = documentEvent.getDocument().createPosition(n);
            }
            if (this.lastOffsetModded == null || n > this.lastOffsetModded.getOffset()) {
                this.lastOffsetModded = documentEvent.getDocument().createPosition(n);
            }
        }
        catch (BadLocationException badLocationException) {
            badLocationException.printStackTrace();
        }
        this.handleDocumentEvent(documentEvent);
    }

    public void restartParsing() {
        this.timer.restart();
        this.running = true;
    }

    public void setDelay(int n) {
        if (this.running) {
            this.timer.stop();
        }
        this.timer.setDelay(n);
        if (this.running) {
            this.timer.start();
        }
    }

    private final boolean shouldRemoveNotice(ParserNotice parserNotice, ParseResult parseResult) {
        return parserNotice.getParser() == parseResult.getParser() && parserNotice.getLine() >= parseResult.getFirstLineParsed() && parserNotice.getLine() <= parseResult.getLastLineParsed();
    }

    public void stopParsing() {
        this.timer.stop();
        this.running = false;
    }
}

