/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.common.intern;

import bibliothek.gui.dock.DefaultDockable;
import bibliothek.gui.dock.action.DockActionSource;
import bibliothek.gui.dock.action.LocationHint;
import bibliothek.gui.dock.common.CStation;
import bibliothek.gui.dock.common.event.CDockableAdapter;
import bibliothek.gui.dock.common.intern.CDockable;
import bibliothek.gui.dock.common.intern.CommonDockable;
import bibliothek.gui.dock.common.intern.action.CActionSource;
import bibliothek.gui.dock.common.intern.station.CommonDockStation;
import bibliothek.gui.dock.title.DockTitleRequest;
import bibliothek.gui.dock.title.DockTitleVersion;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultCommonDockable
extends DefaultDockable
implements CommonDockable {
    private CDockable dockable;
    private CActionSource actions;
    private DockActionSource[] sources;

    public DefaultCommonDockable(CDockable dockable, DockActionSource ... sources) {
        this.dockable = dockable;
        this.sources = sources;
        this.actions = new CActionSource(new LocationHint(LocationHint.DOCKABLE, LocationHint.LEFT));
        this.setActionOffers((DockActionSource)this.actions);
        dockable.addCDockablePropertyListener(new CDockableAdapter(){

            public void titleShownChanged(CDockable dockable) {
                DefaultCommonDockable.this.fireTitleExchanged();
            }
        });
        this.setFactoryID("ccontrol backup factory id");
    }

    public CActionSource getActions() {
        return this.actions;
    }

    @Override
    public CDockable getDockable() {
        return this.dockable;
    }

    @Override
    public CommonDockable asDockable() {
        return this;
    }

    @Override
    public CommonDockStation<?, ?> asDockStation() {
        return null;
    }

    @Override
    public CStation<?> getStation() {
        return null;
    }

    @Override
    public DockActionSource[] getSources() {
        return this.sources;
    }

    public void requestDockTitle(DockTitleRequest request) {
        if (this.dockable.isTitleShown()) {
            super.requestDockTitle(request);
        } else {
            boolean hide;
            DockTitleVersion version = request.getVersion();
            boolean bl = hide = version.getID().equals("split") || version.getID().equals("stack") || version.getID().equals("screen dock") || version.getID().equals("flap window");
            if (hide) {
                request.answer(null);
            } else {
                super.requestDockTitle(request);
            }
        }
    }
}

