/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.common.intern;

import bibliothek.gui.Dockable;
import bibliothek.gui.dock.DockElement;
import bibliothek.gui.dock.common.intern.station.CommonDockStation;
import bibliothek.gui.dock.common.perspective.CStationPerspective;
import bibliothek.gui.dock.common.perspective.CommonElementPerspective;
import bibliothek.gui.dock.layout.AdjacentDockFactory;
import bibliothek.gui.dock.perspective.PerspectiveDockable;
import bibliothek.gui.dock.perspective.PerspectiveElement;
import bibliothek.gui.dock.station.support.PlaceholderStrategy;
import bibliothek.util.Path;
import bibliothek.util.xml.XElement;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RootStationAdjacentFactory
implements AdjacentDockFactory<Path> {
    public static final String FACTORY_ID = "dock.RootStationAdjacentFactory";

    public boolean interested(DockElement element) {
        return element instanceof CommonDockStation;
    }

    public boolean interested(PerspectiveElement element) {
        if (element instanceof CommonElementPerspective) {
            CStationPerspective station = ((CommonElementPerspective)element).getElement().asStation();
            return station != null;
        }
        return false;
    }

    public String getID() {
        return FACTORY_ID;
    }

    public Path getLayout(DockElement element, Map<Dockable, Integer> children) {
        return ((CommonDockStation)element).getStation().getTypeId();
    }

    public Path getPerspectiveLayout(PerspectiveElement element, Map<PerspectiveDockable, Integer> children) {
        CStationPerspective station = ((CommonElementPerspective)element).getElement().asStation();
        return station.getTypeId();
    }

    public Path read(DataInputStream in, PlaceholderStrategy placeholders) throws IOException {
        byte version = in.readByte();
        if (version != 0) {
            throw new IOException("unknown version: " + version);
        }
        if (in.readBoolean()) {
            return new Path(in.readUTF());
        }
        return null;
    }

    public Path read(XElement element, PlaceholderStrategy placeholders) {
        XElement xtype = element.getElement("type");
        if (xtype == null) {
            return null;
        }
        return new Path(xtype.getString());
    }

    public void setLayout(DockElement element, Path layout, Map<Integer, Dockable> children, PlaceholderStrategy placeholders) {
    }

    public void setLayout(DockElement element, Path layout, PlaceholderStrategy placeholders) {
    }

    public void write(Path layout, DataOutputStream out) throws IOException {
        out.writeByte(0);
        if (layout == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            out.writeUTF(layout.toString());
        }
    }

    public void write(Path layout, XElement element) {
        if (layout != null) {
            element.addElement("type").setString(layout.toString());
        }
    }
}

