/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.common.intern.font;

import bibliothek.gui.dock.common.FontMap;
import bibliothek.gui.dock.common.event.FontMapListener;
import bibliothek.gui.dock.common.intern.CDockable;
import bibliothek.gui.dock.common.intern.ui.UITransmitter;
import bibliothek.gui.dock.util.font.DockFont;
import bibliothek.gui.dock.util.font.FontBridge;
import bibliothek.gui.dock.util.font.FontManager;
import bibliothek.gui.dock.util.font.FontModifier;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class FontTransmitter
extends UITransmitter<FontModifier, DockFont>
implements FontBridge {
    private Listener listener = new Listener();
    private FontManager manager;
    private String[] keys;

    public FontTransmitter(FontManager manager, String ... keys) {
        super(keys);
        this.manager = manager;
        this.keys = keys;
    }

    protected FontModifier getFirstNonNull(FontMap map, String ... keys) {
        for (String key : keys) {
            FontModifier font = map.getFont(key);
            if (font == null) continue;
            return font;
        }
        return null;
    }

    @Override
    protected void connect(CDockable dockable) {
        dockable.getFonts().addListener(this.listener);
    }

    @Override
    protected void disconnect(CDockable dockable) {
        dockable.getFonts().removeListener(this.listener);
    }

    @Override
    protected void update(CDockable dockable, String key, FontModifier value) {
        if (this.isObservedMapKey(key)) {
            for (String check : this.keys) {
                this.set(check, this.get((FontModifier)this.manager.get(check), check, dockable), dockable);
            }
        }
    }

    protected abstract boolean isObservedMapKey(String var1);

    @Override
    protected abstract FontModifier get(FontModifier var1, String var2, CDockable var3);

    private class Listener
    implements FontMapListener {
        private Listener() {
        }

        public void fontChanged(FontMap map, String key, FontModifier font) {
            FontTransmitter.this.update(map.getDockable(), key, font);
        }
    }
}

