/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.common.perspective.mode;

import bibliothek.gui.dock.common.mode.ExtendedMode;
import bibliothek.gui.dock.common.perspective.mode.AbstractModePerspective;
import bibliothek.gui.dock.common.perspective.mode.CMaximizedModeAreaPerspective;
import bibliothek.gui.dock.facile.mode.Location;
import bibliothek.gui.dock.facile.mode.MaximizedModeSetting;
import bibliothek.gui.dock.support.mode.ModeSetting;
import bibliothek.util.Path;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CMaximizedModePerspective
extends AbstractModePerspective<CMaximizedModeAreaPerspective> {
    private Map<String, Path> lastMaximizedMode = new HashMap<String, Path>();
    private Map<String, Location> lastMaximizedLocation = new HashMap<String, Location>();

    @Override
    public ExtendedMode getIdentifier() {
        return ExtendedMode.MAXIMIZED;
    }

    @Override
    public void add(CMaximizedModeAreaPerspective location) {
        super.add(location);
        this.forward(location);
    }

    private void forward(CMaximizedModeAreaPerspective area) {
        Path mode = this.lastMaximizedMode.remove(area.getUniqueId());
        Location location = this.lastMaximizedLocation.remove(area.getUniqueId());
        area.setUnmaximize(mode, location);
    }

    @Override
    public void readSetting(ModeSetting<Location> setting) {
        if (setting instanceof MaximizedModeSetting) {
            this.lastMaximizedLocation.clear();
            this.lastMaximizedMode.clear();
            this.lastMaximizedLocation.putAll(((MaximizedModeSetting)setting).getLastMaximizedLocation());
            this.lastMaximizedMode.putAll(((MaximizedModeSetting)setting).getLastMaximizedMode());
            int n = this.getAreaCount();
            for (int i = 0; i < n; ++i) {
                this.forward((CMaximizedModeAreaPerspective)this.getArea(i));
            }
        }
    }

    @Override
    public void writeSetting(ModeSetting<Location> setting) {
        if (setting instanceof MaximizedModeSetting) {
            MaximizedModeSetting modeSetting = (MaximizedModeSetting)setting;
            int n = this.getAreaCount();
            for (int i = 0; i < n; ++i) {
                CMaximizedModeAreaPerspective area = (CMaximizedModeAreaPerspective)this.getArea(i);
                Path mode = area.getUnmaximizeMode();
                if (mode == null) continue;
                modeSetting.getLastMaximizedMode().put(area.getUniqueId(), mode);
                Location location = area.getUnmaximizeLocation();
                if (location == null) continue;
                modeSetting.getLastMaximizedLocation().put(area.getUniqueId(), location);
            }
        }
    }
}

