/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.extension.gui.dock.theme.eclipse.rex;

import bibliothek.gui.DockUI;
import java.awt.Color;
import java.awt.SystemColor;

public class RexSystemColor {
    private RexSystemColor() {
    }

    public static Color getActiveColor() {
        return RexSystemColor.decide("dock.title.selection.background.[brighter]", SystemColor.activeCaption.brighter());
    }

    public static Color getActiveColorGradient() {
        return RexSystemColor.decide("dock.title.selection.background", SystemColor.activeCaption);
    }

    public static Color getInactiveColor() {
        return RexSystemColor.decide("dock.title.background.[darker]", SystemColor.inactiveCaption.darker());
    }

    public static Color getInactiveColorGradient() {
        return RexSystemColor.decide("dock.background", SystemColor.inactiveCaption);
    }

    public static Color getActiveTextColor() {
        return RexSystemColor.decide("dock.title.selection.foreground", SystemColor.activeCaptionText);
    }

    public static Color getInactiveTextColor() {
        return RexSystemColor.decide("dock.title.foreground", SystemColor.inactiveCaptionText);
    }

    public static Color getBorderColor() {
        return RexSystemColor.decide("dock.window.border.[darker]", SystemColor.windowBorder.darker());
    }

    private static Color decide(String lookAndFeelKey, Color defaultColor) {
        Color result;
        boolean brighter = lookAndFeelKey.endsWith("[brighter]");
        boolean darker = lookAndFeelKey.endsWith("[darker]");
        if (brighter || darker) {
            lookAndFeelKey = lookAndFeelKey.substring(0, lookAndFeelKey.lastIndexOf(46));
        }
        if ((result = DockUI.getDefaultDockUI().getColors().getColor(lookAndFeelKey)) == null) {
            return defaultColor;
        }
        if (brighter) {
            result = result.brighter();
        }
        if (darker) {
            result = result.darker();
        }
        return result;
    }
}

