/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.dockable;

import bibliothek.gui.Dockable;

public class DockableStateEvent {
    public static final int FLAG_LOCATION_CHANGED = 1;
    public static final int FLAG_PARENT_LOCATION_CHANGED = 2;
    public static final int FLAG_VISIBILITY = 4;
    public static final int FLAG_SELECTION = 8;
    public static final int FLAG_PARENT_SELECTION = 16;
    public static final int FLAG_HIERARCHY = 32;
    private Dockable dockable;
    private int flags;

    public DockableStateEvent(Dockable dockable, int flags) {
        this.dockable = dockable;
        this.flags = flags;
    }

    public Dockable getDockable() {
        return this.dockable;
    }

    public int getFlags() {
        return this.flags;
    }

    public boolean didSelectionChange() {
        return (this.flags & 8) == 8;
    }

    public boolean didParentSelectionChange() {
        return (this.flags & 0x10) == 16;
    }

    public boolean didLocationChange() {
        return (this.flags & 1) == 1;
    }

    public boolean didParentLocationChange() {
        return (this.flags & 2) == 2;
    }

    public boolean didVisibilityChange() {
        return (this.flags & 4) == 4;
    }

    public boolean didHierarchyChange() {
        return (this.flags & 0x20) == 32;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder(this.getClass().getSimpleName());
        builder.append("[");
        boolean comma = false;
        if (this.didHierarchyChange()) {
            builder.append("HIERARCHY");
            comma = true;
        }
        if (this.didParentLocationChange()) {
            if (comma) {
                builder.append(", ");
            }
            builder.append("PARENT LOCATION");
        }
        if (this.didLocationChange()) {
            if (comma) {
                builder.append(", ");
            }
            builder.append("LOCATION");
        }
        if (this.didSelectionChange()) {
            if (comma) {
                builder.append(", ");
            }
            builder.append("SELECTION");
        }
        if (this.didVisibilityChange()) {
            if (comma) {
                builder.append(", ");
            }
            builder.append("VISIBILITY");
        }
        builder.append("]");
        return builder.toString();
    }
}

