/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.frontend;

import bibliothek.gui.dock.layout.DockLayoutComposition;
import bibliothek.gui.dock.layout.DockSituation;
import bibliothek.gui.dock.layout.DockableProperty;
import bibliothek.gui.dock.layout.PropertyTransformer;
import bibliothek.util.Version;
import bibliothek.util.xml.XAttribute;
import bibliothek.util.xml.XElement;
import bibliothek.util.xml.XException;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class Setting {
    private Map<String, DockLayoutComposition> roots = new HashMap<String, DockLayoutComposition>();
    private List<Invisible> dockables = new ArrayList<Invisible>();

    public void putRoot(String root, DockLayoutComposition layout) {
        this.roots.put(root, layout);
    }

    public DockLayoutComposition getRoot(String root) {
        return this.roots.get(root);
    }

    public String[] getRootKeys() {
        Set<String> keys = this.roots.keySet();
        return keys.toArray(new String[keys.size()]);
    }

    public void addInvisible(String key, String root, DockLayoutComposition layout, DockableProperty location) {
        Invisible invisible = new Invisible();
        invisible.key = key;
        invisible.root = root;
        invisible.location = location;
        invisible.layout = layout;
        this.dockables.add(invisible);
    }

    public int getInvisibleCount() {
        return this.dockables.size();
    }

    public String getInvisibleKey(int index) {
        return this.dockables.get((int)index).key;
    }

    public String getInvisibleRoot(int index) {
        return this.dockables.get((int)index).root;
    }

    public DockableProperty getInvisibleLocation(int index) {
        return this.dockables.get((int)index).location;
    }

    public DockLayoutComposition getInvisibleLayout(int index) {
        return this.dockables.get((int)index).layout;
    }

    public void fillMissing(DockSituation situation) {
        try {
            for (Map.Entry<String, DockLayoutComposition> entry : this.roots.entrySet()) {
                entry.setValue(situation.fillMissing(entry.getValue()));
            }
        }
        catch (IOException ex) {
            throw new IllegalArgumentException(ex);
        }
        catch (XException ex) {
            throw new IllegalArgumentException(ex);
        }
    }

    public void write(DockSituation situation, PropertyTransformer transformer, boolean entry, DataOutputStream out) throws IOException {
        Version.write(out, Version.VERSION_1_0_7);
        String[] roots = this.getRootKeys();
        out.writeInt(roots.length);
        for (String root : roots) {
            out.writeUTF(root);
            situation.writeComposition(this.getRoot(root), out);
        }
        out.writeInt(this.getInvisibleCount());
        int n = this.getInvisibleCount();
        for (int i = 0; i < n; ++i) {
            out.writeUTF(this.getInvisibleKey(i));
            String root = this.getInvisibleRoot(i);
            if (root == null) {
                out.writeBoolean(false);
            } else {
                out.writeBoolean(true);
                out.writeUTF(root);
            }
            DockableProperty location = this.getInvisibleLocation(i);
            if (location == null) {
                out.writeBoolean(false);
            } else {
                out.writeBoolean(true);
                transformer.write(this.getInvisibleLocation(i), out);
            }
            DockLayoutComposition layout = this.getInvisibleLayout(i);
            if (layout == null) {
                out.writeBoolean(false);
                continue;
            }
            out.writeBoolean(true);
            situation.writeComposition(layout, out);
        }
    }

    public void writeXML(DockSituation situation, PropertyTransformer transformer, boolean entry, XElement element) {
        String[] roots;
        XElement xroots = element.addElement("roots");
        for (String root : roots = this.getRootKeys()) {
            XElement xroot = xroots.addElement("root");
            xroot.addString("name", root);
            situation.writeCompositionXML(this.getRoot(root), xroot);
        }
        XElement xchildren = element.addElement("children");
        int n = this.getInvisibleCount();
        for (int i = 0; i < n; ++i) {
            DockableProperty location;
            XElement xchild = xchildren.addElement("child");
            xchild.addString("key", this.getInvisibleKey(i));
            String root = this.getInvisibleRoot(i);
            if (root != null) {
                xchild.addString("root", root);
            }
            if ((location = this.getInvisibleLocation(i)) == null) {
                xchild.addBoolean("location", false);
            } else {
                xchild.addBoolean("location", true);
                transformer.writeXML(this.getInvisibleLocation(i), xchild.addElement("location"));
            }
            DockLayoutComposition layout = this.getInvisibleLayout(i);
            if (layout == null) continue;
            situation.writeCompositionXML(layout, xchild.addElement("layout"));
        }
    }

    public void read(DockSituation situation, PropertyTransformer transformer, boolean entry, DataInputStream in) throws IOException {
        int i;
        Version version = Version.read(in);
        version.checkCurrent();
        boolean version7 = Version.VERSION_1_0_7.compareTo(version) <= 0;
        this.roots.clear();
        this.dockables.clear();
        int count = in.readInt();
        for (i = 0; i < count; ++i) {
            String root = in.readUTF();
            DockLayoutComposition layout = situation.readComposition(in);
            if (layout == null) continue;
            this.putRoot(root, layout);
        }
        count = in.readInt();
        for (i = 0; i < count; ++i) {
            String key = in.readUTF();
            String root = null;
            if (version7) {
                if (in.readBoolean()) {
                    root = in.readUTF();
                }
            } else {
                root = in.readUTF();
            }
            DockableProperty location = null;
            if (version7) {
                if (in.readBoolean()) {
                    location = transformer.read(in);
                }
            } else {
                location = transformer.read(in);
            }
            DockLayoutComposition layout = null;
            if (version7 && in.readBoolean()) {
                layout = situation.readComposition(in);
            }
            this.addInvisible(key, root, layout, location);
        }
    }

    public void readXML(DockSituation situation, PropertyTransformer transformer, boolean entry, XElement element) {
        XElement xchildren;
        this.roots.clear();
        this.dockables.clear();
        XElement xroots = element.getElement("roots");
        if (xroots != null) {
            for (XElement xroot : xroots.getElements("root")) {
                String name = xroot.getString("name");
                DockLayoutComposition composition = situation.readCompositionXML(xroot);
                if (composition == null) continue;
                this.putRoot(name, composition);
            }
        }
        if ((xchildren = element.getElement("children")) != null) {
            for (XElement xchild : xchildren.getElements("child")) {
                String key = xchild.getString("key");
                String root = null;
                XAttribute aroot = xchild.getAttribute("root");
                if (aroot != null) {
                    root = aroot.getString();
                }
                boolean oldStyle = true;
                boolean hasLocation = false;
                XAttribute alocation = xchild.getAttribute("location");
                if (alocation != null) {
                    oldStyle = false;
                    hasLocation = alocation.getBoolean();
                }
                DockableProperty location = null;
                DockLayoutComposition layout = null;
                if (oldStyle) {
                    location = transformer.readXML(xchild);
                } else {
                    XElement xlayout;
                    if (hasLocation) {
                        XElement xlocation = xchild.getElement("location");
                        location = transformer.readXML(xlocation);
                    }
                    if ((xlayout = xchild.getElement("layout")) != null) {
                        layout = situation.readCompositionXML(xlayout);
                    }
                }
                this.addInvisible(key, root, layout, location);
            }
        }
    }

    private static class Invisible {
        public String key;
        public String root;
        public DockableProperty location;
        public DockLayoutComposition layout;

        private Invisible() {
        }
    }
}

