/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.station.flap.button;

import bibliothek.gui.Dockable;
import bibliothek.gui.dock.station.flap.button.AbstractButtonContentCondition;
import bibliothek.gui.dock.station.flap.button.ButtonContentCondition;
import bibliothek.gui.dock.station.flap.button.ButtonContentListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;

public class ButtonContent {
    public static final ButtonContentCondition TRUE = new ButtonContentCondition(){

        public boolean shouldShow(Dockable dockable, boolean themeSuggestion) {
            return true;
        }

        public void install(Dockable dockable, ButtonContent content) {
        }

        public void uninstall(Dockable dockable, ButtonContent content) {
        }
    };
    public static final ButtonContentCondition FALSE = new ButtonContentCondition(){

        public boolean shouldShow(Dockable dockable, boolean themeSuggestion) {
            return false;
        }

        public void install(Dockable dockable, ButtonContent content) {
        }

        public void uninstall(Dockable dockable, ButtonContent content) {
        }
    };
    public static final ButtonContentCondition THEME = new ButtonContentCondition(){

        public boolean shouldShow(Dockable dockable, boolean themeSuggestion) {
            return themeSuggestion;
        }

        public void install(Dockable dockable, ButtonContent content) {
        }

        public void uninstall(Dockable dockable, ButtonContent content) {
        }
    };
    public static final ButtonContentCondition NOT_IF_ICON = new AbstractButtonContentCondition(){

        public boolean shouldShow(Dockable dockable, boolean themeSuggestion) {
            return dockable.getTitleIcon() == null;
        }

        public void titleIconChanged(Dockable dockable, Icon oldIcon, Icon newIcon) {
            this.fire(dockable);
        }
    };
    public static final ButtonContentCondition NOT_IF_TEXT = new AbstractButtonContentCondition(){

        public boolean shouldShow(Dockable dockable, boolean themeSuggestion) {
            String title = dockable.getTitleText();
            return title == null || title.length() == 0;
        }

        public void titleTextChanged(Dockable dockable, String oldTitle, String newTitle) {
            this.fire(dockable);
        }
    };
    public static final ButtonContentCondition IF_STATION = new ButtonContentCondition(){

        public boolean shouldShow(Dockable dockable, boolean themeSuggestion) {
            return dockable.asDockStation() != null;
        }

        public void install(Dockable dockable, ButtonContent content) {
        }

        public void uninstall(Dockable dockable, ButtonContent content) {
        }
    };
    public static final ButtonContentCondition IF_DOCKABLE = new ButtonContentCondition(){

        public boolean shouldShow(Dockable dockable, boolean themeSuggestion) {
            return dockable.asDockStation() == null;
        }

        public void install(Dockable dockable, ButtonContent content) {
        }

        public void uninstall(Dockable dockable, ButtonContent content) {
        }
    };
    public static final ButtonContent THEME_DEPENDENT = new ButtonContent(THEME, THEME, THEME, THEME, THEME, THEME);
    public static final ButtonContent ICON_ONLY = new ButtonContent(FALSE, TRUE, FALSE, FALSE, FALSE, FALSE);
    public static final ButtonContent TEXT_ONLY = new ButtonContent(FALSE, FALSE, TRUE, FALSE, FALSE, FALSE);
    public static final ButtonContent ICON_AND_TEXT_ONLY = new ButtonContent(FALSE, TRUE, TRUE, FALSE, FALSE, FALSE);
    public static final ButtonContent ICON_THEN_TEXT_ONLY = new ButtonContent(FALSE, TRUE, NOT_IF_ICON, FALSE, FALSE, FALSE);
    public static final ButtonContent TEXT_THEN_ICON_ONLY = new ButtonContent(FALSE, NOT_IF_TEXT, TRUE, FALSE, FALSE, FALSE);
    public static final ButtonContent ICON_ACTIONS = new ButtonContent(FALSE, TRUE, FALSE, FALSE, TRUE, FALSE);
    public static final ButtonContent TEXT_ACTIONS = new ButtonContent(FALSE, FALSE, TRUE, FALSE, TRUE, FALSE);
    public static final ButtonContent ICON_AND_TEXT_ACTIONS = new ButtonContent(FALSE, TRUE, TRUE, FALSE, TRUE, FALSE);
    public static final ButtonContent ICON_THEN_TEXT_ACTIONS = new ButtonContent(FALSE, TRUE, NOT_IF_ICON, FALSE, TRUE, FALSE);
    public static final ButtonContent TEXT_THEN_ICON_ACTIONS = new ButtonContent(FALSE, NOT_IF_TEXT, TRUE, FALSE, TRUE, FALSE);
    private ButtonContentCondition knob;
    private ButtonContentCondition icon;
    private ButtonContentCondition text;
    private ButtonContentCondition actions;
    private ButtonContentCondition filterActions;
    private ButtonContentCondition children;
    private Map<Dockable, List<ButtonContentListener>> listeners = new HashMap<Dockable, List<ButtonContentListener>>();

    public ButtonContent(ButtonContentCondition knob, ButtonContentCondition icon, ButtonContentCondition text, ButtonContentCondition children, ButtonContentCondition actions, ButtonContentCondition filterActions) {
        this.knob = this.get(knob);
        this.icon = this.get(icon);
        this.text = this.get(text);
        this.children = this.get(children);
        this.actions = this.get(actions);
        this.filterActions = this.get(filterActions);
    }

    private ButtonContentCondition get(ButtonContentCondition condition) {
        if (condition == null) {
            return THEME;
        }
        return condition;
    }

    public void addListener(Dockable dockable, ButtonContentListener listener) {
        List<ButtonContentListener> list = this.listeners.get(dockable);
        if (list == null) {
            list = new ArrayList<ButtonContentListener>();
            this.listeners.put(dockable, list);
            this.install(dockable);
        }
        list.add(listener);
    }

    public void removeListener(Dockable dockable, ButtonContentListener listener) {
        List<ButtonContentListener> list = this.listeners.get(dockable);
        if (list != null) {
            list.remove(listener);
            if (list.isEmpty()) {
                this.uninstall(dockable);
                this.listeners.remove(dockable);
            }
        }
    }

    protected ButtonContentListener[] listeners(Dockable dockable) {
        List<ButtonContentListener> list = this.listeners.get(dockable);
        if (list != null) {
            return list.toArray(new ButtonContentListener[list.size()]);
        }
        return new ButtonContentListener[0];
    }

    public void handleChange(Dockable dockable) {
        for (ButtonContentListener listener : this.listeners(dockable)) {
            listener.changed(this, dockable);
        }
    }

    private void install(Dockable dockable) {
        this.knob.install(dockable, this);
        this.icon.install(dockable, this);
        this.text.install(dockable, this);
        this.children.install(dockable, this);
        this.actions.install(dockable, this);
        this.filterActions.install(dockable, this);
    }

    private void uninstall(Dockable dockable) {
        this.knob.uninstall(dockable, this);
        this.icon.uninstall(dockable, this);
        this.text.uninstall(dockable, this);
        this.children.uninstall(dockable, this);
        this.actions.uninstall(dockable, this);
        this.filterActions.uninstall(dockable, this);
    }

    public boolean showKnob(Dockable dockable, boolean theme) {
        return this.knob.shouldShow(dockable, theme);
    }

    public ButtonContentCondition getKnob() {
        return this.knob;
    }

    public boolean showActions(Dockable dockable, boolean theme) {
        return this.actions.shouldShow(dockable, theme);
    }

    public ButtonContentCondition getActions() {
        return this.actions;
    }

    public boolean filterActions(Dockable dockable, boolean theme) {
        return this.actions.shouldShow(dockable, theme);
    }

    public ButtonContentCondition getFilterActions() {
        return this.filterActions;
    }

    public boolean showIcon(Dockable dockable, boolean theme) {
        return this.icon.shouldShow(dockable, theme);
    }

    public ButtonContentCondition getIcon() {
        return this.icon;
    }

    public boolean showText(Dockable dockable, boolean theme) {
        return this.text.shouldShow(dockable, theme);
    }

    public ButtonContentCondition getText() {
        return this.text;
    }

    public boolean showChildren(Dockable dockable, boolean theme) {
        return this.children.shouldShow(dockable, theme);
    }

    public ButtonContentCondition getChildren() {
        return this.children;
    }
}

