/*
 * Decompiled with CFR 0.152.
 */
package org.odftoolkit.odfdom;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import java.util.logging.Level;
import java.util.logging.Logger;

public class JarManifest {
    private static final String CURRENT_CLASS_RESOURCE_PATH = "org/odftoolkit/odfdom/JarManifest.class";
    private static final String MANIFEST_JAR_PATH = "META-INF/MANIFEST.MF";
    private static String ODFDOM_NAME;
    private static String ODFDOM_VERSION;
    private static String ODFDOM_WEBSITE;
    private static String ODFDOM_BUILD_BY;
    private static String ODFDOM_BUILD_DATE;
    private static String ODFDOM_SUPPORTED_ODF_VERSION;

    private static InputStream getManifestAsStream() {
        String versionRef = JarManifest.class.getClassLoader().getResource(CURRENT_CLASS_RESOURCE_PATH).toString();
        String manifestRef = versionRef.substring(0, versionRef.lastIndexOf(CURRENT_CLASS_RESOURCE_PATH)) + MANIFEST_JAR_PATH;
        URL manifestURL = null;
        InputStream in = null;
        try {
            manifestURL = new URL(manifestRef);
        }
        catch (MalformedURLException ex) {
            Logger.getLogger(JarManifest.class.getName()).log(Level.SEVERE, null, ex);
        }
        try {
            in = manifestURL.openStream();
        }
        catch (IOException ex) {
            Logger.getLogger(JarManifest.class.getName()).log(Level.SEVERE, null, ex);
        }
        return in;
    }

    private JarManifest() {
    }

    public static void main(String[] args) throws IOException {
        System.out.println(JarManifest.getOdfdomTitle() + " (build " + JarManifest.getOdfdomBuildDate() + ')' + "\nfrom " + JarManifest.getOdfdomWebsite() + " supporting ODF " + JarManifest.getOdfdomVersion());
    }

    public static String getOdfdomName() {
        return ODFDOM_NAME;
    }

    public static String getOdfdomTitle() {
        return JarManifest.getOdfdomName() + ' ' + JarManifest.getOdfdomVersion();
    }

    public static String getOdfdomVersion() {
        return ODFDOM_VERSION;
    }

    public static String getOdfdomWebsite() {
        return ODFDOM_WEBSITE;
    }

    public static String getOdfdomBuildResponsible() {
        return ODFDOM_BUILD_BY;
    }

    public static String getOdfdomBuildDate() {
        return ODFDOM_BUILD_DATE;
    }

    public static String getOdfdomSupportedOdfVersion() {
        return ODFDOM_SUPPORTED_ODF_VERSION;
    }

    static {
        try {
            Manifest manifest = new Manifest(JarManifest.getManifestAsStream());
            Attributes attr = manifest.getEntries().get("ODFDOM");
            ODFDOM_NAME = attr.getValue("ODFDOM-Name");
            ODFDOM_VERSION = attr.getValue("ODFDOM-Version");
            ODFDOM_WEBSITE = attr.getValue("ODFDOM-Website");
            ODFDOM_BUILD_BY = attr.getValue("ODFDOM-Built-By");
            ODFDOM_BUILD_DATE = attr.getValue("ODFDOM-Built-Date");
            ODFDOM_SUPPORTED_ODF_VERSION = attr.getValue("ODFDOM-Supported-Odf-Version");
        }
        catch (Exception e) {
            Logger.getLogger(JarManifest.class.getName()).log(Level.SEVERE, null, e);
        }
    }
}

