### R code from vignette source 'csm.rnw'

###################################################
### code chunk number 1: csm.rnw:29-33
###################################################
options(continue=" ",width=60,digits=2)
options(useFancyQuotes=FALSE)  #Fixes problems with character substitution
options(SweaveHooks=list(fig=function()
par(mar=c(5.1, 4.1, 1.1, 2.1))))


###################################################
### code chunk number 2: csm.rnw:51-53
###################################################
require(wild1)
data(coyote.mort)


###################################################
### code chunk number 3: csm.rnw:58-59
###################################################
str(coyote.mort,strict.width="cut")


###################################################
### code chunk number 4: csm.rnw:62-64
###################################################
oldwidth<- getOption("width")
options(width=60)


###################################################
### code chunk number 5: csm.rnw:66-67
###################################################
head(coyote.mort)


###################################################
### code chunk number 6: csm.rnw:69-70
###################################################
options(width=oldwidth)


###################################################
### code chunk number 7: csm.rnw:87-88
###################################################
table(coyote.mort$fate)


###################################################
### code chunk number 8: csm.rnw:92-93
###################################################
head(with(coyote.mort,n.risk(entry,exit,1)))


###################################################
### code chunk number 9: csm.rnw:100-104
###################################################
harvest <- c("snare","shot","trap")
cause1 <- with(coyote.mort,
  csm(entry=entry, exit=exit, event=event, 
    fate=fate, cause=harvest, alpha=0.10))


###################################################
### code chunk number 10: csm.rnw:108-110
###################################################
vars <- c("time","CIF","lcl.90","ucl.90")
na.omit(cause1[vars])


###################################################
### code chunk number 11: curves1
###################################################
plot(cause1)


###################################################
### code chunk number 12: csm.rnw:129-136
###################################################
other <- c("strife","car","unknown nat")
cause.lst <- list(harvest=harvest, other=other)
csm.lst <- lapply(cause.lst,function(cause.vec){
  with(coyote.mort,
    csm(entry=entry, exit=exit, event=event, 
      fate=fate, cause=cause.vec, alpha=0.10))})  
str(csm.lst)


###################################################
### code chunk number 13: csm.rnw:140-142
###################################################
lapply(csm.lst,function(output){
  tail(na.omit(output[vars]),1)})


###################################################
### code chunk number 14: curves2
###################################################
plot(csm.lst[[1]],alpha=NULL,href=FALSE,ylim=c(0,1))
plot(csm.lst[[2]],alpha=NULL,add=TRUE,href=FALSE,
  lty=2, lwd=2)


