betahat.app           package:approximator           R Documentation

_E_s_t_i_m_a_t_e _f_o_r _b_e_t_a

_D_e_s_c_r_i_p_t_i_o_n:

     Returns the estimator for beta; equation 5.  Function
     'betahat.app()' returns the estimate in terms of fundamental
     variables; 'betahat.app.H()' requires the 'H' matrix.

_U_s_a_g_e:

     betahat.app.H(H, V = NULL, Vinv = NULL, z)
     betahat.app(D1, subsets, basis, hpa, z, use.Vinv=TRUE)

_A_r_g_u_m_e_n_t_s:

       H: In 'betahat.app.H()', the H matrix, eg that returned by
          'H.fun()'

       V: Variance matrix

    Vinv: Inverse of variance matrix.  If not supplied, it is
          calculated

use.Vinv: In function 'betahat.app()', a Boolean argument with default
          'TRUE' meaning to calculate the inverse of the 'V' matrix;
          and 'FALSE' meaning to use a method which does not involve
          calculating the inverse of 'V'.  The default method seems to
          be faster; YMMV

       z: vector of observations

      D1: Design matrix for level 1 code

 subsets: Subsets object

   basis: Basis function

     hpa: Hyperparameter object

_A_u_t_h_o_r(_s):

     Robin K. S. Hankin

_R_e_f_e_r_e_n_c_e_s:

     M. C. Kennedy and A. O'Hagan 2000. "Predicting the output from a
     complex computer code when fast approximations are available"
     Biometrika, 87(1): pp1-13

_E_x_a_m_p_l_e_s:

     data(toyapps)

      betahat.app(D1=D1.toy, subsets=subsets.toy, basis=basis.toy, hpa=hpa.toy, z=z.toy, use.Vinv=TRUE)

      H <- H.fun.app(D1=D1.toy, subsets=subsets.toy, basis=basis.toy,hpa=hpa.toy)
      V <- V.fun.app(D1=D1.toy, subsets=subsets.toy, hpa=hpa.toy)
      betahat.app.H(H=H,V=V,z=z.toy)

