tt.fun              package:calibrator              R Documentation

_I_n_t_e_g_r_a_l_s _n_e_e_d_e_d _i_n _K_O_H_2_0_0_1

_D_e_s_c_r_i_p_t_i_o_n:

     Calculates the three integrals needed for 'V', under the
     restrictions specified in the KOH2001 supplement.

_U_s_a_g_e:

     tt.fun(D1, extractor, x.i, x.j,  test.for.symmetry=FALSE, method=1, phi)
     ht.fun(x.i, x.j, D1, extractor,  Edash.theta,  H1, fast.but.opaque=TRUE,
     x.star=NULL, t.vec=NULL, phi) 
     hh.fun(x.i, x.j,  H1, E.theta,  phi)
     t.fun(x, D1, extractor,  phi) 

_A_r_g_u_m_e_n_t_s:

      D1: Matrix of code run points

      H1: regression basis functions for 'D1'

extractor: Function to extract 'x.star' and 't.vec' from 'D1'

       x: Lat and long of a point in 't.fun()' (eg 'D2[1,]')

     x.i: Lat and long of first point (eg 'D2[1,]')

     x.j: Lat and long of second point (eg 'D2[2,]')

   theta: parameters

Edash.theta: Function to return expectation of 'H' with respect to the
          alternative distribution of theta; 'Edash.theta.toy' is the
          example for the toy dataset

 E.theta: Function to return expectation of 'H' with respect to theta

test.for.symmetry: In 'tt.fun()', Boolean with 'TRUE' meaning to
          calculate each element of C explicitly.  If 'FALSE', then
          calculate only the elements of C that lie on or over the
          diagonal and use the fact that C is symmetric to calculate
          the other matrix elements.  For n observations, this means
          n(n+1)/2 evaluations, compared with n^2 for the full case.

          Set this argument to 'TRUE' only when debugging, or testing
          accuracy.

fast.but.opaque: In 'ht.fun()', Boolean with default 'TRUE' meaning to
          pass some precalculated results as arguments, to save time. 
          Set this argument to 'FALSE' only when debugging.

  x.star: In 'ht.fun()', value of xstar (required only if
          'fast.but.opaque' is 'TRUE')

   t.vec: In 'ht.fun()', value of t (required only if 'fast.but.opaque'
          is 'TRUE')

  method: In 'tt.fun()', zero means use the old method and nonzero
          means use the new method.  The new method is faster, but the
          code is harder to understand.  The two methods should give
          identical results.

     phi: Hyperparameters

_D_e_t_a_i_l_s:

     The four functions return integrals representing means taken over
     'theta'.  To wit:

        *  Function 'tt.fun()' evaluates 

           int t(x_j,theta)t(x_i,theta)^T p(theta) d(theta)

           and is used in 'V.fun()'.  Note that this function is
           symmetric in x_i and x_j.

        *  Function 'ht.fun()' evaluates 

          int h_1(x_j,theta)t(x_i,theta)^T p(theta) d(theta)

           and is used in 'V.fun()'.  Note that this function is {\bf
           not} symmetric in x_i and x_j.

        *  Function 'hh.fun()' evaluates 

         int h_1(x_j,theta)h_1(x_i,theta)^T p(theta) d(theta)

           and is used in 'V.fun()'.  Note that this function is
           symmetric in x_i and x_j.

        *  Function 't.fun()' evaluates

                int  t(x_i,theta)^T p(theta) d(theta)

           using the formula 

                          <omitted; see pdf>

           It is used in 'Ez_eq7.supp()'.  NB: do not confuse this
           function with 'tee()', which is different.

     These functions are not generally of much interest to the end
     user; they are called by 'V.fun()'.  They are defined separately
     as a debugging aid, and to simplify the structure of 'V.fun()'.

_V_a_l_u_e:

     Each function returns a matrix as described in KOH2001.

_A_u_t_h_o_r(_s):

     Robin K. S. Hankin

_R_e_f_e_r_e_n_c_e_s:

     M. C. Kennedy and A. O'Hagan 2001. "Bayesian calibration of
     computer models".  Journal of the Royal Statistical Society B,
     63(3) pp425-464

     M. C. Kennedy and A. O'Hagan 2001.  "Supplementary details on
     Bayesian calibration of computer models", Internal report,
     University of Sheffield.  Available at <URL:
     http://www.shef.ac.uk/~st1ao/ps/calsup.ps>

     R. K. S. Hankin 2005. "Introducing BACCO, an R bundle for Bayesian
     analysis of computer code output", Journal of Statistical
     Software, 14(16)

_S_e_e _A_l_s_o:

     'V.fun'

_E_x_a_m_p_l_e_s:

     data(toys)

     tt.fun(D1=D1.toy, extractor=extractor.toy, x.i=D2.toy[1,],
         x.j=D2.toy[2,],  phi=phi.toy)

     ht.fun(x.i=D2.toy[1,], x.j=D2.toy[2,], D1=D1.toy,
         extractor=extractor.toy, 
         Edash.theta=Edash.theta.toy, H1=H1.toy, fast.but.opaque=FALSE, phi=phi.toy)

     ht.fun(x.i=D2.toy[1,], x.j=D2.toy[2,], D1=D1.toy,
         extractor=extractor.toy, 
         Edash.theta=Edash.theta.toy, H1=H1.toy, fast.but.opaque=TRUE,
         x.star=extractor.toy(D1.toy)$x.star, t.vec=extractor.toy(D1.toy)$t.vec,
         phi=phi.toy)


     hh.fun(x.i=D2.toy[1,], x.j=D2.toy[2,],
         H1=H1.toy, E.theta=E.theta.toy,  phi=phi.toy)

     t.fun(x=x.toy, D1=D1.toy, extractor=extractor.toy, phi=phi.toy)

