### Name: bart
### Title: Bayesian Additive Regression Trees
### Aliases: bart
### Keywords: nonparametric tree

### ** Examples

data(cheese)
##weekly data.
##first three columns are dummies indicating which of three New York retailers the data is from.
##the fourth column is the log of price.
##the fifth column is measure of how often the item is advertised through an in-store display.
##the sixth column is the log of weekly sales volume, which we treat as the dependent variable.

##fit bart
##note that you use all the dummies in the x for bart!
x=as.matrix(cheese[,1:5]) 
y=cheese[,6] 
set.seed(99) 
bartFit = bart(x,y)

##fit linear model
##drop the first dummy for linear regression
lmFit = lm(y~.,cheese[,2:6]) 

##compare fits
cat("Squared correlation between y and fits (R^2) from linear model:", cor(y,lmFit$fitted)^2,"\n",
"Squared correlation from bart model:", cor(y,bartFit$yhat.train.mean)^2,"\n")

##I got .75 for the linear model and .89 for bart, so bart has better in-sample fit.
##Of course, out-of-sample is always another matter.



