mal.eq                package:Biodem                R Documentation

_C_a_l_c_u_l_a_t_e_s _t_h_e _a_s_y_m_p_t_o_t_i_c _g_e_n_e_r_a_t_i_o_n _f_o_r _t_h_e _M_a_l_e_c_o_t _m_o_d_e_l

_D_e_s_c_r_i_p_t_i_o_n:

     Mal.eq calculates the Malecot model iteratively, stopping when one
     more cycle adds 0 to every value of the matrix obtained by the
     model. Once equilibrium is reached, Mal.eq returns the number of
     cycles ("generations") needed to reach it.

_U_s_a_g_e:

     mal.eq(S, P, N)

_A_r_g_u_m_e_n_t_s:

       S: is the Sistematic pressure matrix. 

       P: is the colum-stochastic migration matrix. 

       N: is the vector of effective population size. 

_D_e_t_a_i_l_s:

     The use of mal.eq is necessary before the calculation of the
     Malecot model proper because the value returned by Mal.eq is one
     of the arguments of the Malecot model function Phi.

_V_a_l_u_e:

     Returns one numeric value.

_N_o_t_e:

     This function has been coerced to use "only" six significant
     digits. ...

_A_u_t_h_o_r(_s):

     Federico C. F. Calboli f.calboli@imperial.ac.uk

_R_e_f_e_r_e_n_c_e_s:

     Imaizumi, Y., N. E. Morton and D. E. Harris. 1970. Isolation by
     distance in artificial populations. Genetics 66: 569-582.

     Jorde, L. B. 1982. The genetic structure of the Utah mormons:
     migration analysis. Human Biology 54(3): 583-597.

     Swedlund, A. C., L. B. Jorde and J. H. Mielke. 1984. Population
     structure in the Connecticut valley. I. Marital migration.
     American Journal of Physical Anthropology 65: 61-70

_S_e_e _A_l_s_o:

     'mal.phi' for the function using the output of 'mal.eq'

_E_x_a_m_p_l_e_s:

     # the data is originally from a paper by Swedlund et al. 1984.
     data(S); data(P); data(N)
     mal.eq(S,P,N)

