### Name: binobp
### Title: Binomial sampling with a beta prior
### Aliases: binobp
### Keywords: misc

### ** Examples

## simplest call with 6 successes observed in 8 trials and a Beta(1,1) uniform 
## prior
binobp(6,8)

## 6 successes observed in 8 trials and a non-uniform Beta(0.5,6) prior
binobp(6,8,0.5,6)

## 4 successes observed in 12 trials with a non uniform Beta(3,3) prior
## plot the stored prior, likelihood and posterior
results<-binobp(4,12,3,3,ret=TRUE)

par(mfrow=c(3,1))
y.lims<-c(0,1.1*max(results$posterior,results$prior))

plot(results$theta,results$prior,ylim=y.lims,type="l"
        ,xlab=expression(theta),ylab="Density",main="Prior")
polygon(results$theta,results$prior,col="red")

plot(results$theta,results$likelihood,ylim=c(0,0.25),type="l"
        ,xlab=expression(theta),ylab="Density",main="Likelihood")
polygon(results$theta,results$likelihood,col="green")

plot(results$theta,results$posterior,ylim=y.lims,type="l"
        ,xlab=expression(theta),ylab="Density",main="Posterior")
polygon(results$theta,results$posterior,col="blue")





