### Name: binodp
### Title: Binomial sampling with a discrete prior
### Aliases: binodp
### Keywords: misc

### ** Examples

## simplest call with 6 successes observed in 8 trials and a uniform prior
binodp(6,8)

## same as previous example but with more possibilities for theta
binodp(6,8,n.theta=100)

## 6 successes, 8 trials and a non-uniform discrete prior
theta<-seq(0,1,by=0.01)
theta.prior<-runif(101)
theta.prior<-sort(theta.prior/sum(theta.prior))
binodp(6,8,uniform=FALSE,theta=theta,theta.prior=theta.prior)

## 5 successes, 6 trials, non-uniform prior
theta<-c(0.3,0.4,0.5)
theta.prior<-c(0.2,0.3,0.5)
results<-binodp(5,6,uniform=FALSE,theta=theta,theta.prior=theta.prior,ret=TRUE)

## plot the results from the previous example using a side-by-side barplot
results.matrix<-rbind(results$theta.prior,results$posterior)
colnames(results.matrix)<-theta
barplot(results.matrix,col=c("red","blue"),beside=TRUE
        ,xlab=expression(theta),ylab=expression(Probability(theta)))
box()
legend(1,0.65,legend=c("Prior","Posterior"),fill=c("red","blue"))



