### Name: CTFS.biomass
### Title: Overview of Analysis of the Biomass Dynamics of Tropical Tree
###   Populations
### Aliases: CTFS.biomass
### Keywords: univar

### ** Examples
## Not run: 
##D plotdim=c(1000,500)
##D gridsize=20
##D bci.agb <- biomass(bci90.full,bci95.full,mult1=bci90.mult,mult2=bci95.mult,wsgfile=wsg.ctfs,forest="moist")
##D bciquad.vct <- gxgy.to.index(bci90.full$gx,bci90.full$gy)
##D bciquad.agbt1 <- tapply(bci.agb$AGBt1,bciquad.vct,sum,na.rm=TRUE)/1000
##D x=seq(gridsize/2,plotdim[1]-gridsize/2,gridsize)
##D y=seq(gridsize/2,plotdim[2]-gridsize/2,gridsize)
##D agbt1.mat=matrix(bciquad.agbt1,nrow=length(x),ncol=length(y),byrow=TRUE)
##D image(x,y,z=agbt1.mat,col=topo.colors(6),xlab='AGB 1990 (tons)',xlim=c(0,plotdim[1]),ylim=c(0,plotdim[2]))
## End(Not run)


