### Name: abundance
### Title: Abundance of Trees by Categories (User Defined Groups)
### Aliases: abundance
### Keywords: univar

### ** Examples
## Not run: 
##D 1. Default use of abundance
##D abund.out <- abundance(tst.bci90.full)
##D names(abund.out)
##D abund.out$N
##D abund.out[[1]]
##D 
##D 2. Create vectors that categorize each tree by species name 
##D and habitat.  This is the same process are used for other dynamic 
##D functions (eg growth, abundance) but the vectors made MUST be put 
##D together as a list.
##D 
##D spp.vct <- tst.bci9095.full$sp
##D hab.vct <- sep.quadinfo(tst.bci9095.full,bciquad.info,by.col="hab")->hab.vct
##D abund.hab <- abundance("tst.bci9095.full",split1=hab.vct)
##D 
##D 3. Create vectors that define the quadrate of tree and species to run 
##D with abundance().  Compare to result of abundance.quad() 
##D 
##D NOTE: the number of dimensions in the returned arrays may NOT be equal to the
##D number of quadrates in the plot if the census data used did not have
##D at least 1 tree in each quadrate.  Note the results of these test
##D files.
##D 
##D spp.vct <- tst.bci90.full$sp
##D 
##D create a vector of quadrates, 2 ways to do it:
##D 
##D quad.vct <- gxgy.to.index(tst.bci90.full$gx,tst.bci90.full$gy,gridsize=20,plotdim=c(1000,500))
##D quad.vct <- sep.quadinfo(tst.bci90.full,bciquad.info,by.col="quad")
##D 
##D run abundance() and abundance.quad() and compare results
##D 
##D abund.sp.quad.out <- abundance(tst.bci90.full,split1=spp.vct,split2=quad.vct)
##D abund.quad.out <- abundance.quad(tst.bci90.full,gridsize=20)
##D identical(abund.sp.quad.out[[1]],abund.quad.out[[1]])
## End(Not run)



