### Name: find.climits
### Title: Computes 95% CI for a Survivorship
### Aliases: find.climits
### Keywords: univar

### ** Examples
## Not run: 
##D # N0 = 100, Dead = 5, Recruits = 10, time = 5 yrs, therefore: 
##D # S = N0 - Dead = 100 - 5 = 95
##D # N1 = N0 - Dead + Recruits = 100 - 5 + 10 = 105
##D 
##D # find CI limits for mortality
##D SM.upper <- find.climits(100,95,kind="upper")
##D SM.lower <- find.climits(100,95,kind="lower")
##D mort.rate.upper <- ( log(N0) - log(SM.lower) ) / 5
##D mort.rate.lower <- ( log(N0) - log(SM.upper) ) / 5
##D 
##D # find CI limits for recruitment
##D SR.upper <- find.climits(105,95,kind="upper")
##D SR.lower <- find.climits(105,95,kind="lower")
##D rec.rate.upper <- ( log(N1) - log(SR.lower) ) / 5
##D rec.rate.lower <- ( log(N1) - log(SR.upper) ) / 5
##D 
## End(Not run)


