### Name: mortality
### Title: Annual Mortality Rates by Categories (User defined groups)
### Aliases: mortality
### Keywords: univar

### ** Examples
## Not run: 
##D 
##D 1. Default use of mortality()
##D mort.out <- mortality(tst.bci90.full, tst.bci95.full)
##D mort.out
##D 
##D 2. Create a vector of species names for each tree to compute mortality 
##D rates for each species.
##D 
##D spp.vct <- tst.bci90.full$sp
##D mort.spp.out <- mortality(tst.bci90.full, tst.bci95.full, split1 = spp.vct)
##D 
##D 3. Create 2 vectors: the first of habitats based on the quad location 
##D of each tree and the second of tree species names.
##D 
##D habitat.vct <- sep.quadinfo(tst.bci90.full, bciquad.info, by.col = "hab")
##D spp.vct <- tst.bci90.full$sp
##D 
##D mort.spp.hab.out <- mortality(tst.bci90.full, tst.bci95.full, split1=spp.vct, split2=habitat.vct)
## End(Not run)



