### Name: sep.data
### Title: Re-structures a Dataframe into a List of Dataframes by Values in
###   a Vector
### Aliases: sep.data sep.vct.data
### Keywords: manip

### ** Examples
## Not run: 
##D 1. default use
##D tst.out <- sep.data(tst.bci90.full)
##D names(tst.out)
##D 
##D 2. separate data by status
##D tst.out <- sep.data(tst.bci90.full,sepcol="status")
##D names(tst.out)
##D 
##D 3. separate data by status including the NAs as the last component in 
##D the list
##D tst.out <- sep.date(tst.bci90.full,sepcol="status",handle.na=TRUE)
##D names(tst.out)
##D 
##D 4. separate date by quadrate (which is useful for neighborhood
##D analysis), leave NAs out of the list
##D 
##D quad.vct <- sep.quadinfo(tst.bci90.full,bciquad.info,by.col="quad")
##D tst.vct.out <- sep.data.vct(tst.bci90.full,quad.vct)
##D names(tst.vct.out)
## End(Not run)



