wrpcauchy.ml            package:CircStats            R Documentation

_W_r_a_p_p_e_d _C_a_u_c_h_y _M_a_x_i_m_u_m _L_i_k_e_l_i_h_o_o_d _E_s_t_i_m_a_t_e_s

_D_e_s_c_r_i_p_t_i_o_n:

     Computes the maximum likelihood estimates of the location and
     scale parameters for a wrapped Cauchy distribution.

_U_s_a_g_e:

     wrpcauchy.ml(x, mu0, rho0, acc=1e-015)

_A_r_g_u_m_e_n_t_s:

       x: vector of angular data measured in radians.

     mu0: initial estimate of the location parameter.

    rho0: initial estimate of the scale parameter.  rho0 should be
          between in [0,1).

     acc: degree of accuracy in the approximation of the estimates. 
          The default value is 1e-15.  See below for details.

_D_e_t_a_i_l_s:

     An iterative algorithm due to Kent and Tyler (1988) is used. 
     Initial values of the MLE's are required.  In the estimation
     process, estimates of quantities mu1 and mu2 (see Kent and Tyler)
     are updated iteratively.  When both mu1 and mu2 change by less
     than acc from one iteration to the next, the process ends, and mu
     and rho are computed from the final estimates of mu1 and mu2.

_V_a_l_u_e:

     A dataframe is returned with the variables mu and rho, where mu
     and rho are the approximations of the MLE of the location  and
     scale parameter, respectively.

_R_e_f_e_r_e_n_c_e_s:

     Kent, J. and Tyler, D. (1988).  Maximum likelihood estimation for
     the wrapped Cauchy distribution.  Journal of Applied Statistics,
     15, 2, 247-254.

     Jammalamadaka, S. Rao and SenGupta, A. (2001). Topics in Circular
     Statistics, Section 4.4, World Scientific Press, Singapore.

_S_e_e _A_l_s_o:

     dwrpcauchy, rwrpcauchy

_E_x_a_m_p_l_e_s:

     # Generate data from a wrapped Cauchy distribution.
     data <- rwrpcauchy(50, 0, 0.75)
     # Compute the sample mean direction and resultant length.
     mu0 <- circ.mean(data)
     rho0 <- est.rho(data)
     # Estimate the MLE's of the Cauchy distribution parameters.
     wrpcauchy.ml(data, mu0, rho0)

