### Name: DEoptim-methods
### Title: DEoptim-methods
### Aliases: DEoptim-methods plot.DEoptim summary.DEoptim
### Keywords: methods

### ** Examples

  ## Rosenbrock Banana function
  Rosenbrock <- function(x){
  x1 <- x[1]
  x2 <- x[2]
  100 * (x2 - x1 * x1)^2 + (1 - x1)^2
  }

  lower <- c(-10,-10)
  upper <- -lower
  r <- DEoptim(Rosenbrock, lower, upper)
  summary(r) ## print summary of the DEoptim object
  
  par(mfrow = c(1,2))
  plot(r, type = 'b') ## plot the best members
  plot(r, plot.type = "bestvalit", type = 'b', col = 'blue') ## and the best values



